<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ __('translate.404') }}</title>
    <link rel="shortcut icon" href="{{asset($general_setting->favicon)}}" type="image/x-icon">
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">

    <link rel="stylesheet" href="{{ asset('frontend/css/style.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/responsive.css')}}">

</head>

<body>

    <main>

        <div class="error">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-xxl-8">
                        <div class="error_thumb">
                            <span>
                                <svg viewBox="0 0 843 440" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g opacity="0.14">
                                        <path
                                            d="M48.6757 379.408C42.8021 379.408 36.9287 378.073 31.5 375.314L33.9028 370.509C43.0692 375.137 53.6594 375.226 62.9148 370.776L69.5006 367.572C80.8028 362.143 94.0631 362.677 104.92 368.818C114.621 374.336 126.368 374.602 136.246 369.53L138.738 368.284C150.13 362.499 163.568 362.677 174.781 368.818L175.137 368.996C184.926 374.425 196.585 374.514 206.463 369.352L208.065 368.551C219.545 362.499 233.072 362.677 244.463 368.907L245.442 369.441C254.52 374.425 265.733 374.335 274.721 369.085C285.668 362.677 298.928 362.321 310.23 367.928L315.303 370.509C324.291 374.959 334.971 374.959 343.959 370.509L349.566 367.75C360.601 362.232 373.594 362.499 384.274 368.462L386.143 369.53C395.398 374.602 406.522 374.87 415.956 370.153L420.227 368.017C431.53 362.321 444.79 362.766 455.736 369.174C464.902 374.514 476.027 374.958 485.638 370.42L491.423 367.661C502.725 362.232 515.985 362.855 526.754 369.352C535.297 374.514 546.066 374.78 554.876 369.975L557.101 368.818C568.403 362.677 582.108 362.588 593.5 368.462L596.08 369.797C605.87 374.78 617.528 374.781 627.228 369.619L629.275 368.551C640.577 362.677 654.016 362.588 665.318 368.373L667.632 369.53C677.688 374.691 689.525 374.514 699.403 368.996C710.705 362.766 724.321 362.499 735.891 368.284L739.717 370.153C749.151 374.87 760.275 374.514 769.441 369.174C780.388 362.766 793.648 362.499 804.861 368.373C815.986 374.247 829.335 374.247 840.459 368.551L842.862 373.268C830.135 379.764 815.006 379.675 802.369 373.09C792.758 368.017 781.455 368.284 772.111 373.802C761.432 380.031 748.439 380.476 737.315 374.959L733.488 373.09C723.52 368.106 711.773 368.373 701.984 373.713C690.592 380.031 676.798 380.209 665.14 374.336L662.826 373.179C653.037 368.195 641.378 368.195 631.678 373.357L629.631 374.424C618.329 380.298 604.891 380.387 593.589 374.603L591.007 373.268C581.129 368.195 569.382 368.284 559.504 373.624L557.279 374.781C546.866 380.387 534.051 380.12 523.906 373.98C514.65 368.462 503.348 367.928 493.648 372.556L487.863 375.314C476.739 380.654 463.657 380.12 452.978 373.891C443.633 368.462 432.242 368.106 422.541 372.912L418.27 375.048C407.234 380.565 394.241 380.298 383.562 374.336L381.693 373.268C372.438 368.195 361.313 367.928 351.88 372.645L346.273 375.404C335.861 380.654 323.312 380.654 312.9 375.404L307.828 372.823C298.127 368.017 286.736 368.373 277.391 373.802C266.801 379.942 253.541 380.12 242.862 374.247L241.883 373.713C232.182 368.373 220.435 368.195 210.556 373.357L208.955 374.158C197.474 380.209 183.858 380.031 172.556 373.802L172.2 373.624C162.589 368.284 151.019 368.106 141.141 373.179L138.649 374.424C127.08 380.298 113.464 380.031 102.251 373.624C92.9061 368.284 81.4258 367.928 71.7254 372.556L65.1397 375.759C59.978 378.162 54.2824 379.408 48.6757 379.408Z"
                                            fill="#9EA3AE" />
                                        <path
                                            d="M329.549 406.758C323.853 406.758 318.069 405.423 312.818 402.843L307.745 400.262C298.045 395.456 286.653 395.812 277.309 401.241C266.719 407.381 253.459 407.559 242.779 401.686L241.8 401.152C232.1 395.723 220.353 395.634 210.475 400.796L208.872 401.597C197.392 407.648 183.776 407.47 172.474 401.241L172.118 401.063C162.507 395.723 150.937 395.545 141.059 400.618L138.567 401.864L136.164 397.147L138.656 395.901C150.047 390.116 163.485 390.294 174.699 396.435L175.055 396.613C184.844 402.042 196.502 402.131 206.381 396.969L207.982 396.168C219.463 390.116 232.99 390.294 244.381 396.524L245.36 397.058C254.438 402.042 265.651 401.953 274.639 396.702C285.586 390.295 298.846 389.938 310.148 395.545L315.221 398.126C324.209 402.576 334.889 402.576 343.877 398.126L349.484 395.367C360.519 389.85 373.512 390.116 384.191 396.079L386.06 397.147C395.316 402.22 406.44 402.487 415.873 397.77L420.145 395.634C431.447 389.938 444.708 390.383 455.654 396.791C464.821 402.131 475.945 402.576 485.556 398.037L491.341 395.278C502.643 389.849 515.903 390.472 526.671 396.969C535.215 402.131 545.983 402.398 554.794 397.592L557.019 396.435C568.321 390.294 582.026 390.205 593.417 396.079L595.998 397.414C605.787 402.398 617.446 402.398 627.146 397.236L629.193 396.168C640.495 390.294 653.934 390.205 665.236 395.99L667.549 397.147C677.606 402.309 689.442 402.131 699.321 396.613C710.623 390.383 724.239 390.116 735.808 395.901L733.405 400.707C723.438 395.723 711.691 395.99 701.901 401.33C690.51 407.648 676.716 407.826 665.058 401.953L662.744 400.796C652.954 395.812 641.296 395.812 631.596 400.974L629.549 402.042C618.247 407.915 604.809 408.004 593.506 402.22L590.926 400.885C581.047 395.812 569.3 395.901 559.421 401.241L557.196 402.398C546.784 408.004 533.969 407.737 523.823 401.597C514.568 396.079 503.266 395.545 493.565 400.173L487.781 402.932C476.656 408.271 463.575 407.737 452.895 401.508C443.551 396.079 432.159 395.723 422.459 400.529L418.187 402.665C407.152 408.182 394.159 407.915 383.48 401.953L381.611 400.885C372.355 395.812 361.231 395.545 351.798 400.262L346.191 403.021C341.029 405.423 335.245 406.758 329.549 406.758Z"
                                            fill="#9EA3AE" />
                                        <path
                                            d="M193.385 439.446C187.689 439.446 181.905 438.111 176.654 435.53L171.581 432.949C161.881 428.144 150.49 428.5 141.145 433.928C130.555 440.069 117.295 440.247 106.615 434.373L105.636 433.839C95.8469 428.411 84.1887 428.322 74.3103 433.483L72.7084 434.284C61.2281 440.336 47.612 440.158 36.3098 433.928L35.9539 433.75C26.3425 428.411 14.7731 428.233 4.89469 433.305L2.40281 434.551L0 429.835L2.49189 428.589C13.8832 422.804 27.3213 422.982 38.5346 429.123L38.8905 429.301C48.6799 434.729 60.3383 434.818 70.2167 429.656L71.8184 428.856C83.2987 422.804 96.826 422.982 108.217 429.211L109.196 429.745C118.273 434.729 129.487 434.64 138.475 429.39C149.422 422.982 162.682 422.626 173.984 428.233L179.057 430.813C188.045 435.263 198.725 435.263 207.713 430.813L213.32 428.055C224.355 422.537 237.348 422.804 248.027 428.766L249.896 429.835C259.152 434.907 270.276 435.174 279.709 430.457L283.981 428.321C295.283 422.626 308.544 423.071 319.49 429.478C328.656 434.818 339.78 435.263 349.392 430.725L355.176 427.966L357.49 432.771L351.706 435.53C340.581 440.87 327.5 440.336 316.82 434.106C307.476 428.677 296.084 428.322 286.384 433.127L282.112 435.263C271.077 440.781 258.084 440.514 247.405 434.551L245.536 433.483C236.28 428.411 225.156 428.144 215.723 432.86L210.116 435.619C204.865 438.111 199.08 439.446 193.385 439.446Z"
                                            fill="#9EA3AE" />
                                        <path
                                            d="M673.064 434.106C667.369 434.106 661.584 432.771 656.334 430.19L651.261 427.609C641.56 422.804 630.169 423.159 620.824 428.588C610.234 434.729 596.974 434.907 586.295 429.033L585.316 428.499C575.615 423.071 563.868 422.981 553.99 428.143L552.388 428.944C540.908 434.996 527.292 434.818 515.989 428.588L515.633 428.41C506.022 423.07 494.453 422.893 484.574 427.965L482.082 429.211L479.68 424.494L482.171 423.248C493.563 417.464 507.001 417.642 518.214 423.782L518.57 423.96C528.359 429.389 540.018 429.478 549.896 424.316L551.498 423.515C562.978 417.464 576.505 417.642 587.897 423.871L588.876 424.405C597.953 429.389 609.166 429.3 618.155 424.05C629.101 417.642 642.361 417.286 653.664 422.893L658.736 425.473C667.725 429.923 678.404 429.923 687.393 425.473L692.999 422.715C704.034 417.197 717.027 417.464 727.707 423.426L729.576 424.494C738.831 429.567 749.955 429.834 759.389 425.117L763.66 422.981C774.963 417.286 788.223 417.731 799.17 424.138C808.336 429.478 819.46 429.923 829.071 425.384L834.856 422.626L837.17 427.431L831.385 430.19C820.261 435.53 807.179 434.996 796.5 428.766C787.155 423.337 775.764 422.982 766.063 427.787L761.792 429.923C750.757 435.441 737.763 435.174 727.084 429.211L725.215 428.143C715.96 423.07 704.835 422.804 695.402 427.52L689.795 430.279C684.544 432.771 678.76 434.106 673.064 434.106Z"
                                            fill="#9EA3AE" />
                                    </g>
                                    <path
                                        d="M313.157 160.807C351.166 160.807 381.979 129.995 381.979 91.986C381.979 53.977 351.166 23.1647 313.157 23.1647C275.148 23.1647 244.336 53.977 244.336 91.986C244.336 129.995 275.148 160.807 313.157 160.807Z"
                                        fill="white" />
                                    <path
                                        d="M313.158 162.794C274.115 162.794 242.352 131.031 242.352 91.9879C242.352 52.9451 274.115 21.1814 313.158 21.1814C352.201 21.1814 383.965 52.9451 383.965 91.9879C383.965 131.031 352.201 162.794 313.158 162.794ZM313.158 25.1519C276.299 25.1519 246.322 55.1288 246.322 91.9879C246.322 128.847 276.299 158.824 313.158 158.824C350.017 158.824 379.994 128.847 379.994 91.9879C379.994 55.1288 350.017 25.1519 313.158 25.1519Z"
                                        fill="#000929" />
                                    <path
                                        d="M408.652 170.463L418.578 158.817L414.078 154.979L404.152 166.559L317.794 91.385C316.405 90.1938 314.353 90.3262 313.096 91.7159C311.905 93.1055 312.037 95.157 313.427 96.4143L374.903 149.949L261.679 191.705C261.083 191.904 260.62 192.367 260.355 192.83H260.289L260.157 193.161C260.09 193.293 260.09 193.426 260.024 193.558L236.466 277.202C235.805 279.651 237.922 281.967 240.437 281.57L346.249 264.695L370.535 284.217L374.704 279.055L351.212 260.13L391.777 164.574L405.674 176.684C407.064 177.875 409.115 177.742 410.372 176.353C411.63 174.963 411.431 172.912 410.041 171.654L408.652 170.463ZM249.503 273.364C246.988 273.761 244.87 271.445 245.532 268.997L265.318 199.381L339.433 259.004L249.503 273.364ZM345.919 255.762L274.186 198.058C272.664 196.867 273.061 194.418 274.913 193.756L380.594 154.78L386.55 160.008L345.919 255.762Z"
                                        fill="#000929" />
                                    <path
                                        d="M238.385 349.403C199.342 349.403 167.578 317.64 167.578 278.597C167.578 239.554 199.342 207.79 238.385 207.79C277.427 207.79 309.191 239.554 309.191 278.597C309.191 317.64 277.427 349.403 238.385 349.403ZM238.385 211.761C201.526 211.761 171.549 241.738 171.549 278.597C171.549 315.456 201.526 345.433 238.385 345.433C275.244 345.433 305.221 315.456 305.221 278.597C305.221 241.738 275.244 211.761 238.385 211.761Z"
                                        fill="#000929" />
                                    <path
                                        d="M266.842 213.409C255.526 213.409 246.328 204.211 246.328 192.895C246.328 181.58 255.526 172.381 266.842 172.381C278.158 172.381 287.356 181.58 287.356 192.895C287.356 204.211 278.158 213.409 266.842 213.409ZM266.842 176.352C257.71 176.352 250.299 183.763 250.299 192.895C250.299 202.027 257.71 209.439 266.842 209.439C275.974 209.439 283.386 202.027 283.386 192.895C283.386 183.763 275.974 176.352 266.842 176.352Z"
                                        fill="#000929" />
                                    <path d="M248.307 188.265H224.484V192.235H248.307V188.265Z" fill="#000929" />
                                    <path d="M226.143 178.998H221.18V201.497H226.143V178.998Z" fill="#000929" />
                                    <path
                                        d="M260.154 95.2239L256.25 94.6946C260.154 66.9014 275.904 52.6075 288.411 45.5269C301.977 37.8507 314.417 36.792 314.947 36.7258L315.277 40.6963L315.145 38.7111L315.277 40.6963C315.145 40.6963 303.035 41.7551 290.264 49.0343C273.191 58.6958 263.132 74.2466 260.154 95.2239Z"
                                        fill="#000929" />
                                    <path
                                        d="M285.303 89.403L281.398 88.5425C286.229 66.3741 305.883 61.4112 306.677 61.2126L307.604 65.0506L307.14 63.1316L307.604 65.0506C306.942 65.3153 289.604 69.7492 285.303 89.403Z"
                                        fill="#000929" />
                                    <path
                                        d="M312.497 103.895C305.946 103.895 300.586 98.5353 300.586 91.984C300.586 85.4328 305.946 80.0726 312.497 80.0726C319.049 80.0726 324.409 85.4328 324.409 91.984C324.409 98.5353 319.049 103.895 312.497 103.895ZM312.497 84.0431C308.13 84.0431 304.556 87.6165 304.556 91.984C304.556 96.3515 308.13 99.9249 312.497 99.9249C316.865 99.9249 320.438 96.3515 320.438 91.984C320.438 87.6165 316.865 84.0431 312.497 84.0431Z"
                                        fill="#000929" />
                                    <path
                                        d="M238.38 290.505C231.829 290.505 226.469 285.145 226.469 278.594C226.469 272.042 231.829 266.682 238.38 266.682C244.931 266.682 250.292 272.042 250.292 278.594C250.292 285.145 244.931 290.505 238.38 290.505ZM238.38 270.653C234.013 270.653 230.439 274.226 230.439 278.594C230.439 282.961 234.013 286.535 238.38 286.535C242.748 286.535 246.321 282.961 246.321 278.594C246.321 274.226 242.748 270.653 238.38 270.653Z"
                                        fill="#000929" />
                                    <path
                                        d="M415.265 160.677L412.75 158.493C420.36 149.824 423.536 142.28 422.081 136.126C420.559 129.509 414.206 126.729 414.14 126.729L415.463 123.685C415.794 123.818 423.47 127.193 425.323 135.398C426.977 142.677 423.603 151.214 415.265 160.677Z"
                                        fill="#000929" />
                                    <path
                                        d="M392.568 135.785L386.281 132.079C386.48 131.682 391.84 122.815 401.568 120.432C407.523 118.977 413.677 120.168 419.898 124.006L416.06 130.16C411.626 127.381 407.325 126.454 403.354 127.447C396.604 129.101 392.568 135.719 392.568 135.785Z"
                                        fill="#FCCBD5" />
                                    <path
                                        d="M393.232 138.432L383.57 132.74L384.563 131.02C384.828 130.623 390.519 121.028 401.107 118.447C407.592 116.859 414.275 118.116 420.959 122.285L422.613 123.344L416.657 132.873L415.003 131.814C411.033 129.366 407.261 128.505 403.82 129.299C397.93 130.755 394.291 136.645 394.224 136.711L393.232 138.432ZM389.129 131.417L391.975 133.138C393.761 130.888 397.467 126.851 402.893 125.528C406.864 124.601 411.033 125.263 415.334 127.513L417.055 124.667C411.893 121.888 406.864 121.094 401.967 122.285C395.482 123.939 391.048 128.836 389.129 131.417Z"
                                        fill="#000929" />
                                    <path
                                        d="M192.001 7.9399C193.125 5.95467 195.111 4.56514 197.89 3.77104C200.669 2.97695 204.309 2.57971 208.743 2.57971C213.176 2.57971 216.816 3.043 219.529 3.96944C222.242 4.89588 224.161 6.41776 225.286 8.46916C226.411 10.5206 227.073 12.4396 227.338 14.094C227.536 15.8145 227.669 18.2632 227.669 21.5719V140.222C227.669 145.781 227.007 149.884 225.617 152.465C224.294 155.112 222.176 156.832 219.397 157.692C216.617 158.553 213.176 158.95 209.074 158.95C204.971 158.95 201.662 158.619 199.28 157.891C196.831 157.163 195.045 156.303 193.721 155.31C192.464 154.318 191.537 152.862 190.942 151.075C190.082 148.626 189.684 144.987 189.684 139.958V113.951H131.848C121.856 113.951 115.966 111.238 114.113 105.812C113.385 103.562 113.055 100.452 113.055 96.6135C113.055 92.7754 113.253 89.9299 113.716 88.0771L131.451 16.6088C132.311 13.3663 133.039 10.8514 133.701 9.13091C134.363 7.41037 135.62 5.82225 137.539 4.23407C139.458 2.64589 141.907 1.91797 144.884 1.91797C147.862 1.91797 151.171 2.44756 154.678 3.44017C164.604 6.15332 169.634 10.7191 169.634 17.0718C169.634 19.3218 169.104 22.3658 168.112 26.0054C167.979 26.2701 167.913 26.5348 167.913 26.6671L154.877 78.7464H189.684V20.513C189.684 17.2705 189.817 14.822 190.015 13.2338C190.214 11.7118 190.876 9.92513 192.001 7.9399Z"
                                        fill="#F9C200" />
                                    <path
                                        d="M209.07 161.002C204.703 161.002 201.328 160.605 198.681 159.877C196.034 159.083 193.983 158.157 192.461 156.966C190.872 155.708 189.681 153.988 189.019 151.738C188.093 149.091 187.63 145.253 187.63 140.025V116.003H131.779C120.926 116.003 114.309 112.827 112.191 106.541C111.397 104.026 111 100.784 111 96.747C111 92.7104 111.199 89.7986 111.662 87.7472L129.396 16.2127C130.257 12.8378 131.051 10.3231 131.713 8.53642C132.441 6.48502 133.962 4.56616 136.146 2.77945C138.396 0.92657 141.308 0 144.749 0C147.925 0 151.366 0.52933 155.072 1.58812C165.925 4.56596 171.483 9.79373 171.483 17.1391C171.483 19.5875 170.954 22.6979 169.895 26.6022L169.829 26.8006L169.763 26.999L169.697 27.1977L157.322 76.8285H187.564V20.5803C187.564 17.2054 187.696 14.757 187.895 13.0365C188.159 11.1836 188.887 9.1983 190.145 7.01454C191.534 4.56609 193.916 2.84543 197.225 1.91899C200.203 1.05872 204.041 0.661743 208.673 0.661743C213.372 0.661743 217.21 1.19101 220.121 2.18362C223.298 3.24241 225.614 5.09542 227.004 7.61005C228.261 9.85997 228.989 12.0438 229.253 13.9628C229.452 15.7496 229.584 18.264 229.584 21.705V140.356C229.584 146.245 228.856 150.613 227.334 153.524C225.746 156.635 223.232 158.752 219.989 159.745C217.077 160.539 213.372 161.002 209.07 161.002ZM144.815 3.90422C142.301 3.90422 140.249 4.49972 138.727 5.82321C137.073 7.1467 136.014 8.53642 135.484 9.85991C134.889 11.5143 134.161 13.9627 133.301 17.1391L115.566 88.6074C115.169 90.2617 114.97 92.975 114.97 96.6807C114.97 100.32 115.301 103.232 115.963 105.283C117.485 109.717 122.779 112.033 131.779 112.033H191.6V140.025C191.6 144.789 191.997 148.297 192.792 150.48V150.547C193.255 152.002 193.916 153.061 194.909 153.855C195.968 154.716 197.622 155.443 199.806 156.105C202.056 156.767 205.166 157.098 209.07 157.098C212.975 157.098 216.283 156.701 218.864 155.907C221.114 155.179 222.768 153.855 223.893 151.672C225.085 149.356 225.68 145.517 225.68 140.29V21.6391C225.68 18.4628 225.548 16.0141 225.349 14.4259C225.151 12.97 224.555 11.3157 223.563 9.4628C222.636 7.80844 221.114 6.68354 218.864 5.88945C216.35 5.02918 212.975 4.6322 208.739 4.6322C204.438 4.6322 200.997 5.02938 198.416 5.7573C196.166 6.41904 194.578 7.47776 193.718 8.99977C192.725 10.7865 192.13 12.3085 191.931 13.632C191.733 15.0878 191.6 17.4701 191.6 20.6465V80.8652H152.293L165.858 26.4697C165.925 26.1389 165.991 25.808 166.189 25.4771C167.116 22.036 167.579 19.2567 167.579 17.2053C167.579 11.779 163.145 7.94079 154.08 5.49234C150.771 4.43355 147.594 3.90422 144.815 3.90422Z"
                                        fill="#000929" />
                                    <path
                                        d="M473.235 7.9399C474.36 5.95467 476.345 4.56514 479.125 3.77104C481.904 2.97695 485.543 2.57971 489.977 2.57971C494.411 2.57971 498.05 3.043 500.763 3.96944C503.477 4.89588 505.396 6.41776 506.521 8.46916C507.646 10.5206 508.307 12.4396 508.572 14.094C508.771 15.8145 508.903 18.2632 508.903 21.5719V140.222C508.903 145.781 508.241 149.884 506.851 152.465C505.528 155.112 503.41 156.832 500.631 157.692C497.852 158.553 494.411 158.95 490.308 158.95C486.205 158.95 482.896 158.619 480.514 157.891C478.066 157.163 476.279 156.303 474.955 155.31C473.698 154.318 472.772 152.862 472.176 151.075C471.316 148.626 470.919 144.987 470.919 139.958V113.951H413.083C403.09 113.951 397.201 111.238 395.348 105.812C394.62 103.562 394.289 100.452 394.289 96.6135C394.289 92.7754 394.488 89.9299 394.951 88.0771L412.685 16.6088C413.546 13.3663 414.274 10.8514 414.935 9.13091C415.597 7.41037 416.855 5.82225 418.774 4.23407C420.693 2.64589 423.141 1.91797 426.119 1.91797C429.097 1.91797 432.405 2.44756 435.913 3.44017C445.839 6.15332 450.868 10.7191 450.868 17.0718C450.868 19.3218 450.339 22.3658 449.346 26.0054C449.214 26.2701 449.148 26.5348 449.148 26.6671L436.111 78.7464H470.919V20.513C470.919 17.2705 471.051 14.822 471.25 13.2338C471.448 11.7118 472.11 9.92513 473.235 7.9399Z"
                                        fill="#F9C200" />
                                    <path
                                        d="M490.305 161.002C485.937 161.002 482.562 160.605 479.915 159.877C477.268 159.083 475.217 158.157 473.695 156.966C472.107 155.708 470.916 153.988 470.254 151.738C469.327 149.091 468.864 145.253 468.864 140.025V116.003H413.013C402.16 116.003 395.543 112.827 393.426 106.541C392.631 104.026 392.234 100.784 392.234 96.747C392.234 92.7104 392.433 89.7986 392.896 87.7472L410.631 16.2127C411.491 12.8378 412.285 10.257 412.947 8.53642C413.675 6.48502 415.197 4.56616 417.381 2.77945C419.631 0.92657 422.542 0 425.983 0C429.16 0 432.601 0.52933 436.307 1.58812C447.159 4.56596 452.718 9.79373 452.718 17.1391C452.718 19.5875 452.188 22.6979 451.13 26.6022L451.063 26.8006L450.997 26.999L450.931 27.1977L438.556 76.8285H468.798V20.5803C468.798 17.2054 468.93 14.757 469.129 13.0365C469.394 11.1836 470.122 9.1983 471.379 7.01454C472.769 4.56609 475.151 2.84543 478.46 1.91899C481.437 1.05872 485.276 0.661743 489.908 0.661743C494.606 0.661743 498.444 1.19101 501.356 2.18362C504.532 3.24241 506.848 5.09542 508.238 7.61005C509.495 9.85997 510.223 12.0438 510.488 13.9628C510.686 15.7496 510.819 18.264 510.819 21.705V140.356C510.819 146.245 510.091 150.613 508.569 153.524C506.981 156.635 504.466 158.752 501.223 159.745C498.312 160.539 494.606 161.002 490.305 161.002ZM426.05 3.90422C423.535 3.90422 421.483 4.49972 419.961 5.82321C418.307 7.1467 417.248 8.53642 416.719 9.85991C416.123 11.5143 415.395 13.9627 414.535 17.1391L396.8 88.6074C396.403 90.2617 396.205 92.975 396.205 96.6807C396.205 100.32 396.536 103.232 397.197 105.283C398.719 109.717 404.013 112.033 413.013 112.033H472.835V140.025C472.835 144.789 473.232 148.297 474.026 150.48V150.547C474.489 152.002 475.151 153.061 476.143 153.855C477.202 154.716 478.857 155.443 481.04 156.105C483.29 156.767 486.4 157.098 490.305 157.098C494.209 157.098 497.518 156.701 500.099 155.907C502.348 155.179 504.003 153.855 505.128 151.672C506.319 149.356 506.915 145.517 506.915 140.29V21.6391C506.915 18.4628 506.782 16.0141 506.584 14.4259C506.385 12.97 505.79 11.3157 504.797 9.4628C503.871 7.80844 502.348 6.68354 500.099 5.88945C497.584 5.02918 494.209 4.6322 489.974 4.6322C485.672 4.6322 482.232 5.02938 479.651 5.7573C477.401 6.41904 475.813 7.47776 474.952 8.99977C473.96 10.7865 473.364 12.3085 473.166 13.632C472.967 15.0878 472.835 17.4701 472.835 20.6465V80.8652H433.527L447.093 26.4697C447.159 26.1389 447.225 25.808 447.424 25.4771C448.35 22.036 448.813 19.2567 448.813 17.2053C448.813 11.779 444.38 7.94079 435.314 5.49234C432.005 4.43355 428.829 3.90422 426.05 3.90422Z"
                                        fill="#000929" />
                                    <path
                                        d="M624.116 169.803L617.3 168.347L615.778 161.597C615.712 161.333 615.513 161.2 615.249 161.2C614.984 161.2 614.786 161.399 614.719 161.597L613.197 168.413L606.381 170.001C606.117 170.067 605.984 170.266 605.984 170.531C605.984 170.796 606.183 170.994 606.381 171.06L613.197 172.516L614.719 179.266C614.786 179.53 614.984 179.663 615.249 179.663C615.513 179.663 615.712 179.464 615.778 179.266L617.3 172.45L624.116 170.862C624.381 170.796 624.513 170.597 624.513 170.332C624.513 170.067 624.315 169.869 624.116 169.803Z"
                                        fill="#F9C200" />
                                    <path
                                        d="M639.732 141.087L635.299 140.095L634.306 135.661C634.24 135.528 634.107 135.396 633.975 135.396C633.843 135.396 633.644 135.528 633.644 135.661L632.652 140.095L628.218 141.153C628.086 141.219 627.953 141.352 627.953 141.484C627.953 141.616 628.086 141.815 628.218 141.815L632.652 142.807L633.644 147.241C633.71 147.374 633.843 147.506 633.975 147.506C634.107 147.506 634.306 147.374 634.306 147.241L635.299 142.807L639.732 141.749C639.865 141.683 639.997 141.55 639.997 141.418C639.997 141.22 639.865 141.087 639.732 141.087Z"
                                        fill="#F9C200" />
                                    <path
                                        d="M146.068 192.696L141.634 191.704L140.642 187.27C140.576 187.138 140.443 187.005 140.311 187.005C140.179 187.005 139.98 187.138 139.98 187.27L138.988 191.704L134.554 192.762C134.422 192.828 134.289 192.961 134.289 193.093C134.289 193.225 134.422 193.424 134.554 193.424L138.988 194.417L139.98 198.85C140.046 198.983 140.179 199.115 140.311 199.115C140.443 199.115 140.642 198.983 140.642 198.85L141.634 194.417L146.068 193.358C146.2 193.292 146.333 193.16 146.333 193.027C146.333 192.829 146.2 192.696 146.068 192.696Z"
                                        fill="#000929" />
                                    <path
                                        d="M521.606 179.661L530.87 164.441C530.87 164.441 539.473 162.456 544.105 155.838C544.105 155.838 550.524 153.191 553.7 147.368C554.164 146.574 553.37 145.581 552.443 145.846L542.054 148.559L546.024 141.28C546.024 141.28 555.818 134.464 559.391 128.773C559.921 127.913 558.994 126.92 558.068 127.317L536.76 137.971L511.68 169.801L521.606 179.661Z"
                                        fill="white" />
                                    <path
                                        d="M522.006 182.834L509.102 169.93L535.571 136.38L557.276 125.528C558.467 124.932 559.923 125.197 560.85 126.189C561.776 127.182 561.909 128.638 561.181 129.763C557.806 135.123 549.6 141.211 547.681 142.601L546.159 145.446L552.049 143.858C553.24 143.527 554.497 143.99 555.225 144.917C555.953 145.909 556.085 147.167 555.49 148.292C552.512 153.652 547.152 156.563 545.431 157.357C541.196 162.982 534.512 165.365 532.196 166.092L522.006 182.834ZM514.396 169.666L521.211 176.482L529.616 162.717L530.41 162.519C530.476 162.519 538.351 160.6 542.453 154.71L542.784 154.247L543.314 154.049C543.38 154.049 547.681 152.196 550.659 148.424L538.152 151.732L544.571 140.02L544.968 139.755C545.034 139.689 550.924 135.52 555.093 131.153L538.152 139.623L514.396 169.666Z"
                                        fill="#000929" />
                                    <path
                                        d="M622.852 329.21H655.277L673.673 325.107C675.063 324.908 687.107 330.93 695.643 335.364C697.43 336.29 696.636 339.07 694.584 338.805C687.769 337.945 679.166 336.688 675.129 335.232L665.865 337.217L669.174 339.864C669.174 339.864 679.1 339.864 681.68 342.511C682.673 343.504 682.872 344.761 681.482 344.893L658.586 347.143L647.998 344.496L624.837 343.834L622.852 329.21Z"
                                        fill="white" />
                                    <path
                                        d="M658.453 349.064L647.733 346.417L623.116 345.689L620.602 327.226H655.078L673.409 323.124C674.401 322.991 675.658 322.793 696.57 333.579C698.224 334.44 699.018 336.292 698.489 338.079C697.959 339.866 696.239 340.991 694.386 340.726C685.122 339.601 678.636 338.41 674.997 337.219L671.887 337.881C675.394 338.079 680.886 338.741 683.136 340.991C684.327 342.182 684.724 343.704 684.327 344.895C683.93 345.954 683.004 346.616 681.747 346.748L658.453 349.064ZM626.557 341.851L648.262 342.447L658.718 345.094L678.967 343.108C676.784 342.314 672.615 341.785 669.173 341.785H668.445L661.299 336.094L675.195 333.116L675.725 333.315C678.702 334.44 684.989 335.564 693.856 336.689C678.173 328.616 674.534 327.292 673.739 327.094L655.475 331.197H625.101L626.557 341.851Z"
                                        fill="#000929" />
                                    <path
                                        d="M371.923 253.974L363.188 230.283L343.336 237.232L353.394 266.745L371.923 253.974Z"
                                        fill="white" />
                                    <path
                                        d="M352.405 269.85L340.891 236.035L364.449 227.83L374.375 254.763L352.405 269.85ZM345.854 238.484L354.39 263.63L369.478 253.241L362 232.859L345.854 238.484Z"
                                        fill="#000929" />
                                    <path
                                        d="M365.11 223.341L366.566 235.914C366.566 235.914 347.64 233.399 344.133 243.788L316.274 230.554C314.487 229.693 314.884 227.046 316.869 226.716L360.875 220.032C362.927 219.767 364.846 221.223 365.11 223.341Z"
                                        fill="#FCCBD5" />
                                    <path
                                        d="M345.323 246.564L315.412 232.336C313.824 231.542 312.897 229.888 313.162 228.101C313.427 226.315 314.75 224.991 316.537 224.726L360.543 218.043C362.065 217.778 363.653 218.175 364.844 219.168C366.102 220.094 366.896 221.484 367.028 223.072L368.748 238.226L366.234 237.895C366.035 237.895 348.896 235.711 345.985 244.446L345.323 246.564ZM361.403 222.013C361.337 222.013 361.205 222.013 361.138 222.013L317.133 228.697C317.133 228.697 317.066 228.763 317.133 228.763L343.205 241.137C347.44 233.66 359.153 233.461 364.315 233.726L363.124 223.535C363.057 223.072 362.859 222.609 362.462 222.344C362.131 222.146 361.8 222.013 361.403 222.013Z"
                                        fill="#000929" />
                                    <path
                                        d="M299.325 247.421L276.429 236.833L267.297 255.759L295.222 269.523L299.325 247.421Z"
                                        fill="white" />
                                    <path
                                        d="M296.747 272.502L264.719 256.686L275.571 234.253L301.578 246.297L296.747 272.502ZM269.946 254.833L293.769 266.612L297.078 248.613L277.358 239.481L269.946 254.833Z"
                                        fill="#000929" />
                                    <path
                                        d="M272.854 230.549L282.78 238.424C282.78 238.424 267.626 250.005 272.523 259.865L243.406 270.122C241.553 270.783 239.899 268.6 241.09 267.011L267.56 231.211C268.751 229.557 271.199 229.226 272.854 230.549Z"
                                        fill="#FCCBD5" />
                                    <path
                                        d="M242.685 272.246C241.428 272.246 240.237 271.65 239.443 270.591C238.384 269.135 238.384 267.283 239.443 265.827L265.912 230.027C266.839 228.769 268.228 227.975 269.75 227.777C271.272 227.578 272.86 227.975 274.052 228.968L285.963 238.43L283.912 239.953C283.779 240.085 270.081 250.673 274.184 258.879L275.177 260.864L243.942 271.915C243.611 272.179 243.148 272.246 242.685 272.246ZM270.544 231.747C270.478 231.747 270.412 231.747 270.28 231.747C269.816 231.813 269.419 232.078 269.088 232.409L242.619 268.209V268.275L269.816 258.68C267.567 250.408 275.64 241.938 279.544 238.497L271.537 232.078C271.272 231.879 270.942 231.747 270.544 231.747Z"
                                        fill="#000929" />
                                    <path
                                        d="M448.816 297.447L356.834 274.948L298.6 245.17L289.336 274.286L345.584 308.697L394.553 325.24L452.787 337.814L448.816 297.447Z"
                                        fill="#F9C200" />
                                    <path
                                        d="M455.032 340.322L393.953 327.087L344.786 310.478L344.587 310.345L287.016 275.141L297.471 242.318L357.558 273.089L450.665 295.853L455.032 340.322ZM395.078 323.316L450.532 335.293L446.959 299.03L356.102 276.795L355.903 276.663L299.787 247.943L291.714 273.354L346.44 306.838L395.078 323.316Z"
                                        fill="#000929" />
                                    <path
                                        d="M459.405 301.42H398.525L371.393 245.172L347.57 263.039L370.599 332.191C373.047 339.471 379.93 344.367 387.606 344.169L459.405 342.515V301.42Z"
                                        fill="#F9C200" />
                                    <path
                                        d="M387.204 346.085C378.8 346.085 371.389 340.791 368.742 332.784L345.25 262.308L372.117 242.125L399.778 299.432H461.386V344.364L387.668 346.085C387.469 346.085 387.337 346.085 387.204 346.085ZM349.882 263.764L372.448 331.527C374.565 337.946 380.455 342.115 387.138 342.115C387.271 342.115 387.403 342.115 387.535 342.115L457.349 340.46V303.403H397.197L370.595 248.213L349.882 263.764Z"
                                        fill="#000929" />
                                    <path
                                        d="M534.844 283.554L545.432 267.672C545.432 267.672 541.461 252.452 546.093 248.482C550.726 244.511 573.887 245.835 573.887 245.835C573.887 245.835 577.195 284.216 558.667 280.245L542.785 312.009L534.844 283.554Z"
                                        fill="white" />
                                    <path
                                        d="M542.252 317.498L532.656 283.22L543.244 267.338C542.252 263.301 539.869 251.191 544.766 247.022C549.729 242.721 569.979 243.647 573.949 243.912L575.67 243.978L575.802 245.699C575.868 246.757 577.919 271.507 568.523 279.778C566.074 281.962 563.097 282.822 559.722 282.492L542.252 317.498ZM536.958 283.881L543.244 306.513L557.538 277.992L559.06 278.323C561.839 278.918 564.089 278.389 565.942 276.801C571.964 271.507 572.427 255.36 572.03 247.75C562.766 247.353 549.994 247.75 547.413 250C544.899 252.184 545.891 261.382 547.413 267.205L547.612 268.066L536.958 283.881Z"
                                        fill="#000929" />
                                    <path
                                        d="M505.724 223.335L540.201 274.818L545.429 294.803L552.84 291.891L569.913 312.67L639.396 325.243V345.096L575.869 341.787L528.224 322.596C528.224 322.596 484.549 343.11 444.844 343.772L438.227 293.48C438.227 293.48 469.99 292.156 496.46 268.333L477.402 226.974C474.49 220.688 475.483 213.342 479.916 207.982L518.959 161.065L534.179 179.594L505.724 223.335Z"
                                        fill="#FCCBD5" />
                                    <path
                                        d="M641.385 347.21L575.41 343.769L575.079 343.637L528.227 324.777C522.073 327.556 481.574 345.159 444.848 345.754H443.061L435.914 291.558L438.098 291.491C438.429 291.491 468.604 289.903 494.015 267.801L475.552 227.832C472.376 220.883 473.435 212.612 478.332 206.722L518.963 158.018L536.631 179.524L508.11 223.332L542.058 274.021L546.822 292.153L553.506 289.506L571.042 310.814L641.452 323.586V347.21H641.385ZM576.27 339.799L637.349 342.975V326.895L568.792 314.454L552.182 294.205L544.043 297.381L538.286 275.61L503.28 223.266L531.668 179.723L518.897 164.172L481.376 209.237C477.472 213.935 476.611 220.553 479.126 226.111L498.846 268.794L497.787 269.786C474.758 290.499 448.156 294.536 440.48 295.264L446.568 341.718C484.949 340.527 526.97 321.005 527.367 320.741L528.161 320.344L576.27 339.799Z"
                                        fill="#000929" />
                                    <path
                                        d="M580.508 255.1C580.508 255.1 567.273 261.056 554.7 253.776C554.7 253.776 547.09 251.129 549.406 265.688L545.435 270.982C545.435 270.982 536.171 262.379 536.833 253.115C536.833 253.115 519.429 248.615 531.208 235.248C541.134 223.998 546.759 236.571 546.759 236.571C546.759 236.571 577.199 222.013 580.508 255.1Z"
                                        fill="#000929" />
                                    <path
                                        d="M520.085 328.218L518.695 324.512C532.327 319.284 545.761 301.682 545.893 301.55L549.069 303.932C548.408 304.726 534.709 322.593 520.085 328.218Z"
                                        fill="#000929" />
                                    <path
                                        d="M493.38 257.519L489.945 259.511L503.892 283.552L507.326 281.56L493.38 257.519Z"
                                        fill="#000929" />
                                    <path
                                        d="M531.302 305.841C531.186 305.832 531.07 305.822 530.957 305.806C529.806 305.671 528.564 305.668 527.364 305.671C526.792 305.671 526.223 305.674 525.669 305.655C525.499 305.655 525.332 305.642 525.161 305.632C524.949 305.626 524.743 305.613 524.534 305.61C524.508 305.603 524.479 305.603 524.453 305.61C523.961 305.6 523.472 305.623 523 305.754C522.353 305.938 522.276 306.304 522.166 306.803L522.15 306.874C522.006 307.53 521.903 308.238 521.825 309.032V309.039C521.761 309.692 521.713 310.354 521.668 311.01C521.62 311.679 521.575 312.371 521.507 313.034C521.423 313.812 521.369 314.61 521.317 315.375C521.263 316.173 521.205 316.996 521.115 317.804C521.07 318.264 521.005 318.73 520.941 319.203C520.832 320.017 520.722 320.853 520.69 321.677C519.908 321.77 519.127 321.87 518.352 321.976L517.017 322.149C515.357 322.365 513.639 322.59 512.044 322.95C511.394 323.098 510.68 323.304 510.323 323.729C510.095 324.002 510.085 324.398 510.082 324.742C510.082 324.884 510.078 325.019 510.059 325.109V325.128C510.017 325.134 509.979 325.144 509.934 325.15C509.435 325.224 508.914 325.308 508.367 325.424C507.682 325.569 506.743 325.765 506.592 326.608V326.614C506.566 326.768 506.579 327.006 506.614 327.277C506.714 328.042 507.039 329.094 507.56 329.377C508.039 329.634 508.869 329.567 509.477 329.519L509.664 329.503C509.972 332.369 510.487 335.218 511.204 337.982C511.645 339.683 511.963 341.439 512.266 343.141C512.443 344.132 512.626 345.151 512.832 346.158C512.986 346.927 513.131 347.702 513.279 348.477C513.572 350.037 513.871 351.655 514.286 353.219C514.328 353.383 514.369 353.588 514.411 353.81C514.591 354.73 514.833 355.982 515.627 356.403C515.82 356.503 516.045 356.538 516.254 356.512L516.322 356.503C516.36 356.493 516.399 356.474 516.425 356.448C516.537 356.438 516.656 356.432 516.766 356.422C517.155 356.39 517.525 356.358 517.956 356.387C518.641 356.429 519.304 356.432 519.934 356.393C520.391 356.368 520.844 356.319 521.295 356.261C521.745 356.204 522.199 356.133 522.633 356.062C523.08 355.994 523.524 355.927 523.971 355.869C525.164 355.715 526.39 355.499 527.606 355.226C527.911 355.155 528.23 355.145 528.564 355.136C528.757 355.129 528.957 355.12 529.159 355.097C529.191 355.113 529.233 355.123 529.272 355.123C529.31 355.123 529.352 355.123 529.384 355.116C529.655 355.081 529.864 354.949 530.041 354.83L530.185 354.727C530.732 354.357 531.064 354.132 531.028 353.309C531.022 353.064 531.006 352.823 530.99 352.578C530.961 352.173 530.932 351.758 530.938 351.346C530.977 349.757 530.925 348.162 530.874 346.621L530.842 345.537C530.803 344.273 530.8 342.913 530.835 341.118C530.848 340.49 530.848 339.866 530.845 339.246C530.842 338.477 530.835 337.679 530.864 336.901C530.906 335.691 530.893 334.466 530.874 333.279L530.864 332.372C530.864 331.847 530.822 331.323 530.78 330.815C530.742 330.239 530.697 329.641 530.703 329.059C530.706 328.814 530.735 328.563 530.764 328.303C530.806 327.894 530.845 327.47 530.793 327.042C530.909 327.023 531.022 326.997 531.141 326.978C531.517 326.913 532.402 326.759 532.575 326.003C532.665 325.61 532.701 324.732 532.546 324.115C532.553 324.079 532.556 324.038 532.54 324.002C532.334 323.25 531.311 323.163 530.928 323.127C530.629 323.102 530.324 323.085 530.021 323.069C529.819 321.937 529.134 321.381 527.86 321.358C526.48 321.332 525.071 321.345 523.9 321.4C523.82 321.403 523.736 321.41 523.652 321.416C523.678 320.506 523.807 319.615 523.945 318.676C524.013 318.238 524.074 317.794 524.132 317.353C524.386 315.234 524.56 313.278 524.669 311.377C524.72 311.306 524.724 311.21 524.682 311.129C524.695 310.895 524.711 310.657 524.72 310.422C524.727 310.312 524.727 310.2 524.733 310.084C524.749 309.392 524.765 308.688 525.232 308.431C525.615 308.234 525.956 308.222 526.444 308.202C528.091 308.119 529.407 308.148 530.587 308.276C530.816 308.302 531.07 308.379 531.337 308.463C531.7 308.582 532.077 308.694 532.424 308.685C532.662 308.678 532.862 308.591 533.006 308.434C533.273 308.141 533.273 307.655 533.244 307.269C533.151 306.012 532.115 305.912 531.285 305.832L531.302 305.841ZM530.282 328.255C530.256 328.518 530.227 328.792 530.221 329.062C530.214 329.667 530.259 330.275 530.301 330.863C530.34 331.362 530.378 331.883 530.385 332.385L530.394 333.298C530.407 334.479 530.427 335.701 530.382 336.894C530.356 337.682 530.359 338.48 530.359 339.255C530.366 339.879 530.366 340.497 530.353 341.118C530.317 342.916 530.32 344.286 530.356 345.56L530.391 346.644C530.439 348.249 530.491 349.767 530.459 351.343C530.446 351.774 530.475 352.205 530.504 352.62C530.52 352.858 530.536 353.096 530.546 353.334C530.562 353.888 530.427 353.981 529.915 354.325L529.764 354.431C529.69 354.479 529.626 354.515 529.558 354.547C529.545 354.547 529.529 354.547 529.513 354.547C529.208 354.621 528.889 354.634 528.548 354.643C528.21 354.656 527.853 354.669 527.503 354.743C526.3 355.013 525.09 355.226 523.91 355.38C523.459 355.438 523.006 355.509 522.562 355.576C521.697 355.715 520.796 355.85 519.908 355.901C519.3 355.94 518.654 355.933 517.991 355.895C517.528 355.866 517.142 355.895 516.734 355.93C516.55 355.949 516.364 355.962 516.161 355.975C516.113 355.975 516.074 355.998 516.039 356.02C515.978 356.007 515.917 355.991 515.862 355.962C515.283 355.653 515.061 354.534 514.907 353.714C514.855 353.479 514.82 353.267 514.771 353.087C514.366 351.543 514.067 349.931 513.774 348.378C513.63 347.602 513.482 346.827 513.327 346.055C513.118 345.055 512.941 344.032 512.761 343.048C512.452 341.34 512.14 339.574 511.69 337.85C510.979 335.116 510.468 332.291 510.165 329.454C511.41 329.348 512.478 329.184 513.581 329.004C514.72 328.821 515.904 328.631 517.419 328.489C517.975 328.438 518.538 328.39 519.101 328.341C520.04 328.264 521.012 328.184 521.957 328.068C522.691 327.984 523.447 327.959 524.177 327.939C524.814 327.92 525.47 327.901 526.116 327.843C526.338 327.823 526.56 327.801 526.779 327.766C527.712 327.643 528.641 327.463 529.549 327.286C529.806 327.232 530.066 327.19 530.324 327.135C530.362 327.495 530.33 327.862 530.285 328.248L530.282 328.255ZM530.903 323.626C531.282 323.658 531.774 323.732 531.987 323.983C532.202 324.366 532.215 325.421 532.106 325.894C532.035 326.202 531.726 326.382 531.064 326.495C530.526 326.588 529.986 326.694 529.452 326.804C528.342 327.023 527.191 327.248 526.062 327.354C525.434 327.415 524.782 327.431 524.157 327.45C523.414 327.466 522.649 327.492 521.893 327.579C520.96 327.692 519.992 327.772 519.056 327.849C518.49 327.897 517.927 327.946 517.364 328C515.836 328.145 514.646 328.335 513.498 328.518C512.259 328.718 511.092 328.907 509.651 329.007L509.438 329.02C508.956 329.062 508.145 329.129 507.795 328.94C507.386 328.714 507.003 327.238 507.084 326.694C507.177 326.18 507.891 326.029 508.509 325.9C509.004 325.794 509.512 325.713 510.014 325.639C510.661 325.536 511.326 325.434 511.979 325.276C514.627 324.636 517.332 324.314 519.86 324.06C523.527 323.693 527.319 323.314 530.903 323.623V323.626ZM523.942 321.899C525.103 321.847 526.496 321.831 527.866 321.857C528.867 321.876 529.352 322.217 529.532 323.044C526.329 322.915 523.022 323.246 519.809 323.568C517.261 323.825 514.537 324.15 511.86 324.797C511.433 324.896 510.998 324.977 510.564 325.051C510.571 324.954 510.574 324.855 510.574 324.752C510.58 324.491 510.587 324.192 510.702 324.05C511.002 323.697 511.806 323.516 512.15 323.436C513.72 323.076 515.431 322.854 517.081 322.642L518.422 322.468C519.262 322.352 520.111 322.243 520.957 322.143C522.025 322.024 523 321.944 523.942 321.899ZM523.659 317.299C523.607 317.739 523.537 318.177 523.476 318.611C523.347 319.473 523.218 320.351 523.18 321.242C523.154 321.284 523.141 321.342 523.151 321.397L523.157 321.451C522.53 321.493 521.877 321.554 521.192 321.628C521.23 320.85 521.33 320.046 521.439 319.274C521.504 318.795 521.565 318.325 521.616 317.858C521.7 317.048 521.761 316.218 521.819 315.417C521.87 314.658 521.928 313.867 522.006 313.091C522.08 312.422 522.121 311.728 522.17 311.052C522.17 311.023 522.17 310.997 522.173 310.965C522.321 310.981 522.472 310.991 522.636 311.004C523.151 311.036 523.897 311.091 524.193 311.309C524.09 313.217 523.916 315.176 523.659 317.302V317.299ZM524.254 310.074C524.254 310.19 524.248 310.299 524.248 310.406C524.244 310.528 524.235 310.647 524.228 310.769C523.794 310.586 523.209 310.541 522.665 310.509C522.498 310.496 522.343 310.486 522.205 310.473C522.234 310.09 522.266 309.704 522.302 309.328C522.443 309.351 522.585 309.367 522.726 309.376C522.932 309.396 523.131 309.408 523.324 309.454C523.55 309.495 524.01 309.579 524.103 309.762C524.135 309.823 524.196 309.856 524.257 309.872C524.251 309.942 524.251 310.013 524.248 310.078L524.254 310.074ZM524.302 309.264C524.045 309.084 523.685 309.013 523.424 308.965C523.202 308.92 522.987 308.897 522.774 308.881C522.63 308.868 522.482 308.858 522.35 308.836C522.401 308.341 522.466 307.881 522.543 307.446C523.447 307.832 524.042 308.251 524.344 308.71C524.363 308.733 524.389 308.749 524.415 308.765C524.36 308.923 524.322 309.09 524.299 309.264H524.302ZM524.662 308.305C524.273 307.8 523.611 307.36 522.642 306.951L522.652 306.909C522.755 306.43 522.778 306.333 523.138 306.23C523.517 306.121 523.936 306.095 524.354 306.102C524.63 306.629 524.865 307.395 524.994 308.016C524.859 308.093 524.753 308.193 524.662 308.305ZM532.656 308.112C532.627 308.144 532.562 308.193 532.427 308.202C532.164 308.205 531.829 308.099 531.504 308.003C531.228 307.913 530.935 307.823 530.661 307.794C529.449 307.655 528.107 307.633 526.412 307.713C526.081 307.733 525.779 307.746 525.463 307.832C525.344 307.308 525.155 306.658 524.913 306.121C524.987 306.121 525.065 306.128 525.135 306.131C525.312 306.137 525.486 306.144 525.656 306.153C526.216 306.166 526.792 306.166 527.364 306.166C528.548 306.166 529.777 306.166 530.896 306.301C531.012 306.314 531.134 306.324 531.25 306.34C532.18 306.43 532.707 306.52 532.772 307.321C532.781 307.475 532.813 307.939 532.656 308.115V308.112Z"
                                        fill="#0E2239" />
                                    <path
                                        d="M532.772 307.318C532.782 307.473 532.814 307.936 532.656 308.113C532.627 308.145 532.563 308.193 532.428 308.203C532.164 308.206 531.83 308.1 531.505 308.004C531.228 307.913 530.936 307.823 530.662 307.794C529.449 307.656 528.108 307.634 526.413 307.714C526.082 307.733 525.779 307.746 525.464 307.833C525.345 307.309 525.155 306.659 524.914 306.122C524.988 306.122 525.065 306.128 525.136 306.131C525.313 306.138 525.487 306.144 525.657 306.154C526.217 306.167 526.793 306.167 527.365 306.167C528.549 306.167 529.778 306.167 530.897 306.302C531.013 306.315 531.135 306.324 531.251 306.341C532.18 306.431 532.708 306.521 532.772 307.322V307.318Z"
                                        fill="white" />
                                    <path
                                        d="M524.992 308.016C524.857 308.094 524.751 308.193 524.661 308.306C524.271 307.801 523.609 307.36 522.641 306.952L522.65 306.91C522.753 306.431 522.776 306.334 523.136 306.231C523.516 306.122 523.934 306.096 524.352 306.102C524.628 306.63 524.863 307.396 524.992 308.016Z"
                                        fill="white" />
                                    <path
                                        d="M524.412 308.765C524.357 308.923 524.319 309.09 524.296 309.264C524.039 309.084 523.679 309.013 523.418 308.965C523.196 308.919 522.981 308.897 522.768 308.881C522.624 308.868 522.476 308.858 522.344 308.836C522.395 308.34 522.46 307.881 522.537 307.446C523.441 307.832 524.036 308.25 524.338 308.71C524.357 308.733 524.383 308.749 524.409 308.765H524.412Z"
                                        fill="white" />
                                    <path
                                        d="M524.254 309.866C524.248 309.937 524.248 310.008 524.244 310.072C524.244 310.188 524.238 310.297 524.238 310.403C524.235 310.525 524.225 310.644 524.219 310.767C523.784 310.583 523.199 310.538 522.655 310.506C522.488 310.493 522.334 310.484 522.195 310.471C522.224 310.088 522.256 309.702 522.292 309.326C522.433 309.348 522.575 309.364 522.716 309.374C522.922 309.393 523.122 309.406 523.315 309.451C523.54 309.493 524 309.577 524.093 309.76C524.125 309.821 524.186 309.853 524.248 309.869L524.254 309.866Z"
                                        fill="white" />
                                    <path
                                        d="M524.189 311.308C524.086 313.215 523.912 315.174 523.655 317.3C523.603 317.741 523.532 318.178 523.471 318.613C523.343 319.475 523.214 320.353 523.175 321.244C523.15 321.286 523.137 321.344 523.146 321.398L523.153 321.453C522.526 321.495 521.873 321.556 521.188 321.63C521.226 320.851 521.326 320.047 521.435 319.275C521.5 318.796 521.561 318.326 521.612 317.86C521.696 317.049 521.757 316.219 521.815 315.419C521.866 314.659 521.924 313.868 522.001 313.093C522.075 312.424 522.117 311.729 522.165 311.054C522.165 311.025 522.165 310.999 522.169 310.967C522.317 310.983 522.468 310.993 522.632 311.005C523.146 311.038 523.893 311.092 524.189 311.311V311.308Z"
                                        fill="white" />
                                    <path
                                        d="M529.531 323.043C526.327 322.915 523.02 323.246 519.807 323.568C517.259 323.825 514.535 324.15 511.859 324.797C511.431 324.896 510.997 324.977 510.562 325.051C510.569 324.954 510.572 324.854 510.572 324.751C510.579 324.491 510.585 324.192 510.701 324.05C511 323.696 511.804 323.516 512.148 323.436C513.718 323.076 515.429 322.854 517.079 322.641L518.421 322.468C519.26 322.352 520.109 322.243 520.955 322.143C522.023 322.024 522.998 321.943 523.94 321.898C525.102 321.847 526.494 321.831 527.865 321.857C528.865 321.876 529.351 322.217 529.531 323.043Z"
                                        fill="#0E2239" />
                                    <path
                                        d="M532.111 325.896C532.04 326.205 531.731 326.385 531.069 326.498C530.531 326.591 529.991 326.697 529.457 326.807C528.347 327.025 527.196 327.25 526.067 327.357C525.44 327.418 524.787 327.434 524.163 327.453C523.42 327.469 522.654 327.495 521.898 327.582C520.965 327.694 519.997 327.775 519.061 327.852C518.495 327.9 517.932 327.948 517.369 328.003C515.841 328.148 514.651 328.338 513.503 328.521C512.264 328.72 511.097 328.91 509.656 329.01L509.443 329.023C508.961 329.065 508.15 329.132 507.8 328.942C507.391 328.717 507.008 327.241 507.089 326.697C507.182 326.182 507.896 326.031 508.514 325.903C509.009 325.797 509.517 325.716 510.019 325.642C510.666 325.539 511.332 325.436 511.985 325.279C514.632 324.639 517.337 324.317 519.865 324.063C523.532 323.696 527.325 323.317 530.908 323.625C531.287 323.657 531.779 323.731 531.992 323.982C532.207 324.365 532.22 325.42 532.111 325.893V325.896Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M530.319 327.14C530.358 327.5 530.326 327.867 530.281 328.253C530.255 328.517 530.226 328.79 530.22 329.061C530.213 329.665 530.258 330.273 530.3 330.862C530.339 331.36 530.377 331.881 530.384 332.383L530.393 333.297C530.406 334.477 530.425 335.7 530.38 336.893C530.355 337.681 530.358 338.479 530.358 339.254C530.364 339.878 530.364 340.496 530.351 341.116C530.316 342.914 530.319 344.285 530.355 345.558L530.39 346.642C530.438 348.248 530.49 349.766 530.458 351.342C530.445 351.773 530.474 352.204 530.503 352.619C530.519 352.857 530.535 353.095 530.544 353.333C530.56 353.886 530.425 353.979 529.914 354.324L529.763 354.43C529.689 354.478 529.624 354.513 529.557 354.546C529.544 354.546 529.528 354.546 529.512 354.546C529.206 354.62 528.888 354.632 528.547 354.642C528.209 354.655 527.852 354.668 527.502 354.742C526.299 355.012 525.089 355.224 523.909 355.379C523.458 355.437 523.005 355.507 522.561 355.575C521.696 355.713 520.795 355.848 519.907 355.9C519.299 355.938 518.653 355.932 517.99 355.893C517.527 355.864 517.141 355.893 516.732 355.929C516.549 355.948 516.362 355.961 516.16 355.974C516.112 355.974 516.073 355.996 516.038 356.019C515.976 356.006 515.915 355.99 515.861 355.961C515.282 355.652 515.06 354.533 514.905 353.713C514.854 353.478 514.818 353.265 514.77 353.085C514.365 351.541 514.066 349.93 513.773 348.376C513.628 347.601 513.48 346.826 513.326 346.054C513.117 345.053 512.94 344.031 512.76 343.046C512.451 341.338 512.139 339.572 511.689 337.848C510.978 335.114 510.466 332.29 510.164 329.453C511.409 329.347 512.477 329.183 513.58 329.003C514.719 328.819 515.902 328.63 517.417 328.488C517.974 328.437 518.537 328.388 519.1 328.34C520.039 328.263 521.01 328.182 521.956 328.067C522.689 327.983 523.445 327.957 524.176 327.938C524.812 327.919 525.469 327.899 526.115 327.841C526.337 327.822 526.559 327.8 526.778 327.764C527.711 327.642 528.64 327.462 529.547 327.285C529.805 327.23 530.065 327.188 530.322 327.134L530.319 327.14Z"
                                        fill="url(#paint0_linear_381_71673)" />
                                    <path
                                        d="M527.131 340.809C527.672 344.961 525.787 348.625 522.924 348.998C520.061 349.371 517.305 346.306 516.764 342.156C516.224 338.004 518.106 334.34 520.968 333.967C523.831 333.594 526.588 336.659 527.128 340.809H527.131Z"
                                        fill="white" />
                                    <path
                                        d="M627.315 132.726C626.177 130.91 623.758 130.486 622.424 130.392C621.657 127.871 618.301 127.058 615.311 127.157C612.468 127.255 609.456 127.67 606.346 128.41C604.096 128.946 601.785 129.348 599.549 129.736C597.559 130.084 595.502 130.441 593.484 130.887C591.811 131.262 590.053 131.423 588.348 131.574C585.862 131.802 583.288 132.039 580.887 132.936C578.7 133.752 575.442 134.962 574.911 138.143C574.885 138.3 574.867 138.46 574.849 138.621C574.657 138.692 574.461 138.781 574.273 138.871C574.26 138.875 574.246 138.884 574.242 138.889H574.233C574.202 138.889 574.175 138.889 574.139 138.897C573.175 139.219 570.989 140.785 570.529 141.776C569.909 143.132 569.373 144.578 570.217 146.154C571.042 147.684 572.725 148.684 575.246 149.112C575.393 149.465 575.576 149.826 575.777 150.223C577.33 153.191 580.048 155.217 583.435 155.927C584.354 156.123 585.269 156.239 586.184 156.293C589.392 156.484 592.552 155.918 595.626 155.369L597.144 155.101C601.789 154.289 607.564 153.271 612.049 151.794C612.897 151.513 613.798 151.263 614.749 150.995C619.363 149.697 624.597 148.224 626.164 142.985C626.458 142.008 626.601 141.089 626.601 140.227C627.257 139.692 627.815 139.063 628.101 138.072C628.516 136.639 628.132 134.042 627.306 132.726H627.315ZM575.554 138.188C576.009 135.653 578.437 134.538 581.11 133.538C583.426 132.668 585.956 132.445 588.402 132.217C590.129 132.061 591.914 131.9 593.627 131.521C595.626 131.07 597.675 130.718 599.661 130.374C601.91 129.981 604.226 129.58 606.497 129.04C609.563 128.312 612.535 127.897 615.329 127.804C616.266 127.777 620.719 127.768 621.724 130.365C621.433 130.361 621.13 130.365 620.84 130.378C620.416 130.392 619.988 130.419 619.559 130.45C618.051 130.557 616.556 130.753 615.088 130.959C614.851 130.99 614.61 131.026 614.374 131.057L613.731 131.15H613.722L613.205 131.222C612.49 131.32 611.776 131.418 611.054 131.503C608.648 131.806 606.167 132.128 603.789 132.726C602.892 132.953 601.99 133.235 601.129 133.516C600.651 133.667 600.174 133.824 599.692 133.962C599.143 134.131 598.585 134.279 598.027 134.404C597.751 134.466 597.474 134.524 597.193 134.573C596.224 134.756 595.243 134.881 594.288 134.997C593.85 135.051 593.395 135.109 592.953 135.162C592.561 135.216 592.172 135.274 591.78 135.332C591.012 135.448 590.236 135.573 589.464 135.698C587.241 136.073 585.041 136.501 582.881 136.912L582.756 136.938C582.145 137.059 581.529 137.224 580.94 137.389C580.083 137.626 579.195 137.862 578.334 137.947C577.669 138.005 576.969 138.139 576.272 138.286H576.263C576.219 138.286 576.179 138.3 576.134 138.308L575.527 138.429C575.532 138.344 575.549 138.259 575.563 138.179L575.554 138.188ZM625.539 142.793C624.075 147.693 619.028 149.117 614.574 150.362C613.615 150.634 612.709 150.888 611.848 151.174C607.408 152.638 601.66 153.646 597.037 154.458L595.51 154.731C591.624 155.427 587.603 156.145 583.564 155.293C580.378 154.624 577.816 152.714 576.357 149.92C576.228 149.67 576.112 149.438 576.009 149.215C575.893 148.974 575.795 148.746 575.719 148.528C575.407 147.662 575.344 146.868 575.625 145.712C575.822 144.913 576.33 143.628 577.66 142.994L577.799 142.945C577.95 142.887 578.098 142.833 578.236 142.784C578.356 142.744 578.472 142.722 578.606 142.695C578.678 142.682 578.745 142.646 578.789 142.588C579.133 142.481 579.472 142.396 579.838 142.352H579.847C579.887 142.343 579.918 142.338 579.958 142.334C580.65 142.258 581.364 142.204 582.078 142.142C582.261 142.128 582.444 142.111 582.632 142.097C583.292 142.044 583.97 141.99 584.644 141.905C585.635 141.78 586.626 141.62 587.598 141.437C588.527 141.272 589.441 141.08 590.343 140.897C590.428 140.874 590.521 140.861 590.606 140.839C591.441 140.66 592.284 140.491 593.132 140.326C595.466 139.879 597.876 139.594 600.201 139.317C601.49 139.165 602.82 139.005 604.137 138.826C604.141 138.826 604.15 138.826 604.15 138.826C604.431 138.786 604.694 138.741 604.976 138.701C605.185 138.67 605.395 138.643 605.605 138.607C605.605 138.607 605.609 138.603 605.618 138.603C605.957 138.558 606.305 138.509 606.649 138.456C608.452 138.201 610.308 137.934 612.116 137.541H612.12C612.383 137.487 612.647 137.425 612.906 137.362C613.343 137.26 613.762 137.139 614.186 137.019H614.191C614.588 136.898 614.981 136.773 615.364 136.648C616.15 136.403 616.962 136.144 617.765 135.952C618.069 135.881 618.403 135.814 618.76 135.751C619.559 135.622 620.456 135.542 621.322 135.555H621.326C622.679 135.577 623.928 135.836 624.553 136.523C625.414 137.465 625.874 138.603 625.927 139.924C625.95 140.192 625.945 140.464 625.927 140.745C625.883 141.392 625.758 142.079 625.539 142.802V142.793ZM627.48 137.893C627.293 138.54 626.972 139 626.552 139.397C626.4 138.139 625.892 137.032 625.039 136.086C624.33 135.31 623.062 134.993 621.719 134.921C620.416 134.854 619.042 135.028 618.042 135.229H618.037C617.886 135.261 617.747 135.287 617.622 135.323C616.792 135.519 615.967 135.783 615.172 136.037C614.985 136.099 614.802 136.157 614.615 136.22C614.003 136.403 613.374 136.595 612.754 136.747C612.254 136.867 611.741 136.974 611.228 137.077C609.684 137.376 608.099 137.603 606.551 137.831C606.475 137.84 606.399 137.853 606.323 137.862C605.846 137.934 605.359 138.001 604.886 138.067C604.235 138.166 603.583 138.255 602.932 138.34C601.986 138.465 601.053 138.581 600.129 138.688C599.5 138.759 598.866 138.835 598.228 138.92H598.224C597.188 139.04 596.153 139.179 595.118 139.339H595.113C594.404 139.446 593.708 139.567 593.011 139.701C592.244 139.848 591.472 140.013 590.709 140.169H590.704C590.624 140.183 590.561 140.201 590.481 140.214C589.249 140.473 587.987 140.727 586.719 140.946C586.01 141.066 585.287 141.178 584.573 141.267C584.037 141.334 583.493 141.383 582.957 141.432C582.645 141.459 582.337 141.486 582.029 141.508C581.311 141.571 580.592 141.624 579.891 141.7C579.651 141.731 579.418 141.767 579.195 141.829C578.812 141.919 578.446 142.039 578.057 142.177C575.987 142.762 575.259 144.534 575.005 145.578C574.719 146.743 574.755 147.599 575.005 148.421C572.899 148.001 571.48 147.144 570.792 145.868C570.154 144.681 570.435 143.579 571.131 142.07C571.372 141.544 572.323 140.736 573.184 140.165H573.189C573.247 140.165 573.305 140.151 573.367 140.125L573.702 139.937C574.01 139.759 574.349 139.571 574.688 139.411C574.987 139.272 575.3 139.156 575.612 139.094L576.255 138.969C576.661 138.889 577.089 138.804 577.5 138.737H577.504C577.812 138.683 578.102 138.643 578.388 138.616C579.311 138.536 580.222 138.282 581.11 138.036C581.177 138.018 581.248 137.996 581.315 137.983C581.828 137.844 582.359 137.702 582.872 137.599L583.002 137.572C583.395 137.501 583.792 137.425 584.184 137.345C585.782 137.046 587.402 136.738 589.022 136.456C590.312 136.233 591.597 136.024 592.882 135.85C592.936 135.841 592.989 135.836 593.038 135.827C593.476 135.769 593.922 135.711 594.368 135.658C595.211 135.551 596.086 135.443 596.952 135.292C597.358 135.225 597.769 135.153 598.17 135.06C599.009 134.863 599.844 134.618 600.651 134.364C600.879 134.292 601.102 134.221 601.33 134.149C602.186 133.877 603.074 133.592 603.949 133.368C604.36 133.261 604.775 133.172 605.19 133.083C606.145 132.878 607.104 132.717 608.077 132.574H608.081C609.103 132.422 610.134 132.293 611.143 132.163C611.817 132.074 612.486 131.989 613.155 131.896C613.2 131.896 613.245 131.882 613.294 131.878L614.467 131.713C615.021 131.637 615.561 131.557 616.101 131.485C617.332 131.325 618.533 131.177 619.747 131.097C620.202 131.066 620.666 131.043 621.13 131.034C621.344 131.021 621.558 131.021 621.773 131.021C621.817 131.021 621.862 131.021 621.915 131.021C622.072 131.021 622.259 131.03 622.478 131.057C623.709 131.142 625.811 131.543 626.771 133.074C627.48 134.221 627.846 136.657 627.485 137.898L627.48 137.893Z"
                                        fill="#0E2239" />
                                    <path
                                        d="M615.326 127.808C612.533 127.902 609.56 128.317 606.495 129.044C604.228 129.584 601.907 129.986 599.658 130.378C597.672 130.722 595.624 131.075 593.625 131.525C591.911 131.905 590.126 132.065 588.399 132.221C585.954 132.445 583.423 132.672 581.107 133.542C578.434 134.538 576.007 135.658 575.551 138.192C575.538 138.277 575.52 138.357 575.516 138.442L576.123 138.322C576.167 138.313 576.207 138.299 576.252 138.295H576.261C576.957 138.148 577.658 138.014 578.323 137.956C579.188 137.871 580.072 137.63 580.929 137.398C581.518 137.233 582.134 137.068 582.745 136.947L582.87 136.921C585.025 136.51 587.23 136.082 589.452 135.707C590.229 135.577 591.001 135.457 591.768 135.341C592.161 135.278 592.549 135.225 592.942 135.171C593.388 135.113 593.839 135.055 594.276 135.006C595.231 134.89 596.217 134.765 597.181 134.582C597.462 134.533 597.739 134.471 598.016 134.413C598.574 134.288 599.131 134.14 599.68 133.971C600.162 133.832 600.64 133.676 601.117 133.525C601.979 133.243 602.88 132.962 603.777 132.735C606.151 132.137 608.637 131.815 611.042 131.512C611.765 131.423 612.475 131.329 613.193 131.231L613.711 131.159H613.72L614.362 131.07C614.599 131.039 614.84 131.003 615.076 130.972C616.544 130.767 618.039 130.57 619.548 130.463C619.972 130.432 620.404 130.405 620.828 130.392C621.123 130.383 621.422 130.374 621.712 130.378C620.708 127.781 616.254 127.79 615.317 127.817L615.326 127.808ZM581.018 136.331C580.857 136.532 580.612 136.711 580.371 136.805C580.326 136.822 580.277 136.831 580.233 136.831C580.108 136.822 579.996 136.746 579.951 136.626C579.884 136.461 579.965 136.269 580.134 136.207C580.268 136.149 580.424 136.037 580.509 135.93C580.621 135.787 580.831 135.769 580.969 135.881C581.107 135.992 581.134 136.198 581.018 136.331ZM585.391 134.966C585.338 135.002 585.271 135.019 585.208 135.015C585.106 135.011 585.003 134.953 584.949 134.863C584.789 134.604 584.762 134.301 584.744 134.056C584.735 133.975 584.726 133.904 584.717 133.846C584.682 133.676 584.789 133.498 584.967 133.467C585.146 133.431 585.315 133.547 585.347 133.725C585.369 133.797 585.373 133.895 585.382 134.002C585.405 134.181 585.423 134.404 585.503 134.524C585.592 134.68 585.547 134.877 585.391 134.97V134.966ZM590.586 134.346C590.519 134.408 590.429 134.426 590.349 134.421C590.269 134.417 590.189 134.381 590.126 134.319C589.858 134.011 589.715 133.864 589.39 133.69C589.234 133.6 589.171 133.404 589.26 133.248C589.35 133.092 589.546 133.038 589.702 133.118C590.131 133.359 590.331 133.574 590.612 133.89C590.728 134.029 590.715 134.234 590.586 134.35V134.346ZM601.015 131.86C600.792 131.918 600.586 132.034 600.443 132.177C600.372 132.244 600.283 132.279 600.198 132.271C600.122 132.266 600.046 132.23 599.984 132.172C599.863 132.043 599.863 131.833 599.993 131.713C600.211 131.494 600.515 131.32 600.841 131.231C601.015 131.182 601.198 131.284 601.242 131.458C601.291 131.637 601.189 131.811 601.019 131.86H601.015ZM611.47 129.678C611.417 129.825 611.283 129.905 611.14 129.896C611.113 129.896 611.087 129.888 611.055 129.879C610.868 129.816 610.524 129.709 610.435 129.687C610.261 129.638 610.163 129.464 610.212 129.29C610.257 129.111 610.435 129.017 610.609 129.058C610.707 129.084 611.069 129.196 611.265 129.267C611.435 129.325 611.524 129.513 611.466 129.678H611.47ZM616.776 129.691C616.718 129.727 616.651 129.74 616.585 129.74C616.486 129.736 616.388 129.682 616.326 129.589C616.232 129.432 616.138 129.254 616.08 129.12C616.018 128.946 616.094 128.763 616.268 128.696C616.428 128.629 616.62 128.709 616.687 128.879C616.723 128.964 616.79 129.107 616.879 129.249C616.973 129.397 616.928 129.597 616.772 129.7L616.776 129.691Z"
                                        fill="#F9C200" />
                                    <path
                                        d="M627.482 137.893C627.295 138.54 626.974 139 626.554 139.397C626.403 138.138 625.894 137.032 625.041 136.086C624.332 135.309 623.065 134.992 621.721 134.921C620.418 134.854 619.044 135.028 618.044 135.229H618.04C617.888 135.26 617.75 135.287 617.625 135.322C616.795 135.519 615.969 135.782 615.175 136.036C614.987 136.099 614.804 136.157 614.617 136.219C614.006 136.402 613.376 136.594 612.756 136.746C612.256 136.866 611.743 136.974 611.23 137.076C609.686 137.375 608.102 137.603 606.553 137.83C606.477 137.839 606.401 137.853 606.325 137.862C605.848 137.933 605.362 138 604.889 138.067C604.237 138.165 603.585 138.254 602.934 138.339C601.988 138.464 601.055 138.58 600.131 138.687C599.502 138.759 598.869 138.834 598.23 138.919H598.226C597.191 139.04 596.155 139.178 595.12 139.339H595.116C594.406 139.446 593.71 139.566 593.014 139.7C592.246 139.847 591.474 140.013 590.711 140.169H590.707C590.626 140.182 590.564 140.2 590.483 140.213C589.252 140.472 587.989 140.727 586.721 140.945C586.012 141.066 585.289 141.177 584.575 141.267C584.039 141.333 583.495 141.383 582.96 141.432C582.647 141.458 582.339 141.485 582.031 141.508C581.313 141.57 580.594 141.624 579.894 141.699C579.653 141.731 579.421 141.766 579.198 141.829C578.814 141.918 578.448 142.039 578.06 142.177C575.989 142.761 575.262 144.533 575.007 145.577C574.722 146.742 574.757 147.599 575.007 148.42C572.901 148.001 571.482 147.144 570.795 145.867C570.156 144.68 570.438 143.578 571.134 142.07C571.375 141.543 572.325 140.735 573.187 140.164H573.191C573.249 140.164 573.307 140.151 573.369 140.124L573.704 139.937C574.012 139.758 574.351 139.571 574.69 139.41C574.989 139.272 575.302 139.156 575.614 139.093L576.257 138.968C576.663 138.888 577.091 138.803 577.502 138.736H577.506C577.814 138.683 578.104 138.643 578.39 138.616C579.314 138.535 580.224 138.281 581.112 138.036C581.179 138.018 581.25 137.995 581.317 137.982C581.83 137.844 582.362 137.701 582.875 137.598L583.004 137.572C583.397 137.5 583.794 137.424 584.187 137.344C585.784 137.045 587.404 136.737 589.024 136.456C590.314 136.233 591.599 136.023 592.884 135.849C592.938 135.84 592.991 135.836 593.04 135.827C593.478 135.769 593.924 135.711 594.37 135.657C595.214 135.55 596.088 135.443 596.954 135.291C597.36 135.224 597.771 135.153 598.172 135.059C599.011 134.863 599.846 134.617 600.654 134.363C600.881 134.292 601.104 134.22 601.332 134.149C602.189 133.877 603.077 133.591 603.951 133.368C604.362 133.261 604.777 133.171 605.192 133.082C606.147 132.877 607.106 132.716 608.079 132.573H608.084C609.106 132.422 610.136 132.292 611.145 132.163C611.819 132.074 612.488 131.989 613.158 131.895C613.202 131.895 613.247 131.882 613.296 131.877L614.47 131.712C615.023 131.636 615.563 131.556 616.103 131.485C617.335 131.324 618.535 131.177 619.749 131.096C620.204 131.065 620.668 131.043 621.132 131.034C621.346 131.021 621.561 131.021 621.775 131.021C621.819 131.021 621.864 131.021 621.918 131.021C622.074 131.021 622.261 131.029 622.48 131.056C623.712 131.141 625.813 131.543 626.773 133.073C627.482 134.22 627.848 136.657 627.487 137.897L627.482 137.893Z"
                                        fill="#F98C3B" />
                                    <path
                                        d="M625.936 139.919C625.878 138.603 625.419 137.465 624.562 136.519C623.942 135.831 622.688 135.573 621.336 135.55H621.331C620.465 135.537 619.573 135.622 618.77 135.747C618.413 135.809 618.078 135.876 617.774 135.947C616.971 136.139 616.159 136.398 615.374 136.644C614.99 136.768 614.597 136.898 614.2 137.014H614.195C613.772 137.139 613.348 137.255 612.915 137.358C612.656 137.42 612.393 137.483 612.129 137.536H612.125C610.318 137.929 608.466 138.197 606.658 138.451C606.319 138.504 605.971 138.554 605.627 138.598C605.618 138.598 605.614 138.603 605.614 138.603C605.404 138.634 605.195 138.661 604.985 138.696C604.704 138.736 604.44 138.781 604.159 138.821C604.159 138.821 604.15 138.821 604.146 138.821C602.829 139.004 601.5 139.165 600.21 139.312C597.885 139.589 595.475 139.874 593.141 140.321C592.293 140.486 591.45 140.655 590.615 140.834C590.531 140.856 590.437 140.87 590.352 140.892C589.451 141.07 588.536 141.267 587.608 141.432C586.635 141.615 585.644 141.775 584.653 141.9C583.98 141.985 583.301 142.039 582.641 142.092C582.453 142.106 582.27 142.124 582.087 142.137C581.373 142.199 580.664 142.253 579.968 142.329C579.928 142.333 579.896 142.338 579.856 142.347H579.847C579.481 142.391 579.142 142.472 578.798 142.583C578.758 142.641 578.687 142.672 578.616 142.69C578.486 142.717 578.366 142.739 578.245 142.78C578.107 142.829 577.96 142.887 577.808 142.94L577.669 142.989C576.34 143.623 575.831 144.908 575.635 145.707C575.349 146.863 575.416 147.657 575.728 148.523C575.804 148.742 575.902 148.969 576.018 149.21C576.121 149.433 576.237 149.665 576.366 149.915C577.826 152.709 580.392 154.614 583.573 155.288C587.612 156.14 591.633 155.426 595.52 154.726L597.046 154.454C601.674 153.646 607.421 152.637 611.857 151.169C612.718 150.884 613.624 150.629 614.584 150.357C619.042 149.107 624.089 147.688 625.548 142.788C625.767 142.066 625.892 141.378 625.936 140.731C625.959 140.455 625.963 140.182 625.936 139.91V139.919ZM582.261 150.643C582.19 150.723 582.101 150.759 582.003 150.75C581.931 150.75 581.86 150.714 581.806 150.665C581.338 150.241 581.141 149.911 581.181 149.621C581.199 149.447 581.369 149.317 581.543 149.344C581.717 149.362 581.837 149.518 581.829 149.688C581.833 149.714 581.895 149.866 582.239 150.187C582.373 150.312 582.382 150.513 582.266 150.643H582.261ZM584.448 145.618H584.435C584.287 145.604 584.162 145.591 584.042 145.569C583.779 145.533 583.569 145.506 583.27 145.511C583.096 145.511 582.94 145.372 582.94 145.194C582.94 145.02 583.083 144.873 583.257 144.868C583.609 144.864 583.846 144.89 584.131 144.935C584.243 144.948 584.363 144.962 584.497 144.975C584.68 144.993 584.805 145.158 584.787 145.332C584.769 145.506 584.613 145.636 584.444 145.622L584.448 145.618ZM586.862 148.277H586.831C586.653 148.246 586.532 148.077 586.563 147.894C586.581 147.787 586.577 147.688 586.537 147.581C586.47 147.421 586.545 147.229 586.711 147.162C586.876 147.095 587.068 147.171 587.135 147.336C587.219 147.55 587.246 147.778 587.206 148.005C587.175 148.175 587.027 148.286 586.862 148.277ZM588.621 153.994C588.571 154.141 588.438 154.222 588.295 154.217C588.268 154.217 588.237 154.208 588.21 154.199C587.947 154.11 587.741 153.918 587.63 153.677C587.563 153.516 587.63 153.32 587.799 153.253C587.96 153.177 588.152 153.249 588.223 153.414C588.259 153.494 588.331 153.557 588.42 153.588C588.585 153.641 588.679 153.829 588.616 153.994H588.621ZM591.508 143.77C591.459 143.909 591.325 143.993 591.182 143.984C591.155 143.984 591.124 143.976 591.093 143.967C590.928 143.904 590.834 143.726 590.896 143.552C590.999 143.257 591.012 142.954 591.026 142.606C591.026 142.431 591.173 142.284 591.356 142.293C591.53 142.284 591.673 142.44 591.673 142.623C591.664 143.007 591.642 143.391 591.508 143.77ZM592.896 146.774C593.079 146.791 593.204 146.948 593.186 147.122C593.168 147.314 593.186 147.434 593.226 147.613C593.266 147.782 593.159 147.961 592.98 148.001C592.954 148.005 592.922 148.01 592.887 148.01C592.753 148.001 592.628 147.903 592.588 147.764C592.53 147.528 592.507 147.336 592.534 147.064C592.552 146.881 592.69 146.742 592.891 146.774H592.896ZM592.784 153.521C592.753 153.521 592.717 153.53 592.686 153.53C592.543 153.521 592.427 153.432 592.387 153.284C592.32 153.012 592.275 152.758 592.258 152.49C592.244 152.307 592.383 152.151 592.557 152.142C592.735 152.129 592.896 152.267 592.9 152.45C592.918 152.678 592.949 152.887 593.007 153.128C593.056 153.302 592.949 153.476 592.775 153.525L592.784 153.521ZM597.608 144.975C597.738 144.846 597.938 144.85 598.068 144.975C598.228 145.14 598.358 145.319 598.465 145.52C598.545 145.68 598.483 145.872 598.322 145.952C598.269 145.984 598.211 145.993 598.157 145.988C598.045 145.984 597.938 145.921 597.889 145.814C597.813 145.671 597.724 145.542 597.608 145.426C597.479 145.301 597.483 145.091 597.608 144.971V144.975ZM598.8 150.5C598.429 150.593 598.068 150.669 597.68 150.647H597.653C597.47 150.634 597.336 150.477 597.349 150.303C597.367 150.12 597.519 149.987 597.693 150H597.72C598.019 150.018 598.313 149.96 598.652 149.875C598.822 149.835 599 149.933 599.041 150.112C599.081 150.281 598.983 150.46 598.804 150.5H598.8ZM601.669 141.967C601.633 142.141 601.602 142.315 601.598 142.489C601.589 142.672 601.437 142.811 601.254 142.802C601.071 142.793 600.937 142.641 600.951 142.458C600.955 142.249 600.995 142.057 601.026 141.856C601.058 141.682 601.084 141.508 601.098 141.325C601.107 141.151 601.259 141.008 601.441 141.021C601.616 141.03 601.758 141.182 601.749 141.356C601.736 141.57 601.705 141.762 601.674 141.963L601.669 141.967ZM603.552 149.192C603.543 149.375 603.392 149.509 603.209 149.496C603.026 149.487 602.892 149.335 602.905 149.152L602.954 148.344C602.963 148.17 603.115 148.028 603.298 148.041C603.481 148.05 603.615 148.21 603.601 148.385L603.552 149.192ZM605.186 145.064C605.012 145.055 604.869 144.904 604.882 144.721C604.878 144.707 604.864 144.667 604.851 144.623C604.824 144.538 604.788 144.444 604.757 144.324C604.717 144.15 604.824 143.976 605.003 143.935C605.172 143.895 605.351 143.993 605.391 144.172C605.413 144.266 605.44 144.341 605.462 144.408C605.507 144.533 605.538 144.64 605.534 144.756C605.525 144.939 605.373 145.073 605.19 145.06L605.186 145.064ZM609.885 141.249L609.157 141.896C609.086 141.958 609.001 141.985 608.925 141.981C608.84 141.976 608.76 141.941 608.698 141.869C608.582 141.74 608.595 141.53 608.724 141.414L609.452 140.767C609.59 140.646 609.791 140.655 609.911 140.794C610.032 140.923 610.023 141.133 609.885 141.249ZM611.232 147.662H611.156C611.058 147.653 610.965 147.639 610.871 147.621C610.795 147.613 610.715 147.599 610.679 147.595C610.505 147.604 610.349 147.456 610.34 147.282C610.331 147.108 610.478 146.952 610.652 146.948C610.768 146.943 610.88 146.961 610.982 146.979C611.067 146.992 611.148 147.01 611.232 147.006C611.402 147.006 611.554 147.148 611.558 147.322C611.558 147.505 611.415 147.653 611.232 147.653V147.662ZM616.083 142.574C616.025 142.686 615.905 142.744 615.78 142.739C615.735 142.739 615.69 142.726 615.646 142.699L614.789 142.231C614.633 142.15 614.57 141.95 614.66 141.793C614.749 141.637 614.945 141.575 615.101 141.664L615.958 142.132C616.114 142.222 616.168 142.418 616.083 142.574ZM619.43 145.734C619.381 145.868 619.247 145.952 619.113 145.944C619.082 145.944 619.051 145.935 619.02 145.917C618.85 145.854 618.77 145.667 618.828 145.502C618.93 145.23 618.939 144.917 618.948 144.587H619.385L619.274 144.565L619.6 144.578H619.385L619.6 144.596C619.591 144.966 619.582 145.35 619.435 145.729L619.43 145.734ZM620.671 138.759C620.608 138.808 620.528 138.83 620.452 138.826C620.363 138.821 620.278 138.781 620.22 138.705C620.05 138.496 619.93 138.241 619.867 137.996C619.827 137.817 619.934 137.643 620.104 137.599C620.282 137.558 620.456 137.665 620.501 137.835C620.537 137.991 620.626 138.161 620.733 138.299C620.84 138.442 620.818 138.647 620.675 138.759H620.671ZM623.263 143.708C623.21 143.735 623.143 143.752 623.085 143.748C622.973 143.739 622.875 143.685 622.822 143.583L622.34 142.739C622.25 142.579 622.304 142.378 622.456 142.293C622.612 142.204 622.808 142.262 622.897 142.418L623.388 143.262C623.478 143.418 623.42 143.614 623.263 143.708Z"
                                        fill="#F9C200" />
                                    <path
                                        d="M609.883 141.247L609.156 141.894C609.085 141.957 609 141.984 608.924 141.979C608.839 141.975 608.759 141.939 608.696 141.868C608.58 141.738 608.594 141.529 608.723 141.412L609.451 140.765C609.589 140.645 609.79 140.654 609.91 140.792C610.031 140.922 610.022 141.131 609.883 141.247Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M616.082 142.577C616.024 142.688 615.903 142.746 615.778 142.742C615.734 142.742 615.689 142.728 615.644 142.702L614.788 142.233C614.631 142.153 614.569 141.952 614.658 141.796C614.747 141.639 614.944 141.577 615.1 141.666L615.957 142.135C616.113 142.224 616.167 142.42 616.082 142.577Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M620.671 138.759C620.609 138.808 620.528 138.831 620.452 138.826C620.363 138.822 620.278 138.782 620.22 138.706C620.051 138.496 619.93 138.242 619.868 137.996C619.828 137.818 619.935 137.644 620.104 137.599C620.283 137.559 620.457 137.666 620.502 137.836C620.537 137.992 620.626 138.161 620.734 138.3C620.841 138.443 620.818 138.648 620.676 138.759H620.671Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M623.264 143.709C623.21 143.736 623.143 143.754 623.085 143.75C622.974 143.741 622.876 143.687 622.822 143.584L622.34 142.741C622.251 142.58 622.304 142.38 622.456 142.295C622.612 142.205 622.809 142.263 622.898 142.42L623.389 143.263C623.478 143.419 623.42 143.616 623.264 143.709Z"
                                        fill="#F8B421" />
                                    <path d="M619.591 144.578H619.377L619.266 144.565L619.591 144.578Z"
                                        fill="#0E2239" />
                                    <path
                                        d="M619.434 145.735C619.385 145.869 619.251 145.953 619.117 145.945C619.086 145.945 619.054 145.936 619.023 145.918C618.854 145.855 618.773 145.668 618.831 145.503C618.934 145.231 618.943 144.918 618.952 144.588H619.389L619.603 144.601C619.594 144.972 619.585 145.355 619.438 145.735H619.434Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M611.562 147.331C611.562 147.514 611.42 147.661 611.237 147.661H611.161C611.063 147.652 610.969 147.639 610.875 147.621C610.799 147.612 610.719 147.599 610.683 147.594C610.509 147.603 610.353 147.456 610.344 147.282C610.335 147.108 610.482 146.952 610.657 146.947C610.773 146.943 610.884 146.961 610.987 146.978C611.072 146.992 611.152 147.01 611.237 147.005C611.406 147.005 611.558 147.148 611.562 147.322V147.331Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M601.748 141.361C601.735 141.575 601.704 141.767 601.673 141.968C601.637 142.142 601.606 142.316 601.601 142.49C601.592 142.673 601.44 142.811 601.258 142.802C601.075 142.794 600.941 142.642 600.954 142.459C600.959 142.249 600.999 142.057 601.03 141.856C601.061 141.682 601.088 141.508 601.101 141.325C601.11 141.151 601.262 141.008 601.445 141.022C601.619 141.031 601.762 141.183 601.753 141.357L601.748 141.361Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M605.53 144.757C605.522 144.94 605.37 145.074 605.187 145.061C605.013 145.052 604.87 144.9 604.883 144.717C604.879 144.704 604.866 144.664 604.852 144.619C604.825 144.534 604.79 144.44 604.758 144.32C604.718 144.146 604.825 143.972 605.004 143.932C605.173 143.891 605.352 143.99 605.392 144.168C605.414 144.262 605.441 144.338 605.464 144.405C605.508 144.53 605.539 144.637 605.535 144.753L605.53 144.757Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M603.603 148.38L603.554 149.188C603.545 149.371 603.394 149.505 603.211 149.491C603.028 149.482 602.894 149.331 602.907 149.148L602.956 148.34C602.965 148.166 603.117 148.023 603.3 148.037C603.483 148.045 603.617 148.206 603.603 148.38Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M598.325 145.953C598.271 145.984 598.213 145.993 598.16 145.988C598.048 145.984 597.941 145.921 597.892 145.814C597.816 145.672 597.727 145.542 597.611 145.426C597.482 145.301 597.486 145.091 597.611 144.971C597.74 144.841 597.941 144.846 598.071 144.971C598.231 145.136 598.361 145.315 598.468 145.515C598.548 145.676 598.486 145.868 598.325 145.948V145.953Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M591.506 143.771C591.457 143.909 591.323 143.994 591.18 143.985C591.153 143.985 591.122 143.976 591.091 143.967C590.926 143.905 590.832 143.726 590.894 143.552C590.997 143.258 591.011 142.954 591.024 142.606C591.024 142.432 591.171 142.285 591.354 142.294C591.528 142.285 591.671 142.441 591.671 142.624C591.662 143.008 591.64 143.391 591.506 143.771Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M598.803 150.499C598.432 150.593 598.071 150.669 597.683 150.647H597.656C597.473 150.633 597.339 150.477 597.352 150.303C597.37 150.12 597.522 149.986 597.696 149.999H597.723C598.022 150.017 598.316 149.959 598.656 149.875C598.825 149.834 599.004 149.933 599.044 150.111C599.084 150.281 598.986 150.459 598.807 150.499H598.803Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M592.981 148.001C592.954 148.005 592.923 148.01 592.887 148.01C592.753 148.001 592.628 147.903 592.588 147.764C592.53 147.528 592.508 147.336 592.535 147.064C592.553 146.881 592.691 146.742 592.892 146.774C593.075 146.792 593.2 146.948 593.182 147.122C593.164 147.314 593.182 147.434 593.222 147.613C593.262 147.782 593.155 147.961 592.976 148.001H592.981Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M592.785 153.52C592.754 153.52 592.718 153.529 592.687 153.529C592.544 153.52 592.428 153.43 592.388 153.283C592.321 153.011 592.277 152.757 592.259 152.489C592.245 152.306 592.384 152.15 592.558 152.141C592.736 152.127 592.897 152.266 592.901 152.449C592.919 152.676 592.95 152.886 593.008 153.127C593.058 153.301 592.95 153.475 592.776 153.524L592.785 153.52Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M584.789 145.33C584.772 145.504 584.615 145.633 584.446 145.62C584.441 145.62 584.432 145.62 584.432 145.62C584.285 145.606 584.16 145.593 584.04 145.571C583.776 145.535 583.567 145.508 583.268 145.513C583.094 145.513 582.938 145.374 582.938 145.196C582.938 145.022 583.08 144.875 583.254 144.87C583.607 144.866 583.843 144.892 584.129 144.937C584.241 144.95 584.361 144.964 584.495 144.977C584.678 144.995 584.803 145.16 584.785 145.334L584.789 145.33Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M587.209 148.006C587.178 148.175 587.031 148.287 586.866 148.278H586.834C586.656 148.247 586.535 148.077 586.567 147.894C586.585 147.787 586.58 147.689 586.54 147.582C586.473 147.421 586.549 147.229 586.714 147.162C586.879 147.096 587.071 147.171 587.138 147.336C587.223 147.551 587.249 147.778 587.209 148.006Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M582.265 150.642C582.193 150.722 582.104 150.758 582.006 150.749C581.934 150.749 581.863 150.713 581.81 150.664C581.341 150.24 581.145 149.91 581.185 149.62C581.203 149.446 581.372 149.317 581.546 149.343C581.72 149.361 581.841 149.517 581.832 149.687C581.836 149.714 581.899 149.865 582.242 150.187C582.376 150.312 582.385 150.513 582.269 150.642H582.265Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M588.618 153.997C588.569 154.145 588.435 154.225 588.292 154.22C588.265 154.22 588.234 154.211 588.207 154.203C587.944 154.113 587.739 153.921 587.627 153.68C587.56 153.52 587.627 153.323 587.797 153.256C587.957 153.181 588.149 153.252 588.221 153.417C588.256 153.497 588.328 153.56 588.417 153.591C588.582 153.645 588.676 153.832 588.613 153.997H588.618Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M581.02 136.333C580.859 136.534 580.614 136.713 580.373 136.806C580.328 136.824 580.279 136.833 580.234 136.833C580.109 136.824 579.998 136.748 579.953 136.628C579.886 136.463 579.967 136.271 580.136 136.208C580.27 136.15 580.426 136.039 580.511 135.932C580.623 135.789 580.832 135.771 580.971 135.883C581.109 135.994 581.136 136.2 581.02 136.333Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M585.392 134.966C585.338 135.002 585.271 135.02 585.209 135.015C585.106 135.011 585.003 134.953 584.95 134.864C584.789 134.605 584.762 134.301 584.745 134.056C584.736 133.976 584.727 133.904 584.718 133.846C584.682 133.677 584.789 133.498 584.968 133.467C585.146 133.431 585.316 133.547 585.347 133.726C585.369 133.797 585.374 133.895 585.383 134.002C585.405 134.181 585.423 134.404 585.503 134.525C585.592 134.681 585.548 134.877 585.392 134.971V134.966Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M590.585 134.344C590.518 134.407 590.429 134.424 590.349 134.42C590.268 134.415 590.188 134.38 590.125 134.317C589.858 134.009 589.715 133.862 589.389 133.688C589.233 133.599 589.17 133.402 589.26 133.246C589.349 133.09 589.545 133.037 589.702 133.117C590.13 133.358 590.331 133.572 590.612 133.889C590.728 134.027 590.715 134.233 590.585 134.349V134.344Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M601.011 131.86C600.788 131.918 600.582 132.034 600.44 132.176C600.368 132.243 600.279 132.279 600.194 132.27C600.118 132.266 600.042 132.23 599.98 132.172C599.859 132.042 599.859 131.833 599.989 131.712C600.207 131.494 600.511 131.32 600.837 131.23C601.011 131.181 601.194 131.284 601.238 131.458C601.287 131.636 601.185 131.81 601.015 131.86H601.011Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M611.466 129.678C611.413 129.825 611.279 129.905 611.136 129.897C611.109 129.897 611.083 129.888 611.051 129.879C610.864 129.816 610.52 129.709 610.431 129.687C610.257 129.638 610.159 129.464 610.208 129.29C610.253 129.111 610.431 129.017 610.605 129.058C610.703 129.084 611.065 129.196 611.261 129.267C611.431 129.325 611.52 129.513 611.462 129.678H611.466Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M616.772 129.689C616.714 129.725 616.648 129.738 616.581 129.738C616.482 129.734 616.384 129.68 616.322 129.587C616.228 129.431 616.134 129.252 616.076 129.118C616.014 128.944 616.09 128.761 616.264 128.694C616.424 128.627 616.616 128.708 616.683 128.877C616.719 128.962 616.786 129.105 616.875 129.248C616.969 129.395 616.924 129.596 616.768 129.698L616.772 129.689Z"
                                        fill="#F8B421" />
                                    <path
                                        d="M581.108 142.851C580.769 142.828 580.416 142.717 580.082 142.516C579.524 142.186 579.109 141.744 578.703 141.315C578.435 141.034 578.185 140.771 577.913 140.552C576.819 139.687 576.195 139.513 574.874 139.432C574.517 139.41 574.245 139.102 574.267 138.745C574.289 138.388 574.597 138.116 574.954 138.134C576.637 138.236 577.48 138.549 578.721 139.53C579.069 139.807 579.363 140.119 579.649 140.418C580.01 140.798 580.349 141.155 580.747 141.396C580.974 141.53 581.188 141.579 581.34 141.534C581.461 141.498 581.559 141.391 581.639 141.217C581.826 140.816 581.733 140.566 581.496 140.039C581.385 139.789 581.26 139.508 581.179 139.182C581.046 138.638 581.139 138.125 581.447 137.741C581.804 137.295 582.407 137.054 583.143 137.072C584.267 137.112 585.129 137.879 585.754 138.45L585.838 138.526C586.396 139.04 588.087 140.597 588.949 140.401C589.025 140.383 589.248 140.334 589.44 139.843C589.698 139.187 589.484 138.567 589.208 137.781C589.002 137.192 588.851 136.554 589.19 136.009C589.529 135.469 590.167 135.331 590.618 135.273C592.296 135.063 593.268 136.059 594.13 136.938C594.701 137.518 595.236 138.067 595.933 138.236C596.45 138.361 597.28 138.33 597.428 137.732C597.49 137.473 597.356 137.08 597.222 136.697C597.026 136.139 596.807 135.505 597.044 134.872C597.191 134.479 597.486 134.184 597.901 134.015C598.731 133.676 599.833 133.93 600.368 134.184C601.283 134.617 601.81 135.291 602.319 135.943C602.506 136.179 602.693 136.42 602.903 136.652C603.39 137.179 604.385 137.759 604.911 137.509C605.349 137.299 605.344 136.616 605.206 135.661C605.184 135.505 605.143 135.336 605.103 135.157C604.925 134.372 604.657 133.189 605.723 132.547C607.031 131.761 608.999 132.904 609.695 133.546C609.914 133.747 610.159 134.046 610.44 134.394C611.052 135.144 611.98 136.277 612.703 136.34C612.819 136.344 612.997 136.34 613.225 136.139C613.528 135.876 613.35 134.88 613.221 134.153C613.038 133.144 612.868 132.194 613.337 131.516C613.493 131.293 613.787 131.007 614.327 130.913C615.608 130.686 616.853 132.096 617.679 133.028C617.813 133.18 617.938 133.319 618.04 133.426C619.33 134.769 619.888 134.93 620.138 134.827C620.325 134.751 620.437 134.635 620.508 134.461C620.86 133.573 620.004 131.667 619.678 130.949L619.602 130.775C619.455 130.449 619.602 130.065 619.932 129.918C620.262 129.771 620.642 129.918 620.789 130.248L620.865 130.418C621.356 131.511 622.271 133.542 621.717 134.938C621.521 135.438 621.146 135.813 620.642 136.023C619.285 136.59 617.817 135.063 617.116 134.332C616.996 134.202 616.862 134.055 616.715 133.885C616.237 133.345 615.122 132.082 614.564 132.185C614.443 132.207 614.421 132.243 614.412 132.252C614.247 132.488 614.403 133.35 614.506 133.921C614.711 135.068 614.948 136.366 614.086 137.116C613.649 137.495 613.136 137.674 612.6 137.629C611.333 137.522 610.24 136.188 609.445 135.211C609.204 134.916 608.977 134.635 608.825 134.497C608.16 133.885 606.888 133.368 606.402 133.658C606.179 133.792 606.21 134.126 606.379 134.867C606.429 135.077 606.473 135.282 606.5 135.469C606.62 136.291 606.866 138.004 605.483 138.674C604.229 139.276 602.684 138.321 601.957 137.527C601.721 137.272 601.511 137.005 601.306 136.741C600.85 136.161 600.458 135.657 599.82 135.358C599.431 135.175 598.74 135.077 598.396 135.215C598.289 135.26 598.275 135.3 598.267 135.322C598.191 135.519 598.325 135.902 598.454 136.268C598.637 136.799 598.851 137.406 598.695 138.04C598.365 139.397 596.905 139.798 595.638 139.499C594.58 139.245 593.853 138.504 593.21 137.848C592.349 136.973 591.774 136.438 590.787 136.563C590.386 136.612 590.296 136.701 590.296 136.701C590.296 136.701 590.261 136.831 590.435 137.321C590.747 138.227 591.095 139.218 590.658 140.32C590.292 141.248 589.69 141.565 589.248 141.664C587.73 142.012 585.936 140.365 584.973 139.481L584.888 139.405C584.366 138.928 583.759 138.37 583.125 138.37C582.759 138.361 582.545 138.464 582.474 138.553C582.424 138.616 582.416 138.723 582.451 138.87C582.505 139.084 582.599 139.289 582.697 139.508C582.956 140.088 583.281 140.811 582.831 141.766C582.527 142.413 582.067 142.672 581.737 142.77C581.541 142.828 581.336 142.855 581.126 142.842L581.108 142.851Z"
                                        fill="white" />
                                    <defs>
                                        <linearGradient id="paint0_linear_381_71673" x1="530.546" y1="327.134"
                                            x2="503.767" y2="347.683" gradientUnits="userSpaceOnUse">
                                            <stop offset="0.0001" stop-color="#FF6648" />
                                            <stop offset="1" stop-color="#D62300" />
                                        </linearGradient>
                                    </defs>
                                </svg>

                            </span>
                        </div>


                        <div class="error_thumb_btn">
                            <a href="{{ route('home') }}" class="thm-btn">{{ __('translate.Back to Home') }}</a>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </main>

<script src="{{ asset('global/js/jquery-3.7.1.min.js') }}"></script>
<script src="{{asset('frontend/assets/js/bootstrap.bundle.min.js')}}"></script>
<script src="{{asset('frontend/assets/js/slick.min.js')}}"></script>
<script src="{{asset('frontend/assets/js/main.js')}}"></script>


</body>

</html>
