@extends('frontend.layouts.master')

@section('title')
    <title>{{ env('APP_NAME') }} - {{ __('translate.Shopping Cart') }}</title>
@endsection

@section('content')
    <main>
        <!-- banner-part start  -->

        <div class="profile_bg" style="background-image: url({{ asset($general_setting->breadcrumb_image) }})">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">
                        <ul class="breadcrumb">
                            <li><a href="{{route('home')}}">{{__('translate.Home')}}</a></li>
                            <li><a href="javascript:;">/</a></li>
                            <li><a href="javascript:;" class="active">{{__('translate.Shopping Cart')}}</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- banner-part end -->


        <!-- add to cart part start  -->
        <section class="add_to_cart">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">

                        <div class="add_to_cart_tabel">

                                <div class="text-center {{ (session('cart') && count(session('cart')) > 0) ? 'd-none' : '' }} " id="empty_cart" >

                                <div class="mb-5">
                                    <svg width="226" height="236" viewBox="0 0 226 236" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M48.3999 14.4283L45.4921 13.7974L44.8338 10.8896C44.8063 10.7798 44.724 10.725 44.6143 10.725C44.5046 10.725 44.4223 10.8073 44.3948 10.8896L43.7365 13.8248L40.8286 14.5106C40.7189 14.5381 40.6641 14.6203 40.6641 14.7301C40.6641 14.8398 40.7464 14.9221 40.8561 14.9495L43.7639 15.5805L44.4223 18.4883C44.4497 18.598 44.532 18.6529 44.6417 18.6529C44.7514 18.6529 44.8338 18.5706 44.8612 18.4883L45.5196 15.553L48.4274 14.8672C48.5371 14.8398 48.5919 14.7575 48.5919 14.6478C48.5919 14.5381 48.5097 14.4283 48.3999 14.4283Z" fill="#FCCBD5"/>
                                        <path d="M53.716 1.92025L52.2073 1.59107L51.8781 0.0823097C51.8781 0.0274455 51.8232 0 51.7683 0C51.7135 0 51.6586 0.0274455 51.6586 0.0823097L51.302 1.59107L49.7932 1.94767C49.7384 1.94767 49.7109 2.00254 49.7109 2.05741C49.7109 2.11227 49.7384 2.16714 49.7932 2.16714L51.302 2.49631L51.6312 4.00508C51.6312 4.05994 51.6861 4.08739 51.7409 4.08739C51.7958 4.08739 51.8507 4.05994 51.8507 4.00508L52.2073 2.49631L53.716 2.13972C53.7709 2.13972 53.7983 2.08485 53.7983 2.02998C53.7983 1.97512 53.7709 1.94768 53.716 1.92025Z" fill="#FCCBD5"/>
                                        <path d="M163.368 138.29L160.542 137.686L159.912 134.888C159.884 134.778 159.802 134.723 159.692 134.723C159.582 134.723 159.5 134.806 159.473 134.888L158.842 137.713L156.016 138.372C155.906 138.399 155.852 138.482 155.852 138.591C155.852 138.701 155.934 138.783 156.016 138.811L158.842 139.414L159.473 142.212C159.5 142.322 159.582 142.377 159.692 142.377C159.802 142.377 159.884 142.295 159.912 142.212L160.542 139.387L163.368 138.728C163.478 138.701 163.533 138.619 163.533 138.509C163.533 138.399 163.45 138.317 163.368 138.29Z" fill="#FCCBD5"/>
                                        <path d="M169.84 126.38L168.002 125.969L167.591 124.131C167.563 124.076 167.508 124.021 167.453 124.021C167.399 124.021 167.316 124.076 167.316 124.131L166.905 125.969L165.067 126.408C165.012 126.435 164.957 126.49 164.957 126.545C164.957 126.6 165.012 126.682 165.067 126.682L166.905 127.094L167.316 128.932C167.344 128.986 167.399 129.041 167.453 129.041C167.508 129.041 167.591 128.986 167.591 128.932L168.002 127.094L169.84 126.655C169.895 126.627 169.95 126.572 169.95 126.518C169.95 126.435 169.895 126.38 169.84 126.38Z" fill="#FCCBD5"/>
                                        <path d="M67.797 123.91L65.9591 123.498L65.5476 121.66C65.5201 121.605 65.4653 121.55 65.4104 121.55C65.3555 121.55 65.2732 121.605 65.2732 121.66L64.8618 123.498L63.0238 123.937C62.9689 123.964 62.9141 124.019 62.9141 124.074C62.9141 124.129 62.9689 124.211 63.0238 124.211L64.8618 124.623L65.2732 126.461C65.3007 126.516 65.3555 126.57 65.4104 126.57C65.4653 126.57 65.5476 126.516 65.5476 126.461L65.9591 124.623L67.797 124.184C67.8519 124.156 67.9067 124.102 67.9067 124.047C67.9067 123.964 67.8519 123.91 67.797 123.91Z" fill="#FCCBD5"/>
                                        <path d="M133.73 20.0311L137.214 22.9389C137.214 22.9389 138.311 38.4106 151.369 36.0241L153.536 39.892C153.536 39.892 149.009 51.578 158.83 53.224L159.955 58.6007C159.955 58.6007 153.865 63.5659 158.611 70.4788L150.491 74.2369L127.887 25.2432L133.73 20.0311Z" fill="#FCCBD5"/>
                                        <path d="M154.24 62.2771C154.24 59.0675 155.722 56.1872 158.053 54.3218C158.053 54.2669 158.026 54.2395 158.026 54.1846C152.896 53.636 148.891 49.3017 148.891 44.0348C148.891 41.5659 149.769 39.3164 151.195 37.5608C151.14 37.4785 151.086 37.3962 151.031 37.2865C149.412 37.9997 147.602 38.3837 145.709 38.3837C138.275 38.3837 132.24 32.3487 132.24 24.9146C132.24 23.4058 132.487 21.9519 132.953 20.5803C125.848 16.7124 117.701 14.5178 109.06 14.5178C81.408 14.5178 59.0234 36.9299 59.0234 64.554C59.0234 92.1781 81.4355 114.59 109.06 114.59C134.599 114.59 155.694 95.4425 158.712 70.7262C156.023 68.8882 154.24 65.7884 154.24 62.2771ZM108.676 78.0231C101.461 78.0231 95.5904 72.1801 95.5904 64.938C95.5904 57.6959 101.433 51.8529 108.676 51.8529C115.918 51.8529 121.761 57.6959 121.761 64.938C121.761 72.1801 115.89 78.0231 108.676 78.0231Z" fill="white"/>
                                        <path d="M109.062 115.413C81.0266 115.413 58.2031 92.5898 58.2031 64.5542C58.2031 36.5186 81.0266 13.6951 109.062 13.6951C117.539 13.6951 125.96 15.8348 133.367 19.8673L133.971 20.1965L133.751 20.8548C133.312 22.1716 133.065 23.5432 133.065 24.9148C133.065 31.8826 138.744 37.561 145.712 37.561C147.44 37.561 149.113 37.2044 150.704 36.546L151.335 36.2717L151.774 36.9575C151.801 37.0123 151.856 37.0672 151.884 37.1221L152.213 37.6158L151.829 38.0822C150.457 39.7556 149.689 41.8678 149.689 44.035C149.689 48.863 153.31 52.8681 158.083 53.3619L158.687 53.4167L158.934 54.6237L158.55 54.9529C156.328 56.736 155.038 59.3969 155.038 62.2499C155.038 65.3497 156.575 68.2575 159.153 70.0131L159.565 70.2875L159.51 70.7813C156.437 96.2382 134.711 115.413 109.062 115.413ZM109.062 15.341C81.9319 15.341 59.8491 37.4238 59.8491 64.5542C59.8491 91.6845 81.9319 113.767 109.062 113.767C133.724 113.767 154.6 95.4701 157.836 71.1104C155.066 69.0256 153.42 65.7612 153.42 62.2773C153.42 59.4518 154.49 56.7635 156.41 54.7335C151.555 53.5265 148.071 49.1648 148.071 44.035C148.071 42.1696 148.537 40.3316 149.442 38.7131C148.235 39.0423 147.001 39.2069 145.739 39.2069C137.866 39.2069 131.447 32.7878 131.447 24.9148C131.447 23.5706 131.639 22.2539 131.995 20.992C124.973 17.2887 117.045 15.341 109.062 15.341ZM108.678 78.8463C101.025 78.8463 94.7701 72.6192 94.7701 64.9382C94.7701 57.2572 100.997 51.0301 108.678 51.0301C116.332 51.0301 122.586 57.2572 122.586 64.9382C122.586 72.6192 116.332 78.8463 108.678 78.8463ZM108.678 52.7035C101.93 52.7035 96.4161 58.1899 96.4161 64.9657C96.4161 71.714 101.902 77.2278 108.678 77.2278C115.426 77.2278 120.94 71.7414 120.94 64.9657C120.94 58.1899 115.426 52.7035 108.678 52.7035Z" fill="#FCCBD5"/>
                                        <path d="M145.929 58.0211C141.978 54.2629 143.35 48.3101 143.35 48.3101C144.338 36.816 135.23 37.6116 135.23 37.6116C130.265 37.6116 128.153 34.6215 127.11 32.4544C122.337 22.5788 116.741 26.1724 113.641 27.9006C108.978 30.4792 104.534 27.9006 104.534 27.9006C98.9924 25.514 96.2217 26.7211 96.2217 26.7211C92.6555 27.3246 90.9822 32.1252 89.6929 34.2649C87.5806 37.7488 82.7525 38.1877 80.1739 38.6266C71.7797 40.0256 73.8645 45.2651 74.8247 47.734C77.321 54.2354 72.8221 57.7742 70.463 60.0236C64.181 66.0313 71.2585 71.1336 71.2585 71.1336C76.4157 75.3033 74.8247 82.4356 74.8247 82.4356C73.4256 91.7626 78.7749 92.0643 81.765 92.1466C88.1018 92.3112 90.653 96.7826 91.86 99.6904C93.9723 104.711 98.3065 103.86 100.775 103.86C108.95 103.805 110.678 112.172 110.678 112.172C113.449 120.1 112.9 126.903 112.269 131.786C111.611 136.751 114.053 140.509 116.631 140.509C123.16 140.509 121.212 133.267 120.389 130.798C119.045 126.629 118.853 122.953 118.798 120.292C118.689 113.352 120.581 110.855 123.16 110.965C126.809 111.157 126.26 118.07 125.739 120.484C124.394 126.601 126.918 127.013 126.918 127.013C128.893 127.616 130.128 126.19 130.484 125.422C133.694 118.673 130.238 111.706 129.689 107.179C128.674 98.5108 134.874 98.6755 137.809 97.4684C145.654 94.2589 142.966 80.8171 142.966 80.8171C142.362 74.4803 146.724 71.1062 146.724 71.1062C153.061 63.9464 145.929 58.0211 145.929 58.0211ZM108.676 75.4405C102.778 75.4405 97.9774 70.6398 97.9774 64.7419C97.9774 58.844 102.778 54.0434 108.676 54.0434C114.574 54.0434 119.374 58.844 119.374 64.7419C119.374 70.6673 114.574 75.4405 108.676 75.4405Z" fill="url(#paint0_linear_1461_12761)"/>
                                        <path d="M116.614 141.279C115.462 141.279 114.31 140.702 113.405 139.66C111.759 137.795 111.046 134.805 111.457 131.65C112.143 126.301 112.527 119.854 109.921 112.42L109.893 112.31C109.839 112.008 108.193 104.657 100.896 104.657C100.868 104.657 100.841 104.657 100.813 104.657C100.539 104.657 100.237 104.684 99.9355 104.684C97.4392 104.794 93.2147 104.958 91.1298 99.9932C89.8954 97.0305 87.5637 93.1078 81.7481 92.9706C80.1844 92.9432 77.2492 92.8609 75.4112 90.6663C73.9024 88.8832 73.4635 86.14 74.0122 82.2995V82.2447C74.0396 82.1898 75.4112 75.5512 70.7478 71.7656C70.4186 71.5187 67.2913 69.1321 67.0444 65.5934C66.9073 63.4262 67.84 61.3414 69.8974 59.4211C70.062 59.2565 70.2266 59.092 70.4186 58.9274C72.86 56.6505 76.1793 53.5507 74.0671 48.0368L74.0396 47.982C73.4087 46.3635 72.3663 43.6203 73.7379 41.2611C74.7254 39.5054 76.8651 38.3533 80.0747 37.8321C80.2941 37.8047 80.541 37.7498 80.8154 37.7224C83.394 37.3383 87.2893 36.7348 89.0176 33.8544C89.2645 33.4704 89.5113 32.9492 89.8131 32.4005C91.0749 29.9316 92.8306 26.5301 96.0676 25.954C96.6711 25.7345 99.6612 24.9116 104.928 27.1884L105.01 27.2433C105.175 27.3256 109.153 29.5476 113.322 27.2433L113.652 27.0513C115.544 25.9814 118.397 24.3904 121.497 25.3505C123.993 26.1186 126.078 28.368 127.916 32.1536C129.452 35.3083 131.839 36.8445 135.268 36.8445C135.707 36.8171 139.191 36.6525 141.742 39.2037C143.772 41.2337 144.595 44.3335 144.266 48.4483L144.238 48.558C144.238 48.6129 143.031 54.0719 146.57 57.4735C146.899 57.7478 149.944 60.4636 150.246 64.4412C150.438 66.965 149.478 69.4064 147.448 71.7107L147.393 71.7656L147.338 71.8205C147.174 71.9576 143.361 75.0026 143.882 80.7633C144.074 81.7783 146.46 94.9183 138.231 98.2924C137.682 98.5119 137.051 98.7039 136.393 98.8685C133.32 99.7189 129.864 100.679 130.632 107.126C130.769 108.25 131.098 109.594 131.455 110.993C132.525 115.245 133.842 120.54 131.345 125.807C130.851 126.822 129.288 128.55 126.819 127.837C126.572 127.782 125.914 127.562 125.393 126.767C124.515 125.45 124.378 123.283 125.036 120.32C125.53 118.098 125.694 114.066 124.46 112.475C124.131 112.036 123.747 111.844 123.225 111.816C122.54 111.789 121.963 111.981 121.497 112.447C120.647 113.27 119.659 115.3 119.742 120.293C119.796 123.146 120.016 126.602 121.278 130.553C122.183 133.323 122.896 137.109 121.223 139.413C120.153 140.62 118.644 141.279 116.614 141.279ZM111.457 111.899C114.173 119.662 113.789 126.328 113.075 131.842C112.664 135.024 113.624 137.383 114.639 138.563C115.243 139.249 115.956 139.633 116.614 139.633C118.123 139.633 119.165 139.221 119.769 138.371C120.756 136.999 120.702 134.393 119.604 130.991C118.26 126.849 118.013 123.228 117.986 120.238C117.904 115.739 118.672 112.694 120.235 111.186C121.031 110.417 122.073 110.033 123.198 110.088C124.185 110.143 125.036 110.582 125.667 111.405C127.505 113.819 126.929 118.867 126.545 120.595C125.639 124.71 126.6 125.971 127.093 126.136H127.176V126.163C128.931 126.685 129.727 125.094 129.754 125.011C132.004 120.293 130.742 115.3 129.754 111.295C129.398 109.841 129.041 108.442 128.904 107.208C127.971 99.3349 132.717 98.0181 135.872 97.1677C136.502 97.0031 137.079 96.8385 137.545 96.6465C144.677 93.7387 142.236 81.0376 142.208 80.9279V80.8456C141.605 74.4814 145.637 70.9426 146.213 70.4489C147.914 68.5012 148.71 66.4986 148.573 64.4412C148.326 61.0122 145.5 58.5982 145.473 58.5982L145.445 58.5708C141.358 54.7028 142.455 48.8598 142.62 48.1466C142.922 44.5804 142.236 41.9469 140.59 40.2736C138.478 38.1613 135.405 38.3807 135.378 38.3807H135.295C131.208 38.3807 128.245 36.4879 126.435 32.7572C124.816 29.4379 123.006 27.4353 121.003 26.8044C118.589 26.0363 116.203 27.3805 114.447 28.368L114.09 28.56C109.29 31.2209 104.764 28.8892 104.215 28.5875C99.1674 26.4203 96.5888 27.4079 96.5614 27.4079L96.4791 27.4353L96.3693 27.4627C93.9005 27.8742 92.3643 30.8643 91.2396 33.0589C90.9378 33.635 90.6635 34.1562 90.3892 34.5951C88.2495 38.1064 83.7231 38.8196 81.0348 39.2311C80.7879 39.2586 80.541 39.3134 80.3216 39.3409C77.6332 39.7798 75.905 40.6576 75.1644 41.9743C74.2042 43.6751 75.0272 45.8423 75.5758 47.2962L75.6033 47.351C78.127 53.9073 74.0122 57.7478 71.5433 60.0521C71.3513 60.2167 71.1867 60.3813 71.0221 60.5458C69.3487 62.1369 68.5806 63.7828 68.6903 65.4288C68.8824 68.2817 71.7079 70.3665 71.7353 70.394L71.7628 70.4214C77.1395 74.7557 75.7404 81.888 75.6307 82.519C75.1369 85.8108 75.4935 88.17 76.6457 89.5416C77.9075 91.0504 79.9375 91.2149 81.7755 91.2424C86.8504 91.3521 90.3892 93.9856 92.6112 99.28C94.2571 103.203 97.3569 103.066 99.8258 102.956C100.155 102.928 100.484 102.928 100.758 102.928C100.786 102.928 100.841 102.928 100.868 102.928C109.125 102.956 111.265 111.076 111.457 111.899ZM108.686 76.2645C102.322 76.2645 97.1649 71.1072 97.1649 64.743C97.1649 58.3787 102.322 53.2215 108.686 53.2215C115.051 53.2215 120.208 58.3787 120.208 64.743C120.208 71.1072 115.023 76.2645 108.686 76.2645ZM108.686 54.8674C103.227 54.8674 98.8108 59.3114 98.8108 64.743C98.8108 70.1745 103.255 74.6185 108.686 74.6185C114.118 74.6185 118.562 70.1745 118.562 64.743C118.562 59.3114 114.118 54.8674 108.686 54.8674Z" fill="#FCCBD5"/>
                                        <path d="M120.656 46.3101C121.37 46.3101 121.946 46.8861 121.946 47.5994V52.7566C121.946 53.4698 121.37 54.0459 120.656 54.0459C119.943 54.0459 119.367 53.4698 119.367 52.7566V47.5994C119.367 46.8861 119.943 46.3101 120.656 46.3101Z" fill="white"/>
                                        <path d="M120.654 54.5933C119.639 54.5933 118.816 53.7703 118.816 52.7553V47.5981C118.816 46.5831 119.639 45.7601 120.654 45.7601C121.669 45.7601 122.492 46.5831 122.492 47.5981V52.7553C122.492 53.7703 121.669 54.5933 120.654 54.5933ZM120.654 46.8574C120.243 46.8574 119.914 47.1866 119.914 47.5981V52.7553C119.914 53.1668 120.243 53.496 120.654 53.496C121.066 53.496 121.395 53.1668 121.395 52.7553V47.5981C121.395 47.1866 121.066 46.8574 120.654 46.8574Z" fill="#FCCBD5"/>
                                        <path d="M101.32 42.6623C101.841 42.1685 102.637 42.1685 103.131 42.6897L106.724 46.393C107.218 46.9142 107.218 47.7098 106.697 48.2035C106.176 48.6973 105.38 48.6973 104.886 48.1761L101.293 44.4728C100.799 43.979 100.799 43.156 101.32 42.6623Z" fill="white"/>
                                        <path d="M105.822 49.1035C105.795 49.1035 105.795 49.1035 105.822 49.1035C105.301 49.1035 104.835 48.9115 104.505 48.5548L100.912 44.8515C100.583 44.4949 100.391 44.0285 100.391 43.5348C100.391 43.041 100.583 42.5746 100.939 42.2455C101.296 41.9163 101.762 41.7242 102.256 41.7242C102.75 41.7242 103.216 41.9163 103.545 42.2729L107.139 45.9762C107.468 46.3328 107.66 46.7992 107.66 47.293C107.66 47.7868 107.468 48.2531 107.111 48.5823C106.755 48.9115 106.289 49.1035 105.822 49.1035ZM102.201 42.8215C102.009 42.8215 101.817 42.9038 101.68 43.041C101.543 43.1782 101.46 43.3702 101.46 43.5622C101.46 43.7542 101.543 43.9462 101.68 44.0834L105.274 47.7867C105.411 47.9239 105.603 48.0062 105.795 48.0062C105.987 48.0062 106.179 47.9239 106.316 47.7867C106.453 47.6496 106.535 47.4576 106.535 47.2655C106.535 47.0735 106.453 46.8815 106.316 46.7443L102.722 43.041C102.613 42.9038 102.421 42.849 102.201 42.8215C102.229 42.8215 102.229 42.8215 102.201 42.8215Z" fill="#FCCBD5"/>
                                        <path d="M91.4244 46.1473C92.0279 46.5313 92.1925 47.3268 91.8084 47.9304L89.0378 52.2646C88.6538 52.8681 87.8582 53.0327 87.2547 52.6487C86.6512 52.2646 86.4866 51.4691 86.8707 50.8656L89.6413 46.5313C90.0253 45.9278 90.8209 45.7632 91.4244 46.1473Z" fill="#77E0B5"/>
                                        <path d="M87.9629 53.3862C87.6337 53.3862 87.2771 53.3039 86.9754 53.0845C86.5639 52.8102 86.2896 52.3987 86.1798 51.9323C86.0701 51.466 86.1524 50.9722 86.4267 50.5607L89.1974 46.2265C89.746 45.3761 90.8707 45.1292 91.7211 45.6778C92.5715 46.2265 92.8184 47.3512 92.2698 48.2016L89.4991 52.5358C89.1425 53.0845 88.5664 53.3862 87.9629 53.3862ZM90.7336 46.4733C90.4867 46.4733 90.2398 46.5831 90.1026 46.8025L87.332 51.1368C87.2222 51.3014 87.1948 51.4934 87.2223 51.6854C87.2771 51.8775 87.3868 52.0421 87.5514 52.1518C87.9081 52.3712 88.347 52.2615 88.5664 51.9323L91.3371 47.5981C91.5565 47.2414 91.4468 46.8025 91.1176 46.5831C91.0079 46.5282 90.8707 46.4733 90.7336 46.4733Z" fill="#FCCBD5"/>
                                        <path d="M94.1084 67.9537C94.3827 68.612 94.0535 69.3527 93.3951 69.6271L88.6219 71.5473C87.9636 71.8216 87.2229 71.4924 86.9486 70.834C86.6743 70.1757 87.0034 69.435 87.6618 69.1607L92.435 67.2405C93.0934 66.9661 93.8615 67.2953 94.1084 67.9537Z" fill="white"/>
                                        <path d="M88.1521 72.2071C87.9052 72.2071 87.6583 72.1523 87.4388 72.07C86.9999 71.8779 86.6433 71.5213 86.4513 71.055C86.0672 70.1223 86.5336 69.0525 87.4663 68.6684L92.2395 66.7482C93.1721 66.3641 94.242 66.8304 94.6261 67.7631C95.0101 68.6958 94.5438 69.7657 93.6111 70.1497L88.8379 72.07C88.6184 72.1523 88.3715 72.2071 88.1521 72.2071ZM92.9253 67.7083C92.843 67.7083 92.7332 67.7357 92.6509 67.7631L87.8777 69.6834C87.4937 69.848 87.3291 70.2595 87.4663 70.6435C87.5486 70.8355 87.6857 70.9727 87.8503 71.055C88.0423 71.1373 88.2344 71.1373 88.4264 71.055L93.1996 69.1347C93.5836 68.9701 93.7482 68.5587 93.6111 68.1746C93.5013 67.8729 93.1996 67.7083 92.9253 67.7083Z" fill="#FCCBD5"/>
                                        <path d="M90.2611 82.1613C90.7 82.7373 90.5628 83.5329 90.0142 83.9718L85.8994 87.0442C85.3233 87.4831 84.5278 87.3459 84.0889 86.7973C83.65 86.2212 83.7871 85.4257 84.3358 84.9868L88.4506 81.9144C89.0267 81.4755 89.8222 81.5852 90.2611 82.1613Z" fill="#77E0B5"/>
                                        <path d="M85.1054 87.8413C85.0231 87.8413 84.9408 87.8413 84.8311 87.8139C84.3373 87.7316 83.9258 87.4847 83.6241 87.1006C83.3223 86.7166 83.2126 86.2228 83.2675 85.729C83.3498 85.2352 83.5967 84.8238 83.9807 84.522L88.0955 81.4496C88.9185 80.8461 90.0707 81.0107 90.6742 81.8337C90.9759 82.2177 91.0856 82.7115 91.0308 83.2053C90.9485 83.6991 90.7016 84.1105 90.3175 84.4123L86.2027 87.4847C85.8735 87.7316 85.4895 87.8413 85.1054 87.8413ZM89.2203 82.1903C89.0557 82.1903 88.9185 82.2451 88.7813 82.3274L84.6665 85.3998C84.5019 85.5096 84.3922 85.7016 84.3648 85.8936C84.3374 86.0856 84.3922 86.2777 84.5019 86.4422C84.6117 86.6068 84.8037 86.7166 84.9957 86.744C85.1877 86.7714 85.3798 86.7166 85.5443 86.6068L89.6592 83.5345C89.8238 83.4247 89.9335 83.2327 89.9609 83.0407C89.9884 82.8486 89.9335 82.6566 89.8238 82.492C89.714 82.3274 89.522 82.2177 89.33 82.1903C89.3026 82.1903 89.2477 82.1903 89.2203 82.1903Z" fill="#FCCBD5"/>
                                        <path d="M104.942 80.2164C105.656 80.1616 106.259 80.7102 106.314 81.4234L106.643 86.5532C106.698 87.2665 106.149 87.87 105.436 87.9248C104.723 87.9797 104.119 87.4311 104.065 86.7178L103.735 81.588C103.708 80.8748 104.257 80.2713 104.942 80.2164Z" fill="#77E0B5"/>
                                        <path d="M105.354 88.4741C104.915 88.4741 104.476 88.3096 104.147 88.0078C103.79 87.6786 103.571 87.2397 103.516 86.7459L103.187 81.6161C103.159 81.1223 103.324 80.656 103.653 80.2719C103.982 79.9153 104.421 79.6959 104.915 79.641C105.409 79.6136 105.875 79.7782 106.259 80.1073C106.616 80.4365 106.835 80.8754 106.89 81.3692L107.219 86.499C107.246 86.9928 107.082 87.4591 106.753 87.8432C106.424 88.1998 105.985 88.4193 105.491 88.4741C105.436 88.4741 105.409 88.4741 105.354 88.4741ZM105.024 80.7657C104.997 80.7657 104.997 80.7657 104.97 80.7657C104.778 80.7657 104.586 80.8755 104.448 81.0126C104.311 81.1498 104.256 81.3418 104.256 81.5613L104.586 86.691C104.586 86.8831 104.695 87.0751 104.832 87.2123C104.97 87.3494 105.162 87.4043 105.381 87.4043C105.573 87.4043 105.765 87.2945 105.902 87.1574C106.039 87.0202 106.094 86.8282 106.094 86.6087L105.765 81.4789C105.765 81.2869 105.655 81.0949 105.518 80.9577C105.381 80.8206 105.217 80.7657 105.024 80.7657Z" fill="#FCCBD5"/>
                                        <path d="M96.6068 91.9869C97.0457 91.4382 97.8686 91.3285 98.4173 91.7674L102.45 94.9495C102.998 95.3884 103.108 96.2114 102.669 96.76C102.23 97.3087 101.407 97.4184 100.859 96.9795L96.8262 93.7974C96.2776 93.3585 96.1678 92.5355 96.6068 91.9869Z" fill="white"/>
                                        <path d="M101.687 97.8014C101.275 97.8014 100.891 97.6643 100.562 97.4174L96.5297 94.2352C96.1456 93.9335 95.8987 93.4946 95.8439 93.0008C95.789 92.507 95.9262 92.0407 96.2279 91.6566C96.5297 91.2726 96.9686 91.0257 97.4624 90.9708C97.9561 90.916 98.4225 91.0531 98.8065 91.3549L102.839 94.537C103.223 94.8387 103.47 95.2777 103.525 95.7714C103.58 96.2652 103.443 96.7316 103.141 97.1156C102.757 97.582 102.236 97.8014 101.687 97.8014ZM97.627 92.0407C97.5995 92.0407 97.5721 92.0407 97.5447 92.0407C97.3527 92.0681 97.1606 92.1504 97.0509 92.315C96.9412 92.4796 96.8863 92.6716 96.8863 92.8636C96.9137 93.0557 96.996 93.2477 97.1606 93.3574L101.193 96.5396C101.358 96.6493 101.55 96.7041 101.742 96.7041C101.934 96.6767 102.126 96.5944 102.236 96.4298C102.482 96.1006 102.428 95.6343 102.126 95.3874L98.0933 92.2053C97.9562 92.0955 97.7915 92.0407 97.627 92.0407Z" fill="#FCCBD5"/>
                                        <path d="M130.707 80.9817C131.283 81.4206 131.392 82.2162 130.953 82.7922L127.854 86.907C127.415 87.4831 126.619 87.5928 126.043 87.1539C125.467 86.715 125.357 85.9195 125.796 85.3434L128.896 81.2286C129.335 80.6799 130.158 80.5428 130.707 80.9817Z" fill="white"/>
                                        <path d="M126.844 87.9768C126.46 87.9768 126.076 87.8396 125.746 87.6202C125.362 87.3184 125.088 86.9069 125.033 86.4132C124.978 85.9194 125.088 85.453 125.39 85.0416L128.49 80.9267C129.093 80.1038 130.245 79.9666 131.068 80.5701C131.864 81.1736 132.028 82.3258 131.425 83.1487L128.325 87.2635C128.023 87.6476 127.612 87.9219 127.118 87.9768C127.008 87.9493 126.926 87.9768 126.844 87.9768ZM129.943 81.2834C129.916 81.2834 129.861 81.2834 129.834 81.2834C129.642 81.3108 129.477 81.4205 129.34 81.5577L126.24 85.6725C126.13 85.8371 126.076 86.0291 126.103 86.2211C126.13 86.4132 126.24 86.5777 126.377 86.7149C126.514 86.8521 126.734 86.8795 126.926 86.8521C127.118 86.8246 127.283 86.7149 127.42 86.5777L130.52 82.4629C130.766 82.1337 130.712 81.6674 130.382 81.4205C130.273 81.3108 130.108 81.2834 129.943 81.2834Z" fill="#FCCBD5"/>
                                        <path d="M125.355 69.1599C126.014 69.4068 126.37 70.1475 126.123 70.8058L124.34 75.6339C124.093 76.2922 123.353 76.6489 122.694 76.402C122.036 76.1551 121.679 75.4144 121.926 74.7561L123.709 69.928C123.956 69.2422 124.697 68.913 125.355 69.1599Z" fill="#77E0B5"/>
                                        <path d="M123.133 77.0334C122.914 77.0334 122.694 77.006 122.502 76.9237C122.036 76.7591 121.679 76.4025 121.46 75.9636C121.268 75.5247 121.24 75.0309 121.405 74.5646L123.188 69.7365C123.353 69.2701 123.709 68.9135 124.148 68.6941C124.587 68.5021 125.081 68.4746 125.547 68.6392C126.014 68.8038 126.37 69.1604 126.59 69.5993C126.782 70.0382 126.809 70.532 126.644 70.9984L124.861 75.8264C124.697 76.2928 124.34 76.6494 123.901 76.8688C123.654 76.9786 123.407 77.0334 123.133 77.0334ZM124.916 69.6268C124.807 69.6268 124.697 69.6542 124.614 69.7091C124.422 69.7913 124.285 69.9285 124.23 70.1205L122.447 74.9486C122.31 75.3326 122.502 75.7441 122.886 75.9087C123.078 75.9636 123.27 75.9636 123.462 75.8813C123.654 75.799 123.792 75.6618 123.846 75.4698L125.63 70.6418C125.767 70.2577 125.575 69.8462 125.191 69.6816C125.081 69.6268 124.999 69.6268 124.916 69.6268Z" fill="#FCCBD5"/>
                                        <path d="M133.147 64.5219C133.504 63.8909 134.272 63.6715 134.903 64.0281L139.374 66.5519C140.005 66.9085 140.225 67.6766 139.868 68.3075C139.512 68.9385 138.744 69.1579 138.113 68.8013L133.641 66.2775C133.01 65.9209 132.791 65.1528 133.147 64.5219Z" fill="white"/>
                                        <path d="M138.772 69.5406C138.47 69.5406 138.169 69.4583 137.867 69.2937L133.395 66.77C132.518 66.2762 132.216 65.1515 132.71 64.2736C133.203 63.3958 134.328 63.0941 135.206 63.5878L139.677 66.1116C140.116 66.3585 140.418 66.7425 140.555 67.2089C140.692 67.6752 140.637 68.169 140.391 68.6079C140.034 69.2114 139.403 69.5406 138.772 69.5406ZM133.642 64.7948C133.45 65.1514 133.56 65.5904 133.917 65.8098L138.388 68.3336C138.745 68.5256 139.184 68.4159 139.403 68.0592C139.513 67.8947 139.513 67.6752 139.485 67.5106C139.43 67.3186 139.321 67.154 139.129 67.0717L134.657 64.548C134.493 64.4382 134.273 64.4382 134.109 64.4656C133.889 64.4931 133.725 64.6302 133.642 64.7948Z" fill="#FCCBD5"/>
                                        <path d="M119.537 93.0529C120.113 92.6414 120.909 92.7512 121.348 93.3272L124.42 97.4695C124.831 98.0456 124.722 98.8411 124.146 99.28C123.57 99.6915 122.774 99.5818 122.335 99.0057L119.263 94.8635C118.851 94.2874 118.961 93.4918 119.537 93.0529Z" fill="#77E0B5"/>
                                        <path d="M123.374 100.076C123.292 100.076 123.182 100.076 123.1 100.049C122.606 99.9666 122.195 99.7197 121.893 99.3356L118.82 95.1934C118.519 94.8094 118.409 94.3156 118.491 93.8218C118.574 93.328 118.82 92.9165 119.205 92.6148C120.027 92.0113 121.18 92.1759 121.783 92.9988L124.856 97.1411C125.157 97.5251 125.267 98.0189 125.185 98.5127C125.102 99.0065 124.856 99.4179 124.471 99.7197C124.142 99.9392 123.786 100.076 123.374 100.076ZM119.863 93.4926C119.698 93.6024 119.589 93.7944 119.561 93.9864C119.534 94.1784 119.589 94.3704 119.698 94.535L122.771 98.6773C122.88 98.8419 123.072 98.9516 123.264 98.979C123.456 99.0065 123.649 98.9516 123.813 98.8419C123.978 98.7322 124.087 98.5401 124.115 98.3481C124.142 98.1561 124.087 97.964 123.978 97.7995L120.905 93.6572C120.658 93.328 120.192 93.2457 119.863 93.4926Z" fill="#FCCBD5"/>
                                        <path d="M79.1612 60.5767C79.8745 60.5493 80.4505 61.1254 80.478 61.8386L80.5877 66.9958C80.6151 67.7091 80.0391 68.2852 79.3258 68.3126C78.6126 68.34 78.0365 67.7639 78.0091 67.0507L77.8994 61.8935C77.8719 61.2077 78.448 60.6042 79.1612 60.5767Z" fill="white"/>
                                        <path d="M79.296 68.8589C78.8297 68.8589 78.3633 68.6668 78.0341 68.3377C77.6775 68.0085 77.4855 67.5421 77.458 67.0484L77.3483 61.8911C77.3209 60.8761 78.1164 60.0257 79.1314 59.9983C79.6252 59.9983 80.0915 60.1629 80.4482 60.4921C80.8048 60.8213 80.9968 61.2876 81.0242 61.7814L81.134 66.9386C81.134 67.4324 80.9694 67.8988 80.6402 68.2554C80.311 68.612 79.8446 68.804 79.3509 68.8314C79.3234 68.8589 79.3234 68.8589 79.296 68.8589ZM79.1589 61.123C78.7474 61.123 78.4182 61.4796 78.4456 61.8911L78.5553 67.0484C78.5553 67.2404 78.6376 67.4324 78.7748 67.5696C78.912 67.7067 79.104 67.789 79.296 67.7616C79.488 67.7616 79.6801 67.6793 79.8172 67.5421C79.9544 67.405 80.0367 67.213 80.0092 67.0209L79.8995 61.8637C79.8995 61.6717 79.8172 61.4796 79.6801 61.3425C79.5429 61.2053 79.3509 61.123 79.1589 61.123Z" fill="#FCCBD5"/>
                                        <path d="M110.294 35.3649C110.678 34.7614 111.501 34.6242 112.077 35.0083L116.356 37.8612C116.96 38.2453 117.097 39.0682 116.713 39.6443C116.329 40.2478 115.506 40.385 114.93 40.0009L110.65 37.148C110.074 36.7639 109.91 35.941 110.294 35.3649Z" fill="#77E0B5"/>
                                        <path d="M115.667 40.7688C115.311 40.7688 114.954 40.6591 114.652 40.467L110.373 37.6141C109.961 37.3398 109.687 36.9283 109.577 36.4345C109.467 35.9408 109.577 35.4744 109.852 35.0629C110.126 34.6514 110.537 34.3771 111.031 34.2674C111.525 34.1577 111.991 34.2674 112.403 34.5417L116.682 37.3947C117.532 37.9433 117.752 39.0954 117.203 39.9458C116.929 40.3573 116.518 40.6316 116.024 40.7414C115.914 40.7414 115.777 40.7688 115.667 40.7688ZM111.388 35.3372C111.141 35.3372 110.921 35.447 110.784 35.6664C110.674 35.831 110.647 36.023 110.674 36.2151C110.702 36.4071 110.839 36.5717 111.004 36.6814L115.283 39.5343C115.448 39.6441 115.64 39.6715 115.832 39.6441C116.024 39.6166 116.188 39.4795 116.298 39.3149C116.518 38.9857 116.435 38.5194 116.079 38.2999L111.799 35.447C111.662 35.3647 111.525 35.3372 111.388 35.3372Z" fill="#FCCBD5"/>
                                        <path d="M134.986 45.1859C135.617 45.515 135.836 46.3106 135.507 46.9415L133.066 51.4678C132.736 52.0987 131.941 52.3182 131.31 51.989C130.679 51.6598 130.46 50.8643 130.789 50.2334L133.23 45.7071C133.587 45.1036 134.355 44.8567 134.986 45.1859Z" fill="#77E0B5"/>
                                        <path d="M131.909 52.7026C131.607 52.7026 131.305 52.6203 131.031 52.4831C130.153 51.9893 129.796 50.892 130.29 49.9868L132.732 45.4605C133.225 44.5827 134.323 44.2261 135.228 44.7198C136.106 45.2136 136.462 46.3109 135.969 47.2161L133.527 51.7424C133.308 52.1814 132.896 52.4831 132.43 52.6203C132.265 52.6752 132.101 52.7026 131.909 52.7026ZM134.378 45.5976C134.295 45.5976 134.24 45.5977 134.158 45.6251C133.966 45.68 133.802 45.8171 133.719 45.9817L131.278 50.508C131.086 50.8646 131.223 51.3035 131.58 51.523C131.744 51.6053 131.964 51.6327 132.156 51.5779C132.348 51.523 132.512 51.3858 132.595 51.2212L135.036 46.6949C135.228 46.3383 135.091 45.8994 134.734 45.68C134.597 45.6251 134.487 45.5976 134.378 45.5976Z" fill="#FCCBD5"/>
                                        <path d="M147.518 21.1565L152.264 23.5156L150.892 27.0818L146.723 22.9396L147.518 21.1565Z" fill="#FCCBD5"/>
                                        <path d="M162.936 31.9333L164.939 33.305L163.924 35.088L160.961 34.1005L162.936 31.9333Z" fill="#FCCBD5"/>
                                        <path d="M165.758 52.4559V55.6381L168.913 54.047L165.758 52.4559Z" fill="#FCCBD5"/>
                                        <path d="M170.701 38.7917C170.701 38.7917 174.788 39.7793 173.883 40.5748C171.332 42.7694 169.905 41.7544 170.701 38.7917Z" fill="#FCCBD5"/>
                                        <path d="M184.224 37.9463L181.485 37.3377L180.876 34.5984C180.842 34.497 180.775 34.4293 180.673 34.4293C180.572 34.4293 180.504 34.497 180.47 34.5984L179.861 37.3377L177.122 37.9802C177.021 38.014 176.953 38.0817 176.953 38.1831C176.953 38.2846 177.021 38.3521 177.122 38.3859L179.861 38.9947L180.47 41.734C180.504 41.8354 180.572 41.9031 180.673 41.9031C180.775 41.9031 180.842 41.8354 180.876 41.734L181.485 38.9947L184.224 38.3522C184.325 38.3184 184.393 38.2507 184.393 38.1493C184.393 38.0478 184.292 37.9801 184.224 37.9463Z" fill="#000929"/>
                                        <path d="M31.2718 49.8159L35.0594 49.0043L35.9049 45.2505C35.9387 45.1152 36.0401 45.0137 36.1754 45.0137C36.3106 45.0137 36.446 45.1152 36.446 45.2505L37.2914 49.0379L41.0789 49.9172C41.2142 49.9511 41.3157 50.0525 41.3157 50.2216C41.3157 50.3568 41.2142 50.4922 41.0789 50.4922L37.2914 51.3038L36.446 55.0576C36.4122 55.1929 36.3106 55.2942 36.1754 55.2942C36.0401 55.2942 35.9049 55.1929 35.9049 55.0576L35.0594 51.2699L31.2718 50.3907C31.1365 50.3568 31.0352 50.2554 31.0352 50.0863C31.0352 49.9849 31.1365 49.8497 31.2718 49.8159Z" fill="#000929"/>
                                        <path d="M47.0962 18.0559L49.0575 17.6162L49.4973 15.6548C49.4973 15.5872 49.5649 15.5533 49.6325 15.5533C49.7001 15.5533 49.7677 15.5872 49.7677 15.6548L50.2073 17.6162L52.1688 18.0896C52.2365 18.0896 52.2702 18.1574 52.2702 18.225C52.2702 18.2926 52.2364 18.3602 52.135 18.3602L50.1736 18.7998L49.7339 20.7613C49.7339 20.829 49.6663 20.8627 49.5987 20.8627C49.531 20.8627 49.4634 20.829 49.4634 20.7613L49.0237 18.7998L47.0623 18.3264C46.9947 18.3264 46.9609 18.2588 46.9609 18.1911C46.9609 18.1235 47.0285 18.0559 47.0962 18.0559Z" fill="#000929"/>
                                        <path d="M12.7734 109.234L26.943 234.089H198.467L212.67 109.234H12.7734Z" fill="#F9C200"/>
                                        <path d="M199.378 235.105H26.0626L25.9612 234.192L11.6562 108.187H213.785L213.65 109.303L199.378 235.105ZM27.8551 233.076H197.552L211.519 110.25H13.8883L27.8551 233.076Z" fill="#000929"/>
                                        <path d="M13.1033 95.4042H212.628C219.087 95.4042 224.329 100.646 224.329 107.105C224.329 113.564 219.087 118.806 212.628 118.806H13.1033C6.64412 118.806 1.40234 113.564 1.40234 107.105C1.40234 100.612 6.64412 95.4042 13.1033 95.4042Z" fill="#000929"/>
                                        <path d="M212.658 119.821H13.1335C6.1332 119.821 0.417969 114.106 0.417969 107.106C0.417969 100.106 6.1332 94.3904 13.1335 94.3904H212.658C219.658 94.3904 225.373 100.106 225.373 107.106C225.373 114.106 219.658 119.821 212.658 119.821ZM13.0996 96.3856C7.21533 96.3856 2.41318 101.188 2.41318 107.072C2.41318 112.956 7.21533 117.758 13.0996 117.758H212.624C218.508 117.758 223.311 112.956 223.311 107.072C223.311 101.188 218.508 96.3856 212.624 96.3856H13.0996Z" fill="#000929"/>
                                        <path d="M94.6029 37.5715L54.0216 104.903C52.8042 106.898 53.4467 109.502 55.4757 110.719L63.2538 115.42C65.2491 116.637 67.8531 115.995 69.0705 113.966L109.652 46.6347C110.869 44.6395 110.227 42.0355 108.198 40.818L100.419 36.1174C98.4242 34.9338 95.8204 35.5762 94.6029 37.5715Z" fill="#FE724C"/>
                                        <path d="M65.4532 117.043C64.5063 117.043 63.5933 116.772 62.7478 116.299L54.9697 111.598C53.7523 110.888 52.9068 109.738 52.5687 108.351C52.2305 106.999 52.4335 105.578 53.1775 104.395L93.7587 37.0636C94.4689 35.8462 95.6187 35.0007 97.0053 34.6625C98.358 34.3243 99.7782 34.5274 100.962 35.2713L108.74 39.972C109.957 40.6821 110.803 41.832 111.141 43.2185C111.479 44.5712 111.276 45.9915 110.532 47.1751L69.9511 114.506C69.2409 115.724 68.0911 116.569 66.7046 116.907C66.2987 117.009 65.859 117.043 65.4532 117.043ZM98.2226 36.5564C97.952 36.5564 97.7154 36.5903 97.4448 36.6579C96.5994 36.8608 95.8892 37.4018 95.4496 38.112L54.8684 105.443C54.4287 106.187 54.2934 107.032 54.4963 107.878C54.6992 108.723 55.2403 109.434 55.9504 109.873L63.7285 114.574C65.2503 115.487 67.2456 115.013 68.1587 113.492L108.74 46.1606C109.18 45.4166 109.315 44.5712 109.112 43.7258C108.909 42.8803 108.368 42.1702 107.658 41.7306L99.8798 37.0298C99.3725 36.6916 98.8313 36.5564 98.2226 36.5564Z" fill="#000929"/>
                                        <path d="M129.039 37.5719L169.621 104.903C170.838 106.898 170.195 109.502 168.166 110.72L160.388 115.42C158.393 116.638 155.789 115.995 154.572 113.966L113.99 46.6351C112.773 44.6399 113.416 42.0358 115.445 40.8184L123.223 36.1178C125.218 34.9341 127.822 35.5766 129.039 37.5719Z" fill="#FE724C"/>
                                        <path d="M158.187 117.043C156.395 117.043 154.67 116.13 153.689 114.507L113.108 47.1755C112.398 45.9581 112.161 44.5717 112.5 43.219C112.838 41.8662 113.683 40.7164 114.901 39.9724L122.679 35.2718C123.896 34.5616 125.283 34.3248 126.635 34.663C127.988 35.0011 129.138 35.8466 129.882 37.0641L170.463 104.395C171.173 105.613 171.41 106.999 171.072 108.352C170.734 109.705 169.888 110.854 168.671 111.598L160.893 116.299C160.047 116.806 159.134 117.043 158.187 117.043ZM125.384 36.5568C124.809 36.5568 124.234 36.7259 123.727 37.0302L115.949 41.731C115.205 42.1706 114.698 42.8808 114.495 43.7262C114.292 44.5717 114.427 45.417 114.867 46.161L155.448 113.492C156.361 115.014 158.356 115.521 159.878 114.574L167.656 109.874C168.4 109.434 168.907 108.724 169.11 107.878C169.313 107.033 169.178 106.188 168.738 105.444L128.157 38.1124C127.717 37.3685 127.007 36.8613 126.162 36.6583C125.925 36.5907 125.655 36.5568 125.384 36.5568Z" fill="#000929"/>
                                        <path d="M64.3786 109.743C67.2175 109.743 69.5188 107.442 69.5188 104.603C69.5188 101.764 67.2175 99.4628 64.3786 99.4628C61.5397 99.4628 59.2383 101.764 59.2383 104.603C59.2383 107.442 61.5397 109.743 64.3786 109.743Z" fill="white"/>
                                        <path d="M64.3775 110.757C60.9958 110.757 58.2227 107.984 58.2227 104.602C58.2227 101.22 60.9958 98.4473 64.3775 98.4473C67.7593 98.4473 70.5323 101.22 70.5323 104.602C70.5323 108.018 67.7593 110.757 64.3775 110.757ZM64.3775 100.476C62.1118 100.476 60.2517 102.336 60.2517 104.602C60.2517 106.868 62.1118 108.728 64.3775 108.728C66.6433 108.728 68.5032 106.868 68.5032 104.602C68.5032 102.336 66.6433 100.476 64.3775 100.476Z" fill="#000929"/>
                                        <path d="M158.722 109.402C161.561 109.402 163.863 107.101 163.863 104.262C163.863 101.423 161.561 99.1213 158.722 99.1213C155.883 99.1213 153.582 101.423 153.582 104.262C153.582 107.101 155.883 109.402 158.722 109.402Z" fill="white"/>
                                        <path d="M158.717 110.413C155.336 110.413 152.562 107.64 152.562 104.258C152.562 100.876 155.336 98.103 158.717 98.103C162.099 98.103 164.872 100.876 164.872 104.258C164.872 107.64 162.133 110.413 158.717 110.413ZM158.717 100.132C156.452 100.132 154.592 101.992 154.592 104.258C154.592 106.524 156.452 108.384 158.717 108.384C160.983 108.384 162.843 106.524 162.843 104.258C162.843 101.992 161.017 100.132 158.717 100.132Z" fill="#000929"/>
                                        <path d="M53.5535 130.672H41.4805V171.456H53.5535V130.672Z" fill="white"/>
                                        <path d="M54.5708 172.502H40.4688V129.689H54.5708V172.502ZM42.4978 170.473H52.5417V131.718H42.4978V170.473Z" fill="#000929"/>
                                        <path d="M86.897 130.672H74.8242V171.456H86.897V130.672Z" fill="white"/>
                                        <path d="M87.9105 172.502H73.8086V129.689H87.9105V172.502ZM75.8377 170.473H85.8814V131.718H75.8377V170.473Z" fill="#000929"/>
                                        <path d="M120.241 130.672H108.168V171.456H120.241V130.672Z" fill="white"/>
                                        <path d="M121.254 172.502H107.152V129.689H121.254V172.502ZM109.181 170.473H119.225V131.718H109.181V170.473Z" fill="#000929"/>
                                        <path d="M153.241 130.672H141.168V171.456H153.241V130.672Z" fill="white"/>
                                        <path d="M154.258 172.502H140.156V129.689H154.258V172.502ZM142.185 170.473H152.229V131.718H142.185V170.473Z" fill="#000929"/>
                                        <path d="M186.596 130.672H174.523V171.456H186.596V130.672Z" fill="white"/>
                                        <path d="M187.61 172.502H173.508V129.689H187.61V172.502ZM175.537 170.473H185.581V131.718H175.537V170.473Z" fill="#000929"/>
                                        <path d="M53.5535 180.689H41.4805V221.473H53.5535V180.689Z" fill="white"/>
                                        <path d="M54.5708 222.523H40.4688V179.71H54.5708V222.523ZM42.4978 220.494H52.5417V181.739H42.4978V220.494Z" fill="#000929"/>
                                        <path d="M86.897 180.689H74.8242V221.473H86.897V180.689Z" fill="white"/>
                                        <path d="M87.9105 222.523H73.8086V179.71H87.9105V222.523ZM75.8377 220.494H85.8814V181.739H75.8377V220.494Z" fill="#000929"/>
                                        <path d="M120.241 180.689H108.168V221.473H120.241V180.689Z" fill="white"/>
                                        <path d="M121.254 222.523H107.152V179.71H121.254V222.523ZM109.181 220.494H119.225V181.739H109.181V220.494Z" fill="#000929"/>
                                        <path d="M153.241 180.689H141.168V221.473H153.241V180.689Z" fill="white"/>
                                        <path d="M154.258 222.523H140.156V179.71H154.258V222.523ZM142.185 220.494H152.229V181.739H142.185V220.494Z" fill="#000929"/>
                                        <path d="M186.596 180.689H174.523V221.473H186.596V180.689Z" fill="white"/>
                                        <path d="M187.61 222.523H173.508V179.71H187.61V222.523ZM175.537 220.494H185.581V181.739H175.537V220.494Z" fill="#000929"/>
                                        <defs>
                                        <linearGradient id="paint0_linear_1461_12761" x1="149.348" y1="25.8185" x2="42.8355" y2="108.118" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#F9963B"/>
                                        <stop offset="0.0001" stop-color="#F9963B"/>
                                        <stop offset="1" stop-color="#F95D3B"/>
                                        </linearGradient>
                                        </defs>
                                        </svg>
                                </div>
                                <h3 class="text-center font-">{{__('translate.Sorry!! Your cart is empty')}}</h3>
                                <a href="{{ route('home') }}" class="cart-btn">{{ __('translate.Back to Home') }}</a>
                            </div>

                            @if(session('cart') && count(session('cart')) > 0)
                                <table class="table table-striped" id="cart_table">

                                    <thead>
                                    <tr>
                                        <th>
                                            <div class="th_item">
                                                {{__('translate.Food Image')}}
                                                <div class="arrow_main">
                                                    <span class="arrow_top">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M1 4L4 1M4 1L7 4M4 1L4 13" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round"/>
                                                        </svg>
                                                    </span>
                                                    <span class="arrow_top arrow_bottom ">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M7 10L4 13M4 13L1 10M4 13L4 1" stroke="#394150"
                                                                stroke-width="1.5" stroke-linecap="round"
                                                                stroke-linejoin="round"/>
                                                        </svg>

                                                    </span>
                                                </div>
                                            </div>
                                        </th>
                                        <th>
                                            <div class="th_item">
                                                {{__('translate.Details')}}
                                                <div class="arrow_main">
                                                    <span class="arrow_top">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M1 4L4 1M4 1L7 4M4 1L4 13" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round"/>
                                                        </svg>
                                                    </span>
                                                    <span class="arrow_top arrow_bottom ">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M7 10L4 13M4 13L1 10M4 13L4 1" stroke="#394150"
                                                                stroke-width="1.5" stroke-linecap="round"
                                                                stroke-linejoin="round"/>
                                                        </svg>

                                                    </span>
                                                </div>
                                            </div>
                                        </th>
                                        <th>
                                            <div class="th_item">
                                                {{__('translate.Price')}}
                                                <div class="arrow_main">
                                                    <span class="arrow_top">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M1 4L4 1M4 1L7 4M4 1L4 13" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round"/>
                                                        </svg>
                                                    </span>
                                                    <span class="arrow_top arrow_bottom ">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M7 10L4 13M4 13L1 10M4 13L4 1" stroke="#394150"
                                                                stroke-width="1.5" stroke-linecap="round"
                                                                stroke-linejoin="round"/>
                                                        </svg>

                                                    </span>
                                                </div>
                                            </div>
                                        </th>
                                        <th>
                                            <div class="th_item">
                                                {{__('translate.Quantity')}}
                                                <div class="arrow_main">
                                                    <span class="arrow_top">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M1 4L4 1M4 1L7 4M4 1L4 13" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round"/>
                                                        </svg>
                                                    </span>
                                                    <span class="arrow_top arrow_bottom ">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M7 10L4 13M4 13L1 10M4 13L4 1" stroke="#394150"
                                                                stroke-width="1.5" stroke-linecap="round"
                                                                stroke-linejoin="round"/>
                                                        </svg>

                                                    </span>
                                                </div>
                                            </div>
                                        </th>
                                        <th>
                                            <div class="th_item">
                                                {{__('translate.Subtotal')}}
                                                <div class="arrow_main">
                                                    <span class="arrow_top">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M1 4L4 1M4 1L7 4M4 1L4 13" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round"/>
                                                        </svg>
                                                    </span>
                                                    <span class="arrow_top arrow_bottom ">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M7 10L4 13M4 13L1 10M4 13L4 1" stroke="#394150"
                                                                stroke-width="1.5" stroke-linecap="round"
                                                                stroke-linejoin="round"/>
                                                        </svg>

                                                    </span>
                                                </div>
                                            </div>
                                        </th>
                                        <th>
                                            <div class="th_item">
                                                {{__('translate.Action')}}
                                                <div class="arrow_main">
                                                    <span class="arrow_top">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M1 4L4 1M4 1L7 4M4 1L4 13" stroke-width="1.5"
                                                                stroke-linecap="round" stroke-linejoin="round"/>
                                                        </svg>
                                                    </span>
                                                    <span class="arrow_top arrow_bottom ">
                                                        <svg width="8" height="14" viewBox="0 0 8 14" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <path d="M7 10L4 13M4 13L1 10M4 13L4 1" stroke="#394150"
                                                                stroke-width="1.5" stroke-linecap="round"
                                                                stroke-linejoin="round"/>
                                                        </svg>

                                                    </span>
                                                </div>
                                            </div>
                                        </th>
                                    </tr>
                                    </thead>

                                    <tbody>
                                        @foreach ($carts as $cart_key => $item)
                                            @php
                                                $product = Modules\Product\App\Models\Product::where('status', 'enable')->whereIn('id', [$item['product_id']])->first();
                                                $total = 0;
                                                $calculate = 0;
                                                $total = ($product['price'] * $item['qty']);
                                            @endphp
                                            <tr id="cart_item_td_{{ $product->id }}">
                                                <td>
                                                    <div class="td_thumb">
                                                        <img src="{{asset($product->image)}}" alt="thumb">
                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="td_txt">
                                                        <h6>
                                                            <a href="javascript:;">{{$product->name}}</a>
                                                        </h6>

                                                        @if($item['size'])
                                                            <span>{{ __('translate.Size') }}:</span>
                                                        @endif
                                                        @foreach ($item['size'] as $size => $price)
                                                            {{ $size }} (<strong>{{currency( $price) }}</strong>)
                                                            @php $total = $total + ($price * $item['qty']) @endphp
                                                        @endforeach

                                                        @if (is_array($item['addons']))
                                                            <p>
                                                                @if($item['addons'])
                                                                    <span>{{ __('translate.Addon') }}:</span>
                                                                @endif
                                                                @foreach ($item['addons'] as $addonId => $quantity)
                                                                    @php
                                                                        $addonsDb = Modules\Addon\App\Models\Addon::whereIn('id', [$addonId])->get();
                                                                        $calculate += ($addonsDb->first()->price * $quantity);
                                                                    @endphp
                                                                    @if ($addonsDb->isNotEmpty())
                                                                        {{ $addonsDb->first()->name }} <span>({{ currency($addonsDb->first()->price) }} * {{ $quantity }})</span>
                                                                    @endif

                                                                @endforeach

                                                            </p>
                                                        @endif

                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="td_price">
                                                        <p>
                                                            {{currency($item['price'])}}
                                                        </p>

                                                    </div>
                                                </td>
                                                <td>
                                                    <div class="td_quantity">
                                                        <a href="javascript:;" onClick="decrementQty('{{ $product['id'] ?? 0 }}', '{{ $item['price'] ?? 0 }}', '{{ $item['addon_price'] ?? 0 }}')" class="decrement">
                                                            <span>
                                                                <svg width="14" height="2" viewBox="0 0 14 2" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M13.75 1C13.75 1.41421 13.4142 1.75 13 1.75L1 1.75C0.585786 1.75 0.25 1.41421 0.25 1C0.25 0.585786 0.585786 0.25 1 0.25L13 0.25C13.4142 0.25 13.75 0.585786 13.75 1Z"/>
                                                                </svg>
                                                            </span>
                                                        </a>

                                                        <input type="text" value="{{$item['qty']}}" class="quantity_input" readonly id="cart_item_qty_{{ $product['id'] ?? 0 }}">

                                                        <a href="javascript:;" onClick="incrementQty('{{ $product['id'] ?? 0 }}', '{{ $item['price'] ?? 0 }}', '{{ $item['addon_price'] ?? 0 }}')" class="incriment">
                                                            <span>
                                                                <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M7.75 1C7.75 0.585786 7.41421 0.25 7 0.25C6.58579 0.25 6.25 0.585786 6.25 1V6.25H1C0.585786 6.25 0.25 6.58579 0.25 7C0.25 7.41421 0.585786 7.75 1 7.75H6.25V13C6.25 13.4142 6.58579 13.75 7 13.75C7.41421 13.75 7.75 13.4142 7.75 13V7.75H13C13.4142 7.75 13.75 7.41421 13.75 7C13.75 6.58579 13.4142 6.25 13 6.25H7.75V1Z"/>
                                                                </svg>

                                                            </span>
                                                        </a>

                                                    </div>
                                                </td>

                                                <td>
                                                    <div class="td_subtotal">
                                                        <p id="car_item_subtotal_{{ $product['id'] ?? 0 }}">{{currency($item['total'])}}</p>
                                                    </div>
                                                </td>

                                                <td>
                                                    <div class="td_btn">
                                                        <a href="javascript:;" class="view_btn" data-bs-toggle="modal"
                                                        data-bs-target="#featuredModal-{{$cart_key}}">
                                                            <span>
                                                                <svg width="20" height="14" viewBox="0 0 20 14" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M19.1303 9.1469C20.2899 7.92683 20.2899 6.07317 19.1303 4.8531C17.1745 2.79533 13.8155 0 10 0C6.18448 0 2.82549 2.79533 0.869705 4.8531C-0.289902 6.07317 -0.289902 7.92683 0.869706 9.1469C2.82549 11.2047 6.18448 14 10 14C13.8155 14 17.1745 11.2047 19.1303 9.1469ZM10 10C11.6569 10 13 8.65685 13 7C13 5.34315 11.6569 4 10 4C8.34315 4 7 5.34315 7 7C7 8.65685 8.34315 10 10 10Z"
                                                                        fill="white"/>
                                                                </svg>

                                                            </span>
                                                        </a>
                                                        <a href="javascript:;" onClick="cartRemove('{{ $product['id'] ?? 0 }}')" class="view_btn delet_btn">
                                                            <span>
                                                                <svg width="16" height="20" viewBox="0 0 16 20" fill="none"
                                                                    xmlns="http://www.w3.org/2000/svg">
                                                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                                                        d="M5.40627 0.890599C5.7772 0.334202 6.40166 0 7.07037 0H8.92963C9.59834 0 10.2228 0.334202 10.5937 0.8906L11.5 2.25H15.25C15.6642 2.25 16 2.58579 16 3C16 3.41421 15.6642 3.75 15.25 3.75H0.75C0.335786 3.75 0 3.41421 0 3C0 2.58579 0.335786 2.25 0.75 2.25H4.5L5.40627 0.890599ZM11 20H5C2.79086 20 1 18.2091 1 16V5H15V16C15 18.2091 13.2091 20 11 20ZM6 8.25C6.41421 8.25 6.75 8.58579 6.75 9V16C6.75 16.4142 6.41421 16.75 6 16.75C5.58579 16.75 5.25 16.4142 5.25 16L5.25 9C5.25 8.58579 5.58579 8.25 6 8.25ZM10 8.25C10.4142 8.25 10.75 8.58579 10.75 9V16C10.75 16.4142 10.4142 16.75 10 16.75C9.58579 16.75 9.25 16.4142 9.25 16V9C9.25 8.58579 9.58579 8.25 10 8.25Z"/>
                                                                </svg>
                                                            </span>
                                                        </a>
                                                    </div>
                                                </td>
                                            </tr>

                                            <!--food_card_modal-->
                                            <div class="modal food_card_modal fade" id="featuredModal-{{$cart_key}}"
                                                tabindex="-1"
                                                aria-hidden="true">
                                                <div class="modal-dialog">
                                                    <div class="modal-content modal_hight">
                                                        <div class="modal-header">
                                                            <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                                    aria-label="Close"></button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="modal_body_thumb">
                                                                <img src="{{asset($product->image)}}"
                                                                    alt="thumb">
                                                            </div>

                                                            <div class="modal_body_inner">
                                                                <div class="modal_body_top_txt">
                                                                    <div class="modal_body_top_txt_df">
                                                                        <h4>{{$product->translate_product?->name}}</h4>
                                                                        <h5>{{currency($product->offer_price > 0 ? $product->offer_price : $product->price)}}</h5>
                                                                    </div>

                                                                    <p>{{$product->translate_product?->short_description}}</p>
                                                                </div>
                                                                <form action="{{route('update.cart',$product['id'])}}"
                                                                    method="POST" class="h-0 overflow-hidden" >
                                                                    @csrf
                                                                    <div class="food_select_size_box">
                                                                        <div class="food_select_size_box_txt_item">
                                                                            <h5>{{__('translate.Select Size')}} </h5>
                                                                            <p>{{__('translate.Mandatory')}}</p>
                                                                        </div>

                                                                        <div class="form_check_main">
                                                                            @foreach(json_decode($product->size, true) as $size => $price)
                                                                                <div class="form_check_main_item">
                                                                                    <div class="form-check">
                                                                                        @php
                                                                                            $cart_size = null;
                                                                                            foreach ($item['size'] as $sizes => $prices) {
                                                                                                $cart_size = $sizes;
                                                                                            }
                                                                                        @endphp
                                                                                        <input class="form-check-input"
                                                                                            @if($cart_size == $size) checked
                                                                                            @endif type="radio" name="size"
                                                                                            value="{{ $size }},{{ $price }}"
                                                                                            id="size_{{ $product->id }}_{{ $loop->index }}_{{$price}}_{{$size}}"
                                                                                            data-info="{{ $size }},{{ $price }}">
                                                                                        <label class="form-check-label"
                                                                                            for="size_{{ $product->id }}_{{ $loop->index }}_{{$price}}_{{$size}}">
                                                                                            {{ $size }}
                                                                                        </label>
                                                                                    </div>

                                                                                    <h6>
                                                                                        {{currency($price)}}
                                                                                    </h6>
                                                                                </div>
                                                                            @endforeach
                                                                        </div>

                                                                    </div>

                                                                    <input type="hidden" name="product_id"
                                                                        value="{{$product->id}}">
                                                                    <div class="food_select_size_box addon">
                                                                        <div class="food_select_size_box_txt_item">
                                                                            <h5>{{ __('translate.Select Addon') }} </h5>
                                                                            <p>{{ __('translate.Optional') }}</p>
                                                                        </div>

                                                                        <div class="form_check_main">
                                                                            @foreach(json_decode($product->addon_items, true) ?? [] as $id)
                                                                                @php
                                                                                    $addons = Modules\Addon\App\Models\Addon::where('id', $id)->get();
                                                                                @endphp
                                                                                @foreach ($addons as $addon)
                                                                                    <div class="form_check_main_item">
                                                                                        <div class="form-check">
                                                                                            <input class="form-check-input"
                                                                                                @if(isset($item['addons'][$addon->id])) checked
                                                                                                @endif type="checkbox"
                                                                                                name="addons[]"
                                                                                                value="{{ $addon->id }}"
                                                                                                id="addon_{{ $product->id }}{{ $loop->parent->index }}_{{ $loop->index }}">
                                                                                            <label class="form-check-label"
                                                                                                for="addon_{{ $product->id }}{{ $loop->parent->index }}_{{ $loop->index }}">
                                                                                                {{$addon?->translate?->name}}
                                                                                                ({{currency($addon->price)}})
                                                                                            </label>
                                                                                        </div>

                                                                                        <div class="inc_dic_btn">
                                                                                            <button type="button"
                                                                                                    class="decrement btn-minus"
                                                                                                    data-addon-index="{{ $product->id }}{{ $loop->parent->index }}_{{ $loop->index }}">
                                                                                                <span>
                                                                                                    <svg width="10" height="2"
                                                                                                        viewBox="0 0 10 2"
                                                                                                        fill="none"
                                                                                                        xmlns="http://www.w3.org/2000/svg">
                                                                                                        <path
                                                                                                                d="M0.335938 0.333496H9.66927V1.66683H0.335938V0.333496Z"/>
                                                                                                    </svg>

                                                                                                </span>
                                                                                            </button>
                                                                                            <input type="text"
                                                                                                class="inc_dic_input product-qty quantityUpdate_{{ $product->id }}{{ $loop->parent->index }}_{{ $loop->index }}"
                                                                                                value=" @if(isset($item['addons'][$addon->id])){{ $item['addons'][$addon->id] }}@else 0 @endif" readonly>

                                                                                            <button type="button"
                                                                                                    class="decrement incriment btn-plus"
                                                                                                    data-addon-index="{{ $product->id }}{{ $loop->parent->index }}_{{ $loop->index }}">
                                                                                                <span>
                                                                                                    <svg width="10" height="10"
                                                                                                        viewBox="0 0 10 10"
                                                                                                        fill="none"
                                                                                                        xmlns="http://www.w3.org/2000/svg">
                                                                                                        <path
                                                                                                                d="M9.66927 4.3335H5.66927V0.333496H4.33594V4.3335H0.335938V5.66683H4.33594V9.66683H5.66927V5.66683H9.66927V4.3335Z"/>
                                                                                                    </svg>
                                                                                                </span>
                                                                                            </button>
                                                                                            <input type="hidden"
                                                                                                name="addons_qty[{{ $addon->id }}]"
                                                                                                id="qtyInput_{{ $product->id }}{{ $loop->parent->index }}_{{ $loop->index }}"
                                                                                                value="@if(isset($item['addons'][$addon->id])){{ $item['addons'][$addon->id] }}@else 0 @endif">
                                                                                        </div>
                                                                                    </div>
                                                                                @endforeach
                                                                            @endforeach
                                                                        </div>
                                                                    </div>


                                                                    <div class="food_modal_quantity">

                                                                        <div class="food_modal_quantity_main">
                                                                            <input type="hidden" class="quantity_input"
                                                                                name="qty" value="{{$item['qty']}}">

                                                                            <button type="submit" class="thm-btn">

                                                                <span>
                                                                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none"
                                                                        xmlns="http://www.w3.org/2000/svg">
                                                                        <g clip-path="url(#clip0_381_37439)">
                                                                            <path
                                                                                    d="M5.0013 3.33333H15.0013C16.8423 3.33333 18.3346 4.82571 18.3346 6.66666V10.8333C18.3346 12.6743 16.8423 14.1667 15.0013 14.1667H8.33464C6.49369 14.1667 5.0013 12.6743 5.0013 10.8333V3.33333ZM5.0013 3.33333C5.0013 2.41286 4.25511 1.66666 3.33464 1.66666H1.66797"
                                                                                    stroke="#0C1321" stroke-width="1.5"
                                                                                    stroke-linecap="round"
                                                                                    stroke-linejoin="round"/>
                                                                            <path
                                                                                    d="M9.16797 17.0833C9.16797 17.7737 8.60832 18.3333 7.91797 18.3333C7.22761 18.3333 6.66797 17.7737 6.66797 17.0833C6.66797 16.393 7.22761 15.8333 7.91797 15.8333C8.60832 15.8333 9.16797 16.393 9.16797 17.0833Z"
                                                                                    stroke="#0C1321" stroke-width="1.5"/>
                                                                            <path
                                                                                    d="M16.668 17.0833C16.668 17.7737 16.1083 18.3333 15.418 18.3333C14.7276 18.3333 14.168 17.7737 14.168 17.0833C14.168 16.393 14.7276 15.8333 15.418 15.8333C16.1083 15.8333 16.668 16.393 16.668 17.0833Z"
                                                                                    stroke="#0C1321" stroke-width="1.5"/>
                                                                            <path d="M11.668 6.66666L11.668 10.8333"
                                                                                stroke="#0C1321"
                                                                                stroke-width="1.5" stroke-linecap="round"
                                                                                stroke-linejoin="round"/>
                                                                            <path d="M13.7487 8.75L9.58203 8.75"
                                                                                stroke="#0C1321" stroke-width="1.5"
                                                                                stroke-linecap="round"
                                                                                stroke-linejoin="round"/>
                                                                        </g>
                                                                    </svg>
                                                                </span>
                                                                                {{__('translate.Update Cart')}}
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        @endforeach
                                    </tbody>
                                </table>

                            @endif

                        </div>

                        @if(session('cart') && count(session('cart')) > 0)
                            <div class="table_btn " id="checkout_btn">
                                <a href="{{route('view.checkout')}}" class="thm-btn">{{__('translate.Proceed to checkout')}}</a>
                            </div>
                        @endif


                    </div>
                </div>
            </div>
        </section>
        <!-- add to cart part end -->

        <!-- mobile app  part start -->
        @include('frontend.layouts.partials.mobile_app')
        <!-- mobile app  part end -->


    </main>
@endsection

@push('js_section')

    <script>
        "use strict"


        $(document).ready(function () {


            $(".btn-minus, .btn-plus").on("click", function (e) {
                e.preventDefault();

                var $modal = $(this).closest('.modal');
                var addonIndex = $(this).data("addon-index");

                var $quantityInput = $modal.find(".quantityUpdate_" + addonIndex);
                var $hiddenInput = $modal.find("#qtyInput_" + addonIndex);
                var $checkbox = $modal.find("#addon_" + addonIndex);

                var currentQuantity = parseInt($quantityInput.val()) || 0;

                if ($(this).hasClass("btn-minus")) {
                    currentQuantity = Math.max(currentQuantity - 1, 0);
                } else if ($(this).hasClass("btn-plus")) {
                    currentQuantity++;
                }

                // Update the quantity fields
                $quantityInput.val(currentQuantity);
                $hiddenInput.val(currentQuantity);

                // Automatically check/uncheck the checkbox based on quantity
                if (currentQuantity > 0) {
                    $checkbox.prop('checked', true);
                } else {
                    $checkbox.prop('checked', false);
                }
            });

            // Checkbox change listener
            $('.form-check-input').on('change', function () {
                let index = $(this).attr('id').replace('addon_', '');
                let $modal = $(this).closest('.modal');

                let qtyInput = $modal.find('#qtyInput_' + index);
                let displayInput = $modal.find('.quantityUpdate_' + index);

                if ($(this).is(':checked')) {
                    qtyInput.val(1);
                    displayInput.val(1);
                } else {
                    qtyInput.val(0);
                    displayInput.val(0);
                }
            });



            $(".quantity_inc_dec_btn").on("click", "button.dec, button.inc", function (e) {
                    e.preventDefault();

                    var container = $(this).closest(".quantity_inc_dec_btn");
                    var quantityInput = container.find(".quantity_input");
                    var currentQuantity = parseInt(quantityInput.val());


                    if ($(this).hasClass("dec")) {

                        currentQuantity = Math.max(currentQuantity - 1, 1);
                    } else if ($(this).hasClass("inc")) {
                        currentQuantity++;
                    }

                    quantityInput.val(currentQuantity);
            });


        });

        function incrementQty(productId, product_price, addon_price){

            let current_qty = $("#cart_item_qty_"+productId).val();

            $.ajax({
                type : "get",
                url: "{{ url('cart/increment') }}" + "/" + productId,
                success : function(response){
                    toastr.success(response.message);

                    current_qty = parseInt(current_qty) + parseInt(1);
                    $("#cart_item_qty_"+productId).val(current_qty);
                    $("#sidebar_mini_cart_body").html(response.mini_cart);

                    let sub_total = parseFloat(product_price) * parseInt(current_qty);
                    sub_total = parseFloat(sub_total) + parseFloat(addon_price);

                    $("#car_item_subtotal_"+productId).html(currency(sub_total))

                },
                error : function(err){
                    toastr.error(`{{ __('translate.Something Went Wrong') }}`);
                }
            })


        }


        function decrementQty(productId, product_price, addon_price) {
            let current_qty = parseInt($("#cart_item_qty_" + productId).val());

            if (current_qty <= 1) {
                return;
            }

            $.ajax({
                type: "get",
                url: "{{ url('cart/decrement') }}/" + productId,
                success: function(response) {
                    toastr.success(response.message);

                    current_qty -= 1;
                    $("#cart_item_qty_" + productId).val(current_qty);
                    $("#sidebar_mini_cart_body").html(response.mini_cart);

                    let sub_total = parseFloat(product_price) * current_qty;
                    sub_total = sub_total + parseFloat(addon_price);

                    $("#car_item_subtotal_" + productId).html(currency(sub_total));
                },
                error: function(err) {
                    toastr.error(`{{ __('translate.Something Went Wrong') }}`);
                }
            });
        }






        function currency(price) {
            const icon = @json(session('currency_icon'));
            const rate = parseFloat(@json(session('currency_rate', 1)));
            const position = @json(session('currency_position'));

            let converted = parseFloat(price) * rate;

            converted = converted.toLocaleString(undefined, {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });

            switch (position) {
                case 'before_price':
                    return icon + converted;
                case 'before_price_with_space':
                    return icon + ' ' + converted;
                case 'after_price':
                    return converted + icon;
                case 'after_price_with_space':
                    return converted + ' ' + icon;
                default:
                    return icon + converted;
            }
        }

    </script>

@endpush
