@extends('frontend.layouts.master')

@section('title')
    <title>{{ __('translate.Change Password') }}</title>
@endsection
@section('content')
    <main class="search_V1_bg" >
        <!-- banner-part start  -->

        <div class="profile_bg" style="background-image: url({{ asset($general_setting->breadcrumb_image) }})">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">
                        <ul class="breadcrumb">
                            <li><a href="{{route('home')}}">{{__('translate.Home')}}</a></li>
                            <li><a href="javascript:;">/</a></li>
                            <li><a href="javascript:;" class="active">{{__('translate.Change Password')}}</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- banner-part end -->


        <!-- dashboard part start  -->


        <section class="dashboard">
            <div class="container">
                <div class="row">
                    <div class=" col-lg-4 col-xxl-3">
                        @include('frontend.layouts.partials.dashboard_partials')
                    </div>

                    <div class="col-lg-8 col-xxl-9 ">
                        <div class="row  change_password ">
                            <div class=" col-xl-6 col-xxl-5">
                                <div class="change_password_txt">
                                    <h4>
                                        {{__('translate. Update your password')}}
                                    </h4>

                                    <p>{{__('translate.To change your password, fill up the form below')}} </p>
                                </div>


                                <form class="change_password_form_main" action="{{ route('user.update-password') }}"
                                      method="POST">
                                    @csrf
                                    @method('PUT')
                                    <div class="change_password_form_item">
                                        <div class="change_password_form_inner">
                                            <label for="inputPassword" class="form-label">
                                                {{__('translate.Current Password')}}*</label>
                                            <input type="password" class="form-control" id="current_password"
                                                   name="current_password">
                                            <span class="placeholder_icon" id="current_password_eye">
                                                <i class="fa-regular fa-eye-slash"></i>
                                            </span>

                                        </div>
                                        <div class="change_password_form_inner">
                                            <label for="inputPassword" class="form-label">{{__('translate.New Password')}}
                                                *</label>
                                            <input type="password" class="form-control" id="new_password"
                                                   name="password">
                                            <span class="placeholder_icon" id="new_password_eye">
                                                <i class="fa-regular fa-eye-slash"></i>
                                            </span>

                                        </div>

                                        <div class="change_password_form_inner">
                                            <label for="inputPassword" class="form-label">{{__('translate.Confirm Password')}}
                                                *</label>
                                            <input type="password" class="form-control" id="confirm_password"
                                                   name="password_confirmation">
                                            <span class="placeholder_icon"  id="confirm_password_eye">
                                                <i class="fa-regular fa-eye-slash"></i>
                                            </span>

                                        </div>
                                    </div>


                                    <div class="change_password_form_btn">
                                        <button type="submit"
                                                class="thm-btn ">{{__('translate.Update Password')}}</button>
                                        <button type="submit" class="thm-btn_two ">{{__('translate.Cancel')}}</button>
                                    </div>


                                </form>


                            </div>

                            <div class=" col-xl-6 col-xxl-7">
                                <div class="change_password_thumb">
                                    <span>
                                        <svg width="320" height="330" viewBox="0 0 320 330" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <g opacity="0.57">
                                                <g opacity="0.62">
                                                    <path
                                                        d="M80.6199 0L80.7349 2.64525C80.7349 2.70718 80.6907 2.76039 80.6199 2.76923C80.558 2.76923 80.5049 2.72489 80.4961 2.65411V2.64525L80.6199 0Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M80.8334 5.28166L80.9219 7.92691C80.9308 8.09501 80.798 8.2278 80.6299 8.23665C80.4618 8.24549 80.3292 8.11272 80.3203 7.94463C80.3203 7.93578 80.3203 7.92691 80.3203 7.92691L80.4088 5.28166C80.4088 5.16665 80.5149 5.06935 80.6299 5.0782C80.7361 5.0782 80.8246 5.16665 80.8334 5.28166Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.0027 10.5633L81.0912 13.2088C81.1 13.4742 80.8965 13.6863 80.6311 13.6952C80.3657 13.704 80.1534 13.5005 80.1445 13.2351C80.1445 13.2263 80.1445 13.2176 80.1445 13.1999L80.233 10.5547C80.2418 10.3423 80.4188 10.1741 80.6311 10.183C80.8346 10.1918 81.0027 10.3598 81.0027 10.5633Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.1619 15.8451L81.2238 18.4904C81.2326 18.8266 80.9672 19.1008 80.631 19.1096C80.2948 19.1185 80.0206 18.8531 80.0117 18.5169C80.0117 18.5081 80.0117 18.4992 80.0117 18.4904L80.0737 15.8451C80.0825 15.5443 80.3302 15.3054 80.631 15.3142C80.923 15.323 81.153 15.562 81.1619 15.8451Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.2864 21.127L81.3307 23.7723C81.3395 24.1704 81.021 24.4976 80.6317 24.4976C80.2336 24.5064 79.9062 24.1881 79.9062 23.7989C79.9062 23.79 79.9062 23.7811 79.9062 23.7723L79.9505 21.127C79.9593 20.7555 80.2601 20.4635 80.6317 20.4724C80.9944 20.4812 81.2775 20.7732 81.2864 21.127Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.3834 26.4083L81.4276 29.0536C81.4365 29.4959 81.0826 29.8675 80.6314 29.8763C80.189 29.8851 79.8174 29.5314 79.8086 29.0802C79.8086 29.0713 79.8086 29.0624 79.8086 29.0536L79.8528 26.4083C79.8617 25.9837 80.2067 25.6562 80.6314 25.6562C81.0472 25.6651 81.3745 26.0014 81.3834 26.4083Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.4596 31.69L81.4861 34.3353C81.495 34.8219 81.1057 35.2111 80.6191 35.22C80.1325 35.2288 79.7432 34.8396 79.7344 34.353C79.7344 34.3442 79.7344 34.3353 79.7344 34.3353L79.7609 31.69C79.7698 31.2211 80.1502 30.8496 80.6191 30.8496C81.088 30.8585 81.4596 31.23 81.4596 31.69Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.5227 36.9717L81.5493 39.6169C81.5582 40.1301 81.1423 40.5459 80.6292 40.5548C80.1161 40.5636 79.7003 40.1478 79.6914 39.6346C79.6914 39.6258 79.6914 39.6169 79.6914 39.6169L79.718 36.9717C79.7268 36.4762 80.1338 36.0781 80.6292 36.0781C81.1158 36.087 81.5139 36.4851 81.5227 36.9717Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.5672 42.2533L81.576 44.8986C81.576 45.4294 81.1514 45.863 80.6205 45.863C80.0897 45.863 79.6562 45.4383 79.6562 44.9074V44.8986L79.6651 42.2533C79.6651 41.7314 80.0986 41.3066 80.6205 41.3066C81.1425 41.3066 81.5672 41.7314 81.5672 42.2533Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.5831 47.5351L81.5919 50.1804C81.5919 50.72 81.1584 51.1625 80.6187 51.1625C80.0791 51.1625 79.6367 50.7289 79.6367 50.1892V50.1804L79.6456 47.5351C79.6456 46.9955 80.0791 46.5621 80.6187 46.5709C81.1495 46.5709 81.5831 47.0043 81.5831 47.5351Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.6029 52.8257V55.471C81.6029 56.0195 81.1605 56.4619 80.612 56.4619C80.0634 56.4619 79.6211 56.0195 79.6211 55.471V52.8257C79.6211 52.2772 80.0634 51.835 80.612 51.835C81.1605 51.835 81.6029 52.2772 81.6029 52.8257Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.6037 58.1072L81.5948 60.7525C81.5948 61.2922 81.1524 61.7255 80.6216 61.7167C80.0908 61.7167 79.6573 61.2833 79.6573 60.7525L79.6484 58.1072C79.6484 57.5676 80.0819 57.1251 80.6216 57.1251C81.1613 57.1163 81.5948 57.5587 81.6037 58.1072Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.576 63.3889L81.5672 66.0341C81.5672 66.5561 81.1337 66.9894 80.6117 66.9806C80.0897 66.9806 79.6651 66.5561 79.6651 66.0341L79.6562 63.3889C79.6562 62.858 80.0809 62.4244 80.6117 62.4244C81.1425 62.4156 81.576 62.8492 81.576 63.3889Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M81.5659 68.6354L81.7606 71.1744L81.7694 71.2629C81.8048 71.7583 81.4333 72.1919 80.9378 72.2273C80.4512 72.2627 80.0177 71.8998 79.9735 71.4132L79.7081 68.6885C79.655 68.1754 80.0354 67.724 80.5397 67.671C81.044 67.6179 81.504 67.9985 81.5571 68.5027C81.5571 68.5116 81.5571 68.5114 81.5571 68.5202L81.5659 68.6354Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M82.2063 73.6868L82.9141 76.1375L82.9406 76.226C83.0733 76.6772 82.8079 77.146 82.3656 77.2699C81.9232 77.3938 81.4632 77.1459 81.3216 76.7124L80.5077 74.1026C80.3661 73.6426 80.6227 73.156 81.0827 73.0056C81.5428 72.8552 82.0294 73.1207 82.1798 73.5808C82.1798 73.5896 82.1798 73.5896 82.1798 73.5896L82.2063 73.6868Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M83.8585 78.5084L85.0439 80.7821L85.0793 80.853C85.274 81.2246 85.1324 81.6845 84.752 81.8792C84.3893 82.0649 83.9381 81.9322 83.7346 81.5783L82.3898 79.2073C82.1686 78.8181 82.3102 78.3226 82.6995 78.1103C83.0888 77.8891 83.5842 78.0308 83.7965 78.4112C83.7965 78.42 83.8054 78.4289 83.8054 78.4289L83.8585 78.5084Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M86.4605 82.923L88.0883 84.9136L88.1326 84.9667C88.3626 85.2498 88.3272 85.6745 88.0353 85.9045C87.7522 86.1346 87.3452 86.0991 87.1152 85.8248L85.3281 83.79C85.0627 83.4892 85.0981 83.0381 85.39 82.7815C85.682 82.5249 86.142 82.5515 86.3986 82.8435C86.4074 82.8523 86.4074 82.8524 86.4163 82.8612L86.4605 82.923Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M89.8896 86.7452L91.8802 88.382L91.9244 88.4172C92.1544 88.603 92.1898 88.9481 91.9952 89.1781C91.8094 89.3993 91.482 89.4436 91.252 89.2667L89.0845 87.6565C88.819 87.453 88.7571 87.0726 88.9606 86.8072C89.1641 86.5418 89.5445 86.4797 89.8099 86.6832C89.8188 86.6921 89.8276 86.6921 89.8276 86.7009L89.8896 86.7452Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M94.0398 89.8149L96.3312 91.0448L96.3666 91.0625C96.5524 91.1598 96.6232 91.3985 96.5259 91.5843C96.4285 91.7613 96.2074 91.832 96.0304 91.7524L93.5886 90.6376C93.3498 90.5315 93.2436 90.2484 93.3497 90.0095C93.4559 89.7707 93.739 89.6645 93.9779 89.7706C93.9867 89.7706 93.9956 89.7795 94.0044 89.7795L94.0398 89.8149Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M98.738 92.0357L101.251 92.7701L101.268 92.7789C101.383 92.8143 101.445 92.9294 101.41 93.0444C101.374 93.1505 101.268 93.2124 101.162 93.1947L98.5611 92.6109C98.4018 92.5755 98.2956 92.4161 98.331 92.2569C98.3664 92.0976 98.5257 91.9915 98.6849 92.0268C98.6938 92.0268 98.6938 92.0268 98.7026 92.0357H98.738Z"
                                                        fill="#735CD2"/>
                                                    <path
                                                        d="M103.825 93.2656L106.364 93.5043L103.799 93.4957C103.737 93.4957 103.684 93.4425 103.684 93.3805C103.684 93.3186 103.737 93.2656 103.799 93.2656H103.807H103.825Z"
                                                        fill="#735CD2"/>
                                                </g>
                                            </g>
                                            <path opacity="0.26"
                                                  d="M285.858 178.516C283.858 157.911 272.631 140.013 256.362 128.99V105.324C256.362 72.8998 231.121 46.3765 200.227 46.3765H199.909C169.015 46.3765 143.774 72.9086 143.774 105.324V132.44C130.035 143.552 120.737 159.937 118.932 178.507C118.719 180.683 118.613 182.895 118.613 185.133V189.689C118.613 227.112 148.95 257.449 186.373 257.449H218.417C229.626 257.449 240.198 254.733 249.505 249.911C249.673 249.823 249.841 249.743 250.001 249.654C271.517 238.304 286.176 215.709 286.176 189.689V185.133C286.185 182.904 286.07 180.692 285.858 178.516ZM240.189 120.957C233.359 118.639 226.034 117.383 218.425 117.383H186.382C177.013 117.383 168.077 119.285 159.964 122.726V111.499C159.964 109.624 160.026 107.766 160.15 105.943C160.937 94.628 164.158 84.3212 169.882 76.5004C176.535 67.4234 186.558 61.7082 200.077 61.7082C224.397 61.7082 237.11 79.8271 239.694 102.537C240.03 105.457 240.189 108.456 240.189 111.499V120.957Z"
                                                  fill="url(#paint0_linear_381_57599)"/>
                                            <path opacity="0.19"
                                                  d="M242.95 251.539C238.225 256.219 232.811 260.2 226.883 263.332C226.715 263.421 226.556 263.509 226.388 263.588C217.081 268.41 206.509 271.126 195.299 271.126H163.256C125.833 271.126 95.4961 240.79 95.4961 203.367V198.811C95.4961 196.572 95.6023 194.361 95.8146 192.184C97.6194 173.614 106.918 157.23 120.657 146.118V119.002C120.657 98.211 131.035 79.8535 146.623 69.3433C136.104 80.0747 129.548 95.0616 129.548 111.588V138.704C115.809 149.816 106.511 166.201 104.706 184.77C104.494 186.947 104.387 189.167 104.387 191.397V195.953C104.387 233.376 134.724 263.712 172.147 263.712H204.191C215.391 263.712 225.963 260.996 235.279 256.175C235.447 256.086 235.607 256.007 235.775 255.918C238.261 254.609 240.658 253.149 242.95 251.539Z"
                                                  fill="url(#paint1_linear_381_57599)"/>
                                            <path
                                                d="M242.134 111.579V139.925H225.953V117.754C225.953 114.711 225.785 111.712 225.457 108.792C222.874 86.082 210.161 67.9633 185.841 67.9633C173.596 67.9633 164.218 72.6433 157.618 80.2695C156.928 81.0657 156.274 81.8974 155.646 82.7467C149.922 90.5586 146.701 100.874 145.914 112.19C145.79 114.021 145.719 115.879 145.719 117.754V139.925H129.547V111.579C129.547 95.053 136.102 80.0661 146.622 69.3347C156.743 59.0102 170.535 52.6313 185.681 52.6313H186C216.894 52.6313 242.134 79.1637 242.134 111.579Z"
                                                fill="url(#paint2_linear_381_57599)"/>
                                            <path opacity="0.82"
                                                  d="M242.137 116.303V134.121C237.147 130.998 231.715 128.503 225.964 126.76V117.754C225.964 114.711 225.796 111.712 225.469 108.792C231.396 110.544 236.997 113.092 242.137 116.303Z"
                                                  fill="url(#paint3_linear_381_57599)"/>
                                            <path opacity="0.82"
                                                  d="M225.953 117.754C225.953 114.711 225.784 111.712 225.457 108.792C225.59 108.827 225.722 108.872 225.846 108.907C225.917 110.278 225.953 111.65 225.953 113.039V117.754Z"
                                                  fill="url(#paint4_linear_381_57599)"/>
                                            <path
                                                d="M242.133 129.406V134.112C237.144 130.989 231.712 128.494 225.961 126.752V122.045C231.712 123.797 237.135 126.283 242.133 129.406Z"
                                                fill="url(#paint5_linear_381_57599)"/>
                                            <path
                                                d="M271.949 191.397V195.953C271.949 218.964 260.484 239.294 242.949 251.539C240.657 253.14 238.26 254.609 235.774 255.918C235.606 256.007 235.447 256.095 235.279 256.175C225.971 260.987 215.399 263.712 204.19 263.712H172.146C134.723 263.712 104.387 233.376 104.387 195.953V191.397C104.387 189.158 104.493 186.947 104.705 184.77C106.51 166.2 115.808 149.816 129.548 138.704C130.052 138.288 130.565 137.89 131.087 137.492C132.927 136.085 134.847 134.767 136.838 133.555C137.298 133.272 137.758 132.997 138.227 132.723C140.642 131.325 143.145 130.069 145.729 128.981C153.85 125.539 162.777 123.637 172.146 123.637H204.19C208.587 123.637 212.895 124.053 217.062 124.858C220.106 125.442 223.078 126.229 225.954 127.211C228.449 128.061 230.882 129.043 233.235 130.166C236.34 131.635 239.313 133.343 242.126 135.253C258.396 146.268 269.623 164.174 271.622 184.77C271.843 186.947 271.949 189.158 271.949 191.397Z"
                                                fill="url(#paint6_linear_381_57599)"/>
                                            <path opacity="0.42"
                                                  d="M271.949 191.397V195.953C271.949 221.972 257.29 244.567 235.774 255.918C238.207 253.662 240.675 251.061 242.79 248.062C260.997 222.255 251.991 169.314 222.725 146.498C193.423 123.655 160.061 131.14 138.227 132.723C148.206 126.946 159.787 123.637 172.146 123.637H204.19C239.384 123.637 268.304 150.461 271.631 184.77C271.843 186.947 271.949 189.158 271.949 191.397Z"
                                                  fill="url(#paint7_linear_381_57599)"/>
                                            <path
                                                d="M179.277 263.713H172.146C134.723 263.713 104.387 233.376 104.387 195.953V191.397C104.387 189.159 104.493 186.947 104.705 184.771C106.572 165.511 116.507 148.613 131.087 137.492C119.904 163.582 117.471 205.782 131.777 232.235C145.747 258.077 168.926 262.023 179.277 263.713Z"
                                                fill="url(#paint8_linear_381_57599)"/>
                                            <path opacity="0.5"
                                                  d="M195.971 263.712H172.146C134.723 263.712 104.387 233.376 104.387 195.953V191.397C104.387 189.158 104.493 186.947 104.705 184.77C106.572 165.51 116.507 148.613 131.087 137.492C133.352 135.758 135.741 134.165 138.227 132.723C148.206 126.946 159.787 123.637 172.146 123.637H190.92C182.904 128.131 175.358 133.98 174.393 142.818C172.818 157.309 190.937 161.485 194.874 181.311C200.103 207.684 172.226 221.37 176.853 242.745C178.967 252.503 186.797 258.926 195.971 263.712Z"
                                                  fill="url(#paint9_linear_381_57599)"/>
                                            <path
                                                d="M203.598 219.645C204.253 222.299 202.245 224.856 199.52 224.856H176.411C173.687 224.856 171.678 222.299 172.333 219.645L178.084 196.263C178.455 194.741 177.96 193.148 176.792 192.113C173.191 188.937 170.944 184.248 171.059 179.037C171.254 170.279 178.181 163.13 186.816 162.538C187.161 162.511 187.506 162.502 187.851 162.494C197.246 162.432 204.89 170.031 204.89 179.409C204.89 184.469 202.66 189.017 199.139 192.122C197.972 193.148 197.494 194.75 197.865 196.254L203.598 219.645Z"
                                                fill="white"/>
                                            <path
                                                d="M178.074 196.263L172.323 219.645C171.668 222.299 173.677 224.856 176.402 224.856H174.084C171.359 224.856 169.35 222.299 170.005 219.645L175.756 196.263C176.127 194.741 175.632 193.149 174.455 192.113C170.854 188.937 168.616 184.248 168.722 179.037C168.917 169.934 176.402 162.564 185.514 162.502C185.948 162.502 186.372 162.511 186.797 162.547C178.162 163.139 171.235 170.288 171.04 179.046C170.925 184.257 173.164 188.946 176.773 192.122C177.95 193.149 178.445 194.75 178.074 196.263Z"
                                                fill="url(#paint10_linear_381_57599)"/>
                                            <path opacity="0.82"
                                                  d="M129.547 121.576C134.43 117.295 139.942 113.703 145.914 110.951C145.79 112.783 145.719 114.631 145.719 116.507V128.849C140.146 131.432 134.988 134.75 130.361 138.678H129.547V121.576Z"
                                                  fill="url(#paint11_linear_381_57599)"/>
                                            <path
                                                d="M145.728 122.408V128.45C140.225 131.219 135.112 134.581 130.449 138.447H129.547V132.865C134.457 128.795 139.88 125.265 145.728 122.408Z"
                                                fill="url(#paint12_linear_381_57599)"/>
                                            <path opacity="0.18"
                                                  d="M304.21 239.799C303.573 246.328 301.963 258.015 297.893 270.817C296.434 275.417 294.655 280.168 292.488 284.874C285.693 299.649 275.104 313.99 258.604 322.041C258.259 322.218 257.923 322.386 257.56 322.554C257.533 322.563 257.498 322.589 257.454 322.607C257.427 322.598 257.392 322.572 257.347 322.554C255.038 321.475 252.844 320.28 250.756 318.98C249.261 318.051 247.819 317.06 246.439 316.025C243.679 313.963 241.131 311.708 238.778 309.301C237.557 308.054 236.389 306.762 235.265 305.444C232.355 302.002 229.771 298.322 227.498 294.527C223.472 287.821 220.393 280.734 218.031 273.869C214.59 263.863 212.67 254.335 211.617 247.142C211.201 244.293 210.918 241.816 210.724 239.817C210.414 236.658 212.36 233.748 215.377 232.81L224.03 230.102L252.942 221.061L257.356 219.69L257.409 219.681L299.539 232.819C302.556 233.739 304.52 236.649 304.21 239.799Z"
                                                  fill="url(#paint13_linear_381_57599)"/>
                                            <path
                                                d="M319.613 247.151C318.976 253.68 317.365 265.367 313.296 278.169C311.836 282.769 310.058 287.52 307.89 292.226C301.096 307.001 290.506 321.342 274.006 329.393C273.661 329.57 273.325 329.738 272.962 329.897C272.936 329.906 272.9 329.932 272.856 329.95C272.83 329.941 272.794 329.915 272.75 329.897C270.441 328.818 268.247 327.623 266.159 326.323C264.664 325.394 263.222 324.403 261.841 323.368C259.081 321.307 256.533 319.051 254.18 316.644C252.959 315.397 251.791 314.105 250.668 312.787C247.757 309.345 245.174 305.665 242.9 301.87C238.875 295.164 235.796 288.077 233.434 281.212C229.992 271.206 228.072 261.678 227.02 254.485C226.604 251.636 226.321 249.159 226.126 247.16C225.816 244.001 227.763 241.091 230.78 240.153L239.432 237.446L268.344 228.404L272.759 227.033L272.812 227.024L314.941 240.162C317.958 241.082 319.913 243.993 319.613 247.151Z"
                                                fill="url(#paint14_linear_381_57599)"/>
                                            <g opacity="0.43">
                                                <path opacity="0.2"
                                                      d="M308.094 259.342C311.876 259.342 314.941 256.276 314.941 252.494C314.941 248.712 311.876 245.646 308.094 245.646C304.312 245.646 301.246 248.712 301.246 252.494C301.246 256.276 304.312 259.342 308.094 259.342Z"
                                                      fill="white"/>
                                                <path opacity="0.2"
                                                      d="M248.154 292.226C248.154 296.269 246.066 299.817 242.908 301.869C238.882 295.163 235.804 288.077 233.441 281.212C234.468 280.911 235.547 280.751 236.671 280.751C243.014 280.743 248.154 285.883 248.154 292.226Z"
                                                      fill="white"/>
                                                <path opacity="0.2"
                                                      d="M243.748 245.938C243.748 251.76 239.033 256.475 233.211 256.475C230.902 256.475 228.761 255.732 227.027 254.467C226.612 251.618 226.328 249.141 226.134 247.142C225.824 243.983 227.771 241.073 230.787 240.135L239.44 237.428C242.05 239.356 243.748 242.453 243.748 245.938Z"
                                                      fill="white"/>
                                                <path opacity="0.2"
                                                      d="M283.895 312.07C288.009 312.07 291.344 308.735 291.344 304.621C291.344 300.507 288.009 297.172 283.895 297.172C279.78 297.172 276.445 300.507 276.445 304.621C276.445 308.735 279.78 312.07 283.895 312.07Z"
                                                      fill="white"/>
                                                <path opacity="0.2"
                                                      d="M243.746 273.612C246.179 273.612 248.151 271.639 248.151 269.206C248.151 266.773 246.179 264.8 243.746 264.8C241.312 264.8 239.34 266.773 239.34 269.206C239.34 271.639 241.312 273.612 243.746 273.612Z"
                                                      fill="white"/>
                                                <path opacity="0.2"
                                                      d="M289.832 254.75C292.265 254.75 294.237 252.778 294.237 250.344C294.237 247.911 292.265 245.938 289.832 245.938C287.398 245.938 285.426 247.911 285.426 250.344C285.426 252.778 287.398 254.75 289.832 254.75Z"
                                                      fill="white"/>
                                                <path opacity="0.2"
                                                      d="M313.295 278.168C311.836 282.769 310.057 287.52 307.89 292.226C304.846 291.253 302.652 288.404 302.652 285.042C302.652 280.875 306.023 277.505 310.19 277.505C311.296 277.505 312.349 277.744 313.295 278.168Z"
                                                      fill="white"/>
                                                <path opacity="0.2"
                                                      d="M265.877 230.067C260.055 230.067 255.34 234.782 255.34 240.604C255.34 246.425 260.055 251.141 265.877 251.141C271.698 251.141 276.414 246.425 276.414 240.604C276.414 234.782 271.698 230.067 265.877 230.067ZM265.877 246.469C262.639 246.469 260.02 243.842 260.02 240.612C260.02 237.374 262.639 234.747 265.877 234.747C269.115 234.747 271.742 237.374 271.742 240.612C271.742 243.842 269.115 246.469 265.877 246.469Z"
                                                      fill="white"/>
                                                <path opacity="0.2"
                                                      d="M259.93 307.284C255.94 307.284 252.463 309.504 250.676 312.778C251.791 314.105 252.967 315.388 254.188 316.635C254.737 313.963 257.099 311.964 259.93 311.964C263.168 311.964 265.787 314.591 265.787 317.829C265.787 320.395 264.141 322.571 261.85 323.368C263.23 324.403 264.672 325.394 266.167 326.323C268.768 324.403 270.458 321.315 270.458 317.829C270.467 312.008 265.751 307.284 259.93 307.284Z"
                                                      fill="white"/>
                                            </g>
                                            <path
                                                d="M297.7 275.992C297.7 276.523 297.683 277.036 297.638 277.558C296.895 289.802 287.261 299.632 275.123 300.711C274.38 300.79 273.636 300.817 272.876 300.817C272.646 300.817 272.424 300.817 272.194 300.799C268.204 300.693 264.444 299.649 261.144 297.888C257.535 295.933 254.456 293.129 252.191 289.723C250.307 286.883 248.989 283.654 248.414 280.177C248.175 278.859 248.051 277.505 248.051 276.125V275.992C248.051 262.279 259.154 251.167 272.876 251.167C275.087 251.167 277.219 251.451 279.263 251.999H279.281C282.66 252.893 285.775 254.503 288.429 256.644C291.605 259.192 294.117 262.5 295.727 266.296C297.001 269.268 297.7 272.551 297.7 275.992Z"
                                                fill="white"/>
                                            <path
                                                d="M285.271 269.534L270.372 284.025C269.54 284.83 268.187 284.706 267.523 283.76L260.977 274.408"
                                                stroke="url(#paint15_linear_381_57599)" stroke-width="6.51619"
                                                stroke-miterlimit="10" stroke-linecap="square"
                                                stroke-linejoin="round"/>
                                            <path opacity="0.21"
                                                  d="M285.288 260.554L256.376 286.945C254.872 284.68 253.819 282.105 253.359 279.327L277.972 256.847H277.981C280.679 257.564 283.165 258.847 285.288 260.554Z"
                                                  fill="url(#paint16_linear_381_57599)"/>
                                            <path opacity="0.21"
                                                  d="M292.683 275.992C292.683 276.417 292.674 276.824 292.639 277.24L272.335 295.792C269.15 295.703 266.151 294.872 263.523 293.465L291.117 268.26C292.126 270.631 292.683 273.241 292.683 275.992Z"
                                                  fill="url(#paint17_linear_381_57599)"/>
                                            <path opacity="0.12"
                                                  d="M112.295 99.1751H25.6122C11.5277 99.1751 0 87.6475 0 73.563C0 59.4785 11.5277 47.9507 25.6122 47.9507H112.295C126.38 47.9507 137.908 59.4785 137.908 73.563C137.908 87.6475 126.389 99.1751 112.295 99.1751Z"
                                                  fill="url(#paint18_linear_381_57599)"/>
                                            <path
                                                d="M127.027 113.605H47.8194C34.947 113.605 24.4102 103.068 24.4102 90.1953C24.4102 77.3229 34.947 66.7861 47.8194 66.7861H127.027C139.899 66.7861 150.436 77.3229 150.436 90.1953C150.436 103.077 139.899 113.605 127.027 113.605Z"
                                                fill="url(#paint19_linear_381_57599)"/>
                                            <path d="M54.8008 79.6851V100.723" stroke="white" stroke-width="4.15244"
                                                  stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M65.3195 90.2041H44.2812" stroke="white" stroke-width="4.15244"
                                                  stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M62.2401 97.6356L47.3594 82.7637" stroke="white"
                                                  stroke-width="4.15244" stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M47.3594 97.6356L62.2401 82.7637" stroke="white"
                                                  stroke-width="4.15244" stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M89.8555 79.6851V100.723" stroke="white" stroke-width="4.15244"
                                                  stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M100.374 90.2041H79.3359" stroke="white" stroke-width="4.15244"
                                                  stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M97.2937 97.6356L82.4219 82.7637" stroke="white"
                                                  stroke-width="4.15244" stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M82.4219 97.6356L97.2937 82.7637" stroke="white"
                                                  stroke-width="4.15244" stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M124.91 79.6851V100.723" stroke="white" stroke-width="4.15244"
                                                  stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M135.429 90.2041H114.391" stroke="white" stroke-width="4.15244"
                                                  stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M132.349 97.6356L117.469 82.7637" stroke="white"
                                                  stroke-width="4.15244" stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path d="M117.469 97.6356L132.349 82.7637" stroke="white"
                                                  stroke-width="4.15244" stroke-miterlimit="10" stroke-linecap="round"
                                                  stroke-linejoin="round"/>
                                            <path
                                                d="M279.531 139.925L282.177 139.783C282.256 139.783 282.318 139.836 282.327 139.916C282.327 139.996 282.274 140.058 282.194 140.066C282.185 140.066 282.185 140.066 282.177 140.066L279.531 139.925Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M286.944 139.589L289.589 139.483C289.837 139.474 290.04 139.66 290.049 139.907C290.058 140.155 289.872 140.359 289.625 140.367C289.616 140.367 289.598 140.367 289.589 140.367L286.944 140.261C286.758 140.252 286.617 140.093 286.625 139.907C286.625 139.739 286.767 139.598 286.944 139.589Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M294.448 139.73L297.111 140.306C297.473 140.385 297.712 140.748 297.632 141.111C297.553 141.473 297.19 141.712 296.827 141.633C296.819 141.633 296.801 141.624 296.792 141.624L296.712 141.606L294.235 140.916L294.164 140.898C293.846 140.81 293.66 140.483 293.749 140.155C293.828 139.846 294.138 139.66 294.448 139.73Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M301.67 142.128L304.014 143.543C304.412 143.782 304.545 144.304 304.298 144.702C304.05 145.101 303.537 145.233 303.139 144.986C303.13 144.977 303.121 144.977 303.112 144.968L303.032 144.915L300.9 143.508L300.821 143.455C300.458 143.216 300.361 142.73 300.599 142.367C300.838 142.013 301.307 141.916 301.67 142.128Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M307.771 146.746L309.549 148.843C309.894 149.241 309.841 149.851 309.434 150.187C309.027 150.524 308.426 150.479 308.09 150.072C308.09 150.064 308.081 150.064 308.081 150.055L308.01 149.966L306.418 147.993L306.356 147.914C306.037 147.515 306.099 146.94 306.497 146.622C306.878 146.312 307.453 146.365 307.771 146.746Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M312.113 153.08L313.131 155.646C313.334 156.168 313.077 156.77 312.555 156.973C312.034 157.177 311.432 156.92 311.228 156.398V156.389L311.184 156.283L310.273 153.921L310.229 153.815C310.025 153.293 310.291 152.709 310.813 152.506C311.326 152.311 311.91 152.567 312.113 153.08Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M314.194 160.503C314.248 161.423 314.31 162.343 314.354 163.263C314.38 163.847 313.929 164.343 313.354 164.369C312.77 164.396 312.275 163.945 312.248 163.369L312.239 163.272L312.115 160.742L312.107 160.627C312.08 160.052 312.522 159.565 313.097 159.539C313.681 159.503 314.159 159.937 314.194 160.503Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M314.345 168.032L314.336 170.677C314.336 171.243 313.867 171.703 313.301 171.703C312.734 171.703 312.274 171.243 312.274 170.677L312.266 168.032C312.266 167.457 312.726 166.988 313.301 166.988C313.876 166.988 314.336 167.448 314.345 168.032Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M314.307 175.437L314.272 178.082C314.263 178.622 313.821 179.055 313.281 179.047C312.75 179.038 312.326 178.613 312.317 178.082L312.281 175.437C312.273 174.88 312.724 174.42 313.272 174.42C313.83 174.411 314.29 174.862 314.29 175.41C314.307 175.419 314.307 175.437 314.307 175.437Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M314.21 182.851L314.166 185.496C314.157 185.982 313.759 186.363 313.281 186.354C312.813 186.345 312.432 185.965 312.423 185.496L312.379 182.851C312.37 182.346 312.777 181.93 313.281 181.922C313.786 181.913 314.202 182.32 314.21 182.824C314.21 182.833 314.21 182.842 314.21 182.851Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M314.068 190.265L314.015 192.91C314.006 193.308 313.679 193.618 313.281 193.618C312.891 193.609 312.582 193.299 312.573 192.91L312.52 190.265C312.511 189.84 312.847 189.486 313.281 189.468C313.705 189.46 314.059 189.796 314.068 190.229C314.068 190.238 314.068 190.256 314.068 190.265Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M313.883 197.678L313.794 200.324C313.786 200.598 313.556 200.81 313.281 200.801C313.016 200.793 312.812 200.58 312.804 200.324L312.715 197.678C312.706 197.36 312.954 197.086 313.281 197.077C313.609 197.068 313.874 197.316 313.883 197.643C313.883 197.652 313.883 197.661 313.883 197.678Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M313.6 205.083L313.494 207.728C313.485 207.835 313.397 207.923 313.282 207.923C313.175 207.923 313.096 207.835 313.087 207.728L312.981 205.083C312.972 204.915 313.105 204.773 313.273 204.765C313.441 204.756 313.583 204.889 313.591 205.057C313.6 205.074 313.6 205.074 313.6 205.083Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M223.426 312.353L220.781 312.486C220.71 312.486 220.648 312.433 220.648 312.362C220.648 312.291 220.702 312.229 220.772 312.229H220.781L223.426 312.353Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M216.011 312.663L213.365 312.761C213.144 312.769 212.95 312.593 212.95 312.371C212.941 312.15 213.118 311.956 213.339 311.956C213.348 311.956 213.356 311.956 213.365 311.956L216.011 312.053C216.179 312.062 216.311 312.203 216.311 312.371C216.302 312.522 216.17 312.655 216.011 312.663Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M208.604 312.911L205.959 312.981C205.605 312.99 205.322 312.716 205.313 312.362C205.304 312.008 205.578 311.725 205.932 311.716C205.941 311.716 205.959 311.716 205.967 311.716L208.613 311.787C208.922 311.796 209.17 312.052 209.161 312.362C209.143 312.663 208.896 312.902 208.604 312.911Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M201.19 313.097L198.545 313.149C198.102 313.158 197.739 312.804 197.731 312.371C197.722 311.929 198.076 311.566 198.509 311.557C198.518 311.557 198.527 311.557 198.536 311.557L201.181 311.61C201.597 311.619 201.924 311.955 201.915 312.371C201.915 312.769 201.588 313.088 201.19 313.097Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M193.778 313.238L191.132 313.274C190.628 313.283 190.203 312.876 190.203 312.363C190.194 311.858 190.601 311.442 191.115 311.434C191.123 311.434 191.132 311.434 191.141 311.434L193.786 311.469C194.273 311.478 194.671 311.876 194.662 312.363C194.645 312.84 194.255 313.23 193.778 313.238Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M186.366 313.327L183.721 313.353C183.163 313.362 182.712 312.92 182.703 312.363C182.694 311.805 183.137 311.354 183.694 311.345C183.703 311.345 183.712 311.345 183.721 311.345L186.366 311.372C186.906 311.38 187.33 311.823 187.33 312.354C187.321 312.893 186.897 313.318 186.366 313.327Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M178.959 313.38L176.314 313.388C175.738 313.388 175.27 312.929 175.27 312.353C175.27 311.778 175.73 311.31 176.305 311.31H176.314L178.959 311.318C179.525 311.318 179.985 311.778 179.985 312.353C179.976 312.92 179.516 313.38 178.959 313.38Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M171.546 313.406H168.901C168.317 313.406 167.848 312.937 167.848 312.354C167.848 311.77 168.317 311.301 168.901 311.301H171.546C172.13 311.301 172.599 311.77 172.607 312.354C172.599 312.929 172.13 313.406 171.546 313.406Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M164.061 313.327L161.319 312.973C160.761 312.902 160.363 312.389 160.434 311.832C160.505 311.274 161.018 310.885 161.575 310.947L161.69 310.965L164.203 311.274L164.318 311.292C164.884 311.363 165.282 311.876 165.22 312.442C165.158 313.008 164.636 313.398 164.061 313.327Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M156.567 311.54L154.09 310.319C153.613 310.089 153.418 309.514 153.657 309.036C153.887 308.567 154.444 308.372 154.922 308.594L155.019 308.638L157.319 309.708L157.426 309.753C157.921 309.983 158.133 310.566 157.903 311.071C157.673 311.566 157.089 311.779 156.594 311.549C156.576 311.54 156.567 311.54 156.567 311.54Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M150.056 307.452L148.1 305.524C147.764 305.187 147.755 304.648 148.092 304.303C148.419 303.975 148.95 303.958 149.286 304.276L149.357 304.347L151.223 306.081L151.294 306.152C151.657 306.488 151.683 307.063 151.338 307.434C150.993 307.806 150.427 307.824 150.056 307.479C150.064 307.47 150.056 307.461 150.056 307.452Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M145.201 301.542L143.963 299.109C143.786 298.755 143.928 298.322 144.281 298.136C144.626 297.959 145.051 298.092 145.237 298.428L145.281 298.499L146.529 300.737L146.573 300.817C146.776 301.188 146.644 301.657 146.272 301.87C145.9 302.082 145.432 301.94 145.219 301.569C145.21 301.56 145.21 301.551 145.201 301.542Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M142.501 294.438L142.112 291.757C142.067 291.465 142.271 291.2 142.563 291.165C142.837 291.12 143.102 291.306 143.156 291.581L143.164 291.642L143.669 294.173L143.677 294.243C143.739 294.571 143.527 294.88 143.209 294.942C142.881 295.004 142.572 294.792 142.51 294.473C142.51 294.465 142.501 294.447 142.501 294.438Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M142.138 286.936L142.235 284.291C142.244 284.149 142.359 284.034 142.501 284.043C142.633 284.052 142.748 284.158 142.748 284.291L142.846 286.936C142.854 287.131 142.695 287.299 142.501 287.307C142.306 287.316 142.138 287.157 142.129 286.963C142.138 286.954 142.138 286.945 142.138 286.936Z"
                                                fill="#F9C200"/>
                                            <path
                                                d="M142.438 279.522L142.499 278.301L142.561 279.522C142.561 279.557 142.535 279.584 142.508 279.584C142.464 279.593 142.438 279.566 142.438 279.522C142.438 279.531 142.438 279.531 142.438 279.522Z"
                                                fill="#F9C200"/>
                                            <defs>
                                                <linearGradient id="paint0_linear_381_57599" x1="202.4" y1="272.838"
                                                                x2="202.4" y2="56.7508" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#EFEFEF"/>
                                                </linearGradient>
                                                <linearGradient id="paint1_linear_381_57599" x1="169.222" y1="271.128"
                                                                x2="169.222" y2="69.3403"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#B4BCBE"/>
                                                </linearGradient>
                                                <linearGradient id="paint2_linear_381_57599" x1="185.84" y1="135.378"
                                                                x2="185.84" y2="54.1048" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#EFEFEF"/>
                                                </linearGradient>
                                                <linearGradient id="paint3_linear_381_57599" x1="233.798" y1="106.813"
                                                                x2="233.798" y2="138.875"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#B4BCBE"/>
                                                </linearGradient>
                                                <linearGradient id="paint4_linear_381_57599" x1="225.707" y1="108.091"
                                                                x2="225.707" y2="119.435"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#B4BCBE"/>
                                                </linearGradient>
                                                <linearGradient id="paint5_linear_381_57599" x1="248.648" y1="135.707"
                                                                x2="223.87" y2="122.602" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#B4BCBE"/>
                                                </linearGradient>
                                                <linearGradient id="paint6_linear_381_57599" x1="188.169" y1="264.02"
                                                                x2="188.169" y2="113.544"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#EFEFEF"/>
                                                </linearGradient>
                                                <linearGradient id="paint7_linear_381_57599" x1="261.735" y1="219.168"
                                                                x2="128.418" y2="72.949" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#B4BCBE"/>
                                                </linearGradient>
                                                <linearGradient id="paint8_linear_381_57599" x1="110.957" y1="163.254"
                                                                x2="192.513" y2="310.496"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="0.3003" stop-color="#D7DBDC"/>
                                                    <stop offset="0.7459" stop-color="#C3C9CB"/>
                                                    <stop offset="1" stop-color="#B4BCBE"/>
                                                </linearGradient>
                                                <linearGradient id="paint9_linear_381_57599" x1="61.683" y1="193.676"
                                                                x2="179.699" y2="193.676"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#FEFEFC"/>
                                                    <stop offset="1" stop-color="white" stop-opacity="0.1"/>
                                                </linearGradient>
                                                <linearGradient id="paint10_linear_381_57599" x1="176.979" y1="158.528"
                                                                x2="179.846" y2="228.149"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#B4BCBE"/>
                                                </linearGradient>
                                                <linearGradient id="paint11_linear_381_57599" x1="137.731" y1="105.572"
                                                                x2="137.731" y2="137.633"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#B4BCBE"/>
                                                </linearGradient>
                                                <linearGradient id="paint12_linear_381_57599" x1="156.839" y1="119.617"
                                                                x2="130.321" y2="134.77" gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#DEE1E2"/>
                                                    <stop offset="1" stop-color="#B4BCBE"/>
                                                </linearGradient>
                                                <linearGradient id="paint13_linear_381_57599" x1="304.242" y1="219.681"
                                                                x2="205.465" y2="317.32" gradientUnits="userSpaceOnUse">
                                                    <stop offset="0.0001" stop-color="#FF6648"/>
                                                    <stop offset="1" stop-color="#D62300"/>
                                                </linearGradient>
                                                <linearGradient id="paint14_linear_381_57599" x1="319.643" y1="227.024"
                                                                x2="220.866" y2="324.662"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop offset="0.0001" stop-color="#FF6648"/>
                                                    <stop offset="1" stop-color="#D62300"/>
                                                </linearGradient>
                                                <linearGradient id="paint15_linear_381_57599" x1="285.271" y1="269.534"
                                                                x2="272.879" y2="291.325"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#F9963B"/>
                                                    <stop offset="0.0001" stop-color="#F9963B"/>
                                                    <stop offset="1" stop-color="#F95D3B"/>
                                                </linearGradient>
                                                <linearGradient id="paint16_linear_381_57599" x1="287.05" y1="251.997"
                                                                x2="257.406" y2="282.005"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#FEFEFC"/>
                                                    <stop offset="1" stop-color="#C4EAFC" stop-opacity="0.1"/>
                                                </linearGradient>
                                                <linearGradient id="paint17_linear_381_57599" x1="297.976" y1="265.206"
                                                                x2="269.674" y2="293.853"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#FEFEFC"/>
                                                    <stop offset="1" stop-color="#C4EAFC" stop-opacity="0.1"/>
                                                </linearGradient>
                                                <linearGradient id="paint18_linear_381_57599" x1="137.908" y1="47.9507"
                                                                x2="107.834" y2="136.005"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#F9963B"/>
                                                    <stop offset="0.0001" stop-color="#F9963B"/>
                                                    <stop offset="1" stop-color="#F95D3B"/>
                                                </linearGradient>
                                                <linearGradient id="paint19_linear_381_57599" x1="150.436" y1="66.7861"
                                                                x2="122.946" y2="147.264"
                                                                gradientUnits="userSpaceOnUse">
                                                    <stop stop-color="#F9963B"/>
                                                    <stop offset="0.0001" stop-color="#F9963B"/>
                                                    <stop offset="1" stop-color="#F95D3B"/>
                                                </linearGradient>
                                            </defs>
                                        </svg>
                                    </span>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>

        <!-- dashboard part end -->

    </main>
@endsection

@push('js_section')
    <script>
        "use strict";

        let current_password = true;
        let new_password = true;
        let confirm_password = true;

        $(document).ready(function() {

            $("#current_password_eye").on("click", function(e){
                current_password = !current_password;

                if(current_password){
                    $("#current_password").attr('type', 'password');
                    $(this).html(`<span><i class="fa-regular fa-eye-slash"></i></span>`)
                }else{
                    $("#current_password").attr('type', 'text');
                    $(this).html(`<span><i class="fa-regular fa-eye"></i></span>`)
                }
            })

            $("#new_password_eye").on("click", function(e){
                new_password = !new_password;

                if(new_password){
                    $("#new_password").attr('type', 'password');
                    $(this).html(`<span><i class="fa-regular fa-eye-slash"></i></span>`)
                }else{
                    $("#new_password").attr('type', 'text');
                    $(this).html(`<span><i class="fa-regular fa-eye"></i></span>`)
                }
            })

            $("#confirm_password_eye").on("click", function(e){
                confirm_password = !confirm_password;

                if(confirm_password){
                    $("#confirm_password").attr('type', 'password');
                    $(this).html(`<span><i class="fa-regular fa-eye-slash"></i></span>`)
                }else{
                    $("#confirm_password").attr('type', 'text');
                    $(this).html(`<span><i class="fa-regular fa-eye"></i></span>`)
                }
            })
        });

    </script>

@endpush
