@extends('frontend.layouts.master')

@section('title')
    <title>{{ __('translate.Order Details') }}</title>
@endsection

@section('content')
    <main class="search_V1_bg" >
        <!-- banner-part start  -->

        <div class="profile_bg" style="background-image: url({{ asset($general_setting->breadcrumb_image) }})">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">
                        <ul class="breadcrumb">
                            <li><a href="{{route('home')}}">{{__('translate.Home')}}</a></li>
                            <li><a href="javascript:;">/</a></li>
                            <li><a href="javascript:;" class="active">{{__('translate.Order Details')}}</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- banner-part end -->


        <!-- dashboard part start  -->


        <section class="dashboard">
            <div class="container">
                <div class="row">
                    <div class=" col-lg-4 col-xxl-3">
                        @include('frontend.layouts.partials.dashboard_partials')
                    </div>

                    <div class="col-lg-8 col-xxl-9">
                        <div class="dashboard_order_details">
                            <div class="order_details_txt">
                                <h4>{{__('translate.Order Details')}}: <span> #{{$order->id}}</span></h4>
                                <p>{{ $order->created_at->format('h:i A - m-Y') }}</p>
                            </div>

                            <div class="row justify-content-center">
                                <div class="col-xxl-7">

                                    <div class="invoice">
                                        <div class="invoice_top_item">
                                            <div class="invoice_thumb">
                                                <span>
                                                    <svg width="154" height="90" viewBox="0 0 154 90" fill="none"
                                                         xmlns="http://www.w3.org/2000/svg">
                                                        <path
                                                            d="M86.8681 70.5591L91.5596 71.9909L87.1688 73.8884C87.0641 73.9336 86.97 74.0002 86.8924 74.0838C86.8149 74.1674 86.7556 74.2663 86.7183 74.374C86.6811 74.4818 86.6667 74.5962 86.676 74.7099C86.6854 74.8235 86.7184 74.934 86.7728 75.0342L92.3296 85.2788C92.372 85.3538 92.394 85.4386 92.3933 85.5248C92.3926 85.6109 92.3693 85.6954 92.3256 85.7697C92.282 85.844 92.2195 85.9055 92.1446 85.948C92.0697 85.9906 91.9849 86.0127 91.8987 86.0121H87.3356C87.2277 86.0121 87.1242 85.9692 87.0478 85.8929C86.9715 85.8166 86.9286 85.7131 86.9286 85.6051C86.9286 85.4972 86.9715 85.3937 87.0478 85.3173C87.1242 85.241 87.2277 85.1981 87.3356 85.1981H90.3606C90.4474 85.1979 90.5327 85.1746 90.6076 85.1307C90.6826 85.0868 90.7445 85.0238 90.7872 84.9482C90.8299 84.8725 90.8517 84.7869 90.8505 84.7001C90.8493 84.6132 90.8251 84.5283 90.7804 84.4538L84.1328 73.4136L86.8681 70.5591Z"
                                                            fill="url(#paint0_linear_621_19535)"/>
                                                        <path
                                                            d="M81.9607 74.1884L85.2002 71.0718H88.48L83.684 74.6027C83.5196 74.7238 83.4054 74.9012 83.3635 75.1011C83.3216 75.301 83.3547 75.5093 83.4567 75.6862L90.7643 88.3545C90.8135 88.4397 90.8395 88.5365 90.8395 88.6349C90.8395 88.7334 90.8135 88.8302 90.7643 88.9154C90.7151 89.0007 90.6443 89.0716 90.559 89.1208C90.4737 89.17 90.3769 89.1959 90.2785 89.1959H85.862C85.7541 89.1959 85.6506 89.1531 85.5742 89.0767C85.4979 89.0004 85.455 88.8969 85.455 88.789C85.455 88.681 85.4979 88.5775 85.5742 88.5012C85.6506 88.4248 85.7541 88.382 85.862 88.382H88.7623C88.8617 88.3819 88.9593 88.3555 89.0451 88.3054C89.1309 88.2553 89.2019 88.1833 89.2507 88.0968C89.2996 88.0103 89.3246 87.9123 89.3232 87.8129C89.3217 87.7136 89.294 87.6164 89.2427 87.5313L81.8232 75.2096C81.7278 75.0487 81.6895 74.8604 81.7145 74.6751C81.7394 74.4898 81.8262 74.3183 81.9607 74.1884Z"
                                                            fill="url(#paint1_linear_621_19535)"/>
                                                        <path
                                                            d="M37.2825 89.2016C46.7302 89.2016 54.3891 81.5427 54.3891 72.095C54.3891 62.6472 46.7302 54.9883 37.2825 54.9883C27.8347 54.9883 20.1758 62.6472 20.1758 72.095C20.1758 81.5427 27.8347 89.2016 37.2825 89.2016Z"
                                                            fill="url(#paint2_linear_621_19535)"/>
                                                        <path
                                                            d="M37.2743 82.0331C42.7632 82.0331 47.2128 77.5835 47.2128 72.0947C47.2128 66.6058 42.7632 62.1562 37.2743 62.1562C31.7855 62.1562 27.3359 66.6058 27.3359 72.0947C27.3359 77.5835 31.7855 82.0331 37.2743 82.0331Z"
                                                            fill="url(#paint3_linear_621_19535)"/>
                                                        <path
                                                            d="M37.2761 77.1641C40.0757 77.1641 42.3453 74.8946 42.3453 72.095C42.3453 69.2954 40.0757 67.0259 37.2761 67.0259C34.4765 67.0259 32.207 69.2954 32.207 72.095C32.207 74.8946 34.4765 77.1641 37.2761 77.1641Z"
                                                            fill="url(#paint4_linear_621_19535)"/>
                                                        <path
                                                            d="M136.044 89.2016C145.492 89.2016 153.151 81.5427 153.151 72.095C153.151 62.6472 145.492 54.9883 136.044 54.9883C126.596 54.9883 118.938 62.6472 118.938 72.095C118.938 81.5427 126.596 89.2016 136.044 89.2016Z"
                                                            fill="url(#paint5_linear_621_19535)"/>
                                                        <path
                                                            d="M136.048 82.0331C141.537 82.0331 145.986 77.5835 145.986 72.0947C145.986 66.6058 141.537 62.1562 136.048 62.1562C130.559 62.1562 126.109 66.6058 126.109 72.0947C126.109 77.5835 130.559 82.0331 136.048 82.0331Z"
                                                            fill="url(#paint6_linear_621_19535)"/>
                                                        <path
                                                            d="M136.05 77.1641C138.849 77.1641 141.119 74.8946 141.119 72.095C141.119 69.2954 138.849 67.0259 136.05 67.0259C133.25 67.0259 130.98 69.2954 130.98 72.095C130.98 74.8946 133.25 77.1641 136.05 77.1641Z"
                                                            fill="url(#paint7_linear_621_19535)"/>
                                                        <path
                                                            d="M9.57836 27.381L8.38672 28.3623L26.3582 50.1868L27.5499 49.2055L9.57836 27.381Z"
                                                            fill="url(#paint8_linear_621_19535)"/>
                                                        <path d="M32.321 5.61914H3.60938V33.6139H32.321V5.61914Z"
                                                              fill="url(#paint9_linear_621_19535)"/>
                                                        <path
                                                            d="M1.72972 32.814H35.0961V34.5703H1.72972C1.6144 34.5703 1.50021 34.5476 1.39366 34.5034C1.28712 34.4593 1.19031 34.3946 1.10877 34.3131C1.02722 34.2315 0.962536 34.1347 0.918404 34.0282C0.874272 33.9216 0.851562 33.8075 0.851563 33.6921C0.851562 33.5768 0.874272 33.4626 0.918404 33.3561C0.962536 33.2495 1.02722 33.1527 1.10877 33.0712C1.19031 32.9896 1.28712 32.9249 1.39366 32.8808C1.50021 32.8367 1.6144 32.814 1.72972 32.814Z"
                                                            fill="url(#paint10_linear_621_19535)"/>
                                                        <path
                                                            d="M115.145 14.5405C118.208 15.1803 120.666 13.732 120.87 9.62354C121.073 5.51508 119.321 4.40409 116.694 4.37109L115.145 14.5405Z"
                                                            fill="url(#paint11_linear_621_19535)"/>
                                                        <path
                                                            d="M130.591 49.2729C130.591 49.2729 129.005 50.7854 126.82 52.9395C123.32 56.3715 118.279 61.426 115.723 64.4894C111.57 69.4596 105.526 71.9437 100.781 71.9437C96.0368 71.9437 62.2909 72.3104 60.6978 71.9437C60.1019 71.8044 58.694 70.8437 57.1668 69.6942C54.6002 67.7674 51.6888 65.3071 51.6888 65.3071H13.9023C21.6664 45.973 34.1862 40.6197 34.4923 40.0293C34.7985 39.439 35.3705 36.414 35.3705 36.414L36.3843 35.2645L38.8061 34.5862L79.1886 35.6862V39.3199C79.1886 40.1393 78.7596 40.1393 75.3991 42.2091C75.2175 42.3217 75.0446 42.448 74.8821 42.5868L74.7868 42.673C71.9543 45.2396 71.3897 52.0889 72.706 55.4879C74.114 59.1197 76.8071 61.3838 79.3848 62.2821C81.9624 63.1805 83.5262 62.79 84.9324 62.79C86.3385 62.79 85.5172 63.34 91.415 63.34C97.3128 63.34 98.6694 63.7579 103.739 61.459C109.656 58.7768 113.95 49.3866 114.432 47.0161C114.433 47.0125 114.433 47.0088 114.432 47.0051C114.903 44.6475 114.693 40.8617 114.335 39.4885C113.978 38.1153 108.208 21.9382 107.022 18.6712C105.836 15.4042 105.722 13.3729 105.722 13.3729L105.104 10.2691C109.557 6.02863 112.126 4.35482 113.171 3.99733C114.216 3.63983 116.926 3.49316 117.316 3.49316C117.707 3.49316 118.178 4.22648 118.372 4.71231C118.566 5.19814 118.94 8.47245 118.453 10.3846C118.031 12.0346 116.585 14.8047 116.194 15.2282C115.804 15.6517 113.994 15.3419 113.822 15.3419C113.649 15.3419 112.65 16.0899 112.65 16.0899C112.906 17.6312 113.355 19.1341 113.987 20.5632C113.987 20.5705 113.987 20.5778 113.987 20.5852C116.324 26.0411 120.81 31.6052 123.012 34.5881C125.83 38.4068 127.535 38.5572 128.501 41.1513C129.467 43.7455 130.591 49.2729 130.591 49.2729Z"
                                                            fill="url(#paint12_linear_621_19535)"/>
                                                        <path
                                                            d="M114.425 47.0067C114.383 47.3055 113.386 54.0338 108.711 59.6786C104.082 65.2684 95.3662 65.5947 86.174 65.5947C76.9817 65.5947 72.6954 62.6614 70.7741 56.4281C68.8748 50.2608 71.6467 45.4172 74.7781 42.6636C71.9456 45.2302 71.3809 52.0795 72.6972 55.4784C74.1052 59.1102 76.7984 61.3744 79.376 62.2727C81.9537 63.1711 83.5175 62.7806 84.9236 62.7806C86.3298 62.7806 85.5085 63.3306 91.4062 63.3306C97.304 63.3306 98.6607 63.7486 103.73 61.4496C109.648 58.7674 113.941 49.3772 114.425 47.0067Z"
                                                            fill="url(#paint13_linear_621_19535)"/>
                                                        <path
                                                            d="M130.588 49.2721C130.588 49.2721 129.003 50.7846 126.817 52.9388C123.317 56.3707 118.276 61.4252 115.72 64.4887C111.568 69.4588 105.523 71.9429 100.779 71.9429C96.034 71.9429 62.2882 72.3096 60.695 71.9429C60.0992 71.8036 58.6912 70.8429 57.1641 69.6935C67.7808 69.5395 98.9637 69.0829 101.983 68.9766C105.637 68.8483 109.417 67.8858 115.06 57.885C120.703 47.8843 120.725 43.6585 119.548 39.1669C117.975 33.1591 113.394 32.0041 111.791 25.0614C110.277 18.4962 112.644 16.1001 112.644 16.1001C112.902 17.6378 113.352 19.137 113.984 20.5624C113.985 20.5697 113.985 20.5771 113.984 20.5844C116.322 26.0403 120.808 31.6045 123.009 34.5873C125.827 38.4061 127.532 38.5564 128.498 41.1505C129.465 43.7447 130.588 49.2721 130.588 49.2721Z"
                                                            fill="url(#paint14_linear_621_19535)"/>
                                                        <path
                                                            d="M130.588 49.2722C130.588 49.2722 129.002 50.7847 126.817 52.9388L122.417 52.3577C126.852 45.2187 123.641 41.8014 120.325 35.0182C117.113 28.4475 114.18 21.0465 114 20.5918C116.337 26.0477 120.824 31.6119 123.025 34.5947C125.843 38.4135 127.548 38.5638 128.514 41.1579C129.481 43.7521 130.588 49.2722 130.588 49.2722Z"
                                                            fill="url(#paint15_linear_621_19535)"/>
                                                        <path
                                                            d="M16.6055 67.3642C16.6055 67.2285 20.5563 53.8563 32.4967 46.5652C46.5289 37.9981 66.0812 43.1919 66.0812 54.6318C66.0812 65.265 57.0778 67.3715 57.0778 67.3715L16.6055 67.3642Z"
                                                            fill="url(#paint16_linear_621_19535)"/>
                                                        <path
                                                            d="M31.6542 25.3404C31.7 23.5951 33.24 23.5071 34.461 23.6904C35.682 23.8737 41.9666 24.6217 50.8692 25.2322C59.7717 25.8427 74.2311 27.0069 76.5576 26.9775C78.8841 26.9482 81.1537 27.1223 81.1537 30.0942C81.1537 33.066 80.3104 36.4081 78.7979 36.4081H35.3648C35.1613 35.3525 34.6444 34.3827 33.8816 33.6251C32.6295 32.4133 31.5038 31.196 31.6542 25.3404Z"
                                                            fill="url(#paint17_linear_621_19535)"/>
                                                        <path
                                                            d="M31.8053 0H4.13685C3.31266 0 2.64453 0.668126 2.64453 1.49231V6.03711C2.64453 6.8613 3.31266 7.52944 4.13685 7.52944H31.8053C32.6295 7.52944 33.2976 6.8613 33.2976 6.03711V1.49231C33.2976 0.668126 32.6295 0 31.8053 0Z"
                                                            fill="url(#paint18_linear_621_19535)"/>
                                                        <path
                                                            d="M25.3188 19.2982C25.32 20.7474 24.8927 22.1647 24.0906 23.3716C23.2884 24.5786 22.1473 25.5214 20.8107 26.0815C20.39 26.2579 19.9535 26.3942 19.5072 26.4885C18.4802 26.7104 17.4176 26.7104 16.3905 26.4885C15.9448 26.39 15.5091 26.2507 15.0889 26.0724C13.8675 25.5517 12.8099 24.7099 12.0285 23.6364C11.2471 22.5629 10.7712 21.2978 10.6512 19.9755C10.5312 18.6531 10.7716 17.323 11.347 16.1264C11.9223 14.9297 12.8111 13.9113 13.9188 13.1793C15.0266 12.4473 16.3119 12.029 17.6383 11.969C18.9647 11.9089 20.2826 12.2092 21.452 12.8381C22.6214 13.467 23.5986 14.4009 24.2797 15.5406C24.9609 16.6804 25.3206 17.9833 25.3206 19.3111L25.3188 19.2982Z"
                                                            fill="url(#paint19_linear_621_19535)"/>
                                                        <path
                                                            d="M17.2965 16.7808V19.7856C17.2968 19.9438 17.272 20.1009 17.2232 20.2513C17.1582 20.4621 17.0493 20.6567 16.9036 20.8223C16.7579 20.9878 16.5788 21.1207 16.378 21.212C16.3067 21.2428 16.2462 21.2941 16.2041 21.3594C16.162 21.4247 16.1402 21.501 16.1415 21.5786L16.3872 26.4699C15.9414 26.3714 15.5057 26.2321 15.0855 26.0537L15.3092 21.5786C15.3108 21.5007 15.289 21.424 15.2465 21.3586C15.204 21.2932 15.1428 21.2421 15.0708 21.212C14.8707 21.1207 14.692 20.9883 14.5464 20.8234C14.4008 20.6585 14.2915 20.4648 14.2257 20.255C14.1768 20.1046 14.1521 19.9474 14.1523 19.7893V16.7845C14.1523 16.7164 14.1794 16.6511 14.2275 16.603C14.2757 16.5549 14.3409 16.5278 14.409 16.5278C14.4771 16.5278 14.5424 16.5549 14.5905 16.603C14.6386 16.6511 14.6657 16.7164 14.6657 16.7845V19.2686C14.6657 19.3754 14.7081 19.4777 14.7835 19.5532C14.859 19.6287 14.9614 19.6711 15.0681 19.6711C15.1748 19.6711 15.2772 19.6287 15.3526 19.5532C15.4281 19.4777 15.4705 19.3754 15.4705 19.2686V17.2392C15.4705 17.1711 15.4975 17.1058 15.5457 17.0577C15.5938 17.0095 15.6591 16.9825 15.7272 16.9825C15.7952 16.9825 15.8605 17.0095 15.9087 17.0577C15.9568 17.1058 15.9838 17.1711 15.9838 17.2392V19.2686C15.9838 19.3748 16.0259 19.4766 16.1008 19.5519C16.1757 19.6271 16.2773 19.6697 16.3835 19.6701C16.4264 19.67 16.4691 19.6632 16.51 19.65C16.5899 19.6237 16.6596 19.5729 16.709 19.5048C16.7583 19.4366 16.7849 19.3546 16.785 19.2705V16.7863C16.785 16.7183 16.812 16.653 16.8602 16.6048C16.9083 16.5567 16.9736 16.5297 17.0417 16.5297C17.1097 16.5297 17.175 16.5567 17.2231 16.6048C17.2713 16.653 17.2983 16.7183 17.2983 16.7863L17.2965 16.7808Z"
                                                            fill="url(#paint20_linear_621_19535)"/>
                                                        <path
                                                            d="M21.7918 18.9276C21.7918 19.9524 21.4252 20.838 20.8752 21.2578C20.7858 21.3242 20.7138 21.4112 20.6653 21.5114C20.6167 21.6117 20.5932 21.7221 20.5965 21.8334L20.811 26.0776C20.3903 26.2539 19.9539 26.3902 19.5075 26.4846L19.7404 21.8334C19.7444 21.7222 19.7213 21.6117 19.6731 21.5114C19.6249 21.4111 19.5529 21.3241 19.4635 21.2578C18.9245 20.838 18.5469 19.9524 18.5469 18.9276C18.5469 17.494 19.271 16.3335 20.1639 16.3335C21.0567 16.3335 21.7918 17.494 21.7918 18.9276Z"
                                                            fill="url(#paint21_linear_621_19535)"/>
                                                        <path
                                                            d="M83.7305 66.2617V63.0478C83.7305 62.4814 84.2163 62.1587 85.0651 62.1587H100.511C101.244 62.1587 101.259 62.5437 101.259 65.2112C101.257 65.2112 91.1682 68.3846 83.7305 66.2617Z"
                                                            fill="url(#paint22_linear_621_19535)"/>
                                                        <path
                                                            d="M47.9251 57.5366H34.4943C34.1156 57.5366 33.8086 57.8432 33.8086 58.2214C33.8086 58.5995 34.1156 58.9061 34.4943 58.9061H47.9251C48.3038 58.9061 48.6108 58.5995 48.6108 58.2214C48.6108 57.8432 48.3038 57.5366 47.9251 57.5366Z"
                                                            fill="url(#paint23_linear_621_19535)"/>
                                                        <path
                                                            d="M46.4915 59.876H33.0607C32.682 59.876 32.375 60.1826 32.375 60.5607C32.375 60.9389 32.682 61.2455 33.0607 61.2455H46.4915C46.8702 61.2455 47.1772 60.9389 47.1772 60.5607C47.1772 60.1826 46.8702 59.876 46.4915 59.876Z"
                                                            fill="url(#paint24_linear_621_19535)"/>
                                                        <path
                                                            d="M45.0501 62.2134H31.6193C31.2406 62.2134 30.9336 62.52 30.9336 62.8981C30.9336 63.2763 31.2406 63.5829 31.6193 63.5829H45.0501C45.4288 63.5829 45.7358 63.2763 45.7358 62.8981C45.7358 62.52 45.4288 62.2134 45.0501 62.2134Z"
                                                            fill="url(#paint25_linear_621_19535)"/>
                                                        <path
                                                            d="M113.641 70.9255C113.641 70.9255 120.556 71.0721 131.24 65.7005C141.925 60.3289 148.637 58.5854 152.091 58.8549C150.582 50.561 138.211 44.907 128.118 48.6287C114.805 53.542 113.641 70.9255 113.641 70.9255Z"
                                                            fill="url(#paint26_linear_621_19535)"/>
                                                        <path
                                                            d="M105.977 13.084C106.655 14.0666 108.27 14.3471 109.416 13.3883C110.562 12.4295 110.575 8.65651 108.61 8.09551C106.644 7.53452 105.323 8.56852 105.368 10.5577C105.414 12.5468 105.977 13.084 105.977 13.084Z"
                                                            fill="url(#paint27_linear_621_19535)"/>
                                                        <path
                                                            d="M102.375 11.4436C102.375 11.4436 105.554 9.74964 106.225 9.37931C107.767 8.53965 109.591 11.7351 108.174 12.7343C106.977 13.5776 104.234 15.0204 104.234 15.0204L102.375 11.4436Z"
                                                            fill="url(#paint28_linear_621_19535)"/>
                                                        <path
                                                            d="M105.234 13.3372C105.303 12.2093 104.489 11.2418 103.416 11.1761C102.343 11.1105 101.417 11.9716 101.348 13.0994C101.279 14.2273 102.093 15.1948 103.166 15.2605C104.239 15.3261 105.165 14.465 105.234 13.3372Z"
                                                            fill="url(#paint29_linear_621_19535)"/>
                                                        <path
                                                            d="M129.941 41.0906C129.854 40.6671 129.44 40.3944 129.017 40.4815C128.593 40.5686 128.321 40.9825 128.408 41.4059L129.763 47.9945C129.85 48.418 130.263 48.6907 130.687 48.6036C131.11 48.5165 131.383 48.1026 131.296 47.6792L129.941 41.0906Z"
                                                            fill="url(#paint30_linear_621_19535)"/>
                                                        <path
                                                            d="M121.034 37.1026C121.844 36.3161 123.292 38.4776 124.297 41.5191C125.302 44.5606 124.143 45.985 123.069 45.369C121.994 44.7531 120.563 37.5591 121.034 37.1026Z"
                                                            fill="url(#paint31_linear_621_19535)"/>
                                                        <path
                                                            d="M119.324 6.83999C119.821 6.88032 120.534 8.11049 120.272 9.98597C120.01 11.8615 119.062 12.4261 118.759 11.9623C118.62 11.7478 119.216 10.525 119.243 9.38097C119.275 8.05181 118.781 6.79599 119.324 6.83999Z"
                                                            fill="url(#paint32_linear_621_19535)"/>
                                                        <path
                                                            d="M33.3518 4.33203H2.58504C2.11523 4.33203 1.73438 4.71289 1.73438 5.18269V5.18453C1.73438 5.65433 2.11523 6.03519 2.58504 6.03519H33.3518C33.8216 6.03519 34.2024 5.65433 34.2024 5.18453V5.18269C34.2024 4.71289 33.8216 4.33203 33.3518 4.33203Z"
                                                            fill="url(#paint33_linear_621_19535)"/>
                                                        <defs>
                                                            <linearGradient id="paint0_linear_621_19535" x1="86.5528"
                                                                            y1="65.1508" x2="87.7811" y2="72.3264"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop offset="0.04" stop-color="#654B1E"/>
                                                                <stop offset="1" stop-color="#2E1D12"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint1_linear_621_19535" x1="89.2867"
                                                                            y1="72.1864" x2="82.474" y2="93.6674"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop offset="0.04" stop-color="#654B1E"/>
                                                                <stop offset="1" stop-color="#2E1D12"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint2_linear_621_19535" x1="33.7057"
                                                                            y1="61.1391" x2="43.3507" y2="90.6903"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop offset="0.04" stop-color="#654B1E"/>
                                                                <stop offset="1" stop-color="#2E1D12"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint3_linear_621_19535" x1="39.2488"
                                                                            y1="67.2089" x2="34.6399" y2="78.6176"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#E8E8EB"/>
                                                                <stop offset="1" stop-color="#D3D3D3"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint4_linear_621_19535" x1="39.7548"
                                                                            y1="67.1377" x2="36.959" y2="72.7275"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint5_linear_621_19535" x1="132.469"
                                                                            y1="61.1391" x2="142.114" y2="90.6903"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop offset="0.04" stop-color="#654B1E"/>
                                                                <stop offset="1" stop-color="#2E1D12"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint6_linear_621_19535" x1="138.022"
                                                                            y1="67.2089" x2="133.413" y2="78.6176"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#E8E8EB"/>
                                                                <stop offset="1" stop-color="#D3D3D3"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint7_linear_621_19535" x1="138.53"
                                                                            y1="67.1377" x2="135.734" y2="72.7275"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint8_linear_621_19535" x1="16.2052"
                                                                            y1="30.3016" x2="19.7124" y2="47.06"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#AAC76F"/>
                                                                <stop offset="1" stop-color="#51823B"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint9_linear_621_19535" x1="14.2683"
                                                                            y1="11.2254" x2="25.6935" y2="37.1559"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#AAC76F"/>
                                                                <stop offset="1" stop-color="#51823B"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint10_linear_621_19535" x1="12.9001"
                                                                            y1="24.6795" x2="19.48" y2="35.9581"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#DBE8C4"/>
                                                                <stop offset="1" stop-color="#AAC76F"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint11_linear_621_19535" x1="118.705"
                                                                            y1="8.0194" x2="115.544" y2="13.1545"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#E8E8EB"/>
                                                                <stop offset="1" stop-color="#D3D3D3"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint12_linear_621_19535" x1="78.6478"
                                                                            y1="26.648" x2="70.8928" y2="63.7616"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint13_linear_621_19535" x1="92.3027"
                                                                            y1="49.2305" x2="80.7895" y2="81.5299"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint14_linear_621_19535" x1="88.4001"
                                                                            y1="45.138" x2="128.409" y2="69.7228"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint15_linear_621_19535" x1="122.743"
                                                                            y1="40.0433" x2="123.836" y2="52.4383"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint16_linear_621_19535" x1="43.8467"
                                                                            y1="43.3202" x2="39.9088" y2="72.0794"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint17_linear_621_19535" x1="56.1546"
                                                                            y1="24.2807" x2="56.8439" y2="36.4264"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop offset="0.04" stop-color="#654B1E"/>
                                                                <stop offset="1" stop-color="#2E1D12"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint18_linear_621_19535" x1="16.4109"
                                                                            y1="-2.60514" x2="19.9877" y2="11.9991"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#DBE8C4"/>
                                                                <stop offset="1" stop-color="#AAC76F"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint19_linear_621_19535" x1="16.7187"
                                                                            y1="16.6161" x2="20.3817" y2="24.4645"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#DBE8C4"/>
                                                                <stop offset="1" stop-color="#AAC76F"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint20_linear_621_19535" x1="14.7427"
                                                                            y1="19.1953" x2="22.0759" y2="30.252"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#AAC76F"/>
                                                                <stop offset="1" stop-color="#51823B"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint21_linear_621_19535" x1="17.4872"
                                                                            y1="17.3767" x2="24.8223" y2="28.4334"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#AAC76F"/>
                                                                <stop offset="1" stop-color="#51823B"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint22_linear_621_19535" x1="91.9016"
                                                                            y1="62.2742" x2="93.1519" y2="67.3598"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop offset="0.04" stop-color="#654B1E"/>
                                                                <stop offset="1" stop-color="#2E1D12"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint23_linear_621_19535" x1="61.3047"
                                                                            y1="40.6262" x2="46.4952" y2="53.5932"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint24_linear_621_19535" x1="61.8456"
                                                                            y1="41.2382" x2="47.0359" y2="54.2053"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint25_linear_621_19535" x1="62.3768"
                                                                            y1="41.8505" x2="47.5671" y2="54.8157"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint26_linear_621_19535" x1="125.621"
                                                                            y1="53.5841" x2="133.224" y2="64.6152"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#52BEB8"/>
                                                                <stop offset="1" stop-color="#308B85"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint27_linear_621_19535" x1="108.465"
                                                                            y1="9.14784" x2="107.262" y2="12.1636"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#E8E8EB"/>
                                                                <stop offset="1" stop-color="#D3D3D3"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint28_linear_621_19535" x1="105.042"
                                                                            y1="10.2135" x2="106.652" y2="13.7848"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop offset="0.04" stop-color="#654B1E"/>
                                                                <stop offset="1" stop-color="#2E1D12"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint29_linear_621_19535" x1="101.031"
                                                                            y1="15.7703" x2="104.713" y2="11.6068"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop offset="0.04" stop-color="#654B1E"/>
                                                                <stop offset="1" stop-color="#2E1D12"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint30_linear_621_19535" x1="131.133"
                                                                            y1="42.3918" x2="129.398" y2="46.9703"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop offset="0.04" stop-color="#654B1E"/>
                                                                <stop offset="1" stop-color="#2E1D12"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint31_linear_621_19535" x1="123.18"
                                                                            y1="39.7073" x2="121.526" y2="44.4102"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#E8E8EB"/>
                                                                <stop offset="1" stop-color="#D3D3D3"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint32_linear_621_19535" x1="122.345"
                                                                            y1="5.22117" x2="117.9" y2="11.3866"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="white"/>
                                                                <stop offset="1" stop-color="#DDF1F3"/>
                                                            </linearGradient>
                                                            <linearGradient id="paint33_linear_621_19535" x1="17.3762"
                                                                            y1="3.05787" x2="20.2802" y2="13.4876"
                                                                            gradientUnits="userSpaceOnUse">
                                                                <stop stop-color="#AAC76F"/>
                                                                <stop offset="1" stop-color="#51823B"/>
                                                            </linearGradient>
                                                        </defs>
                                                    </svg>

                                                </span>
                                            </div>
                                            <div class="invoice_txt">
                                                <p>{{__('translate.The delivery man is on the way with your food')}}.</p>
                                            </div>
                                        </div>


                                        <ul class="invoice_track_order">
                                            <li class="active">
                                                {{__('translate.Order Place')}}

                                                <span class="icon">
                                                    <i class="fa-solid fa-check"></i>
                                                </span>
                                            </li>


                                            @if ($order->order_status != 6)
                                                <li class="{{ $order->order_status >= 2 ? 'active' : '' }}">
                                                    {{__('translate. Order Accept')}}
                                                    <span class="icon">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                </li>
                                                <li class="{{ $order->order_status >= 3 ? 'active' : '' }}">
                                                    {{__('translate.Processing')}}
                                                    <span class="icon">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                </li>
                                                <li class="{{ $order->order_status >= 4 ? 'active' : '' }}">
                                                    {{__('translate.On its way!')}}
                                                    <span class="icon">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                </li>
                                                <li class="{{ $order->order_status >= 5 ? 'active' : '' }}">
                                                    {{__('translate.Delivered')}}
                                                    <span class="icon">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                </li>
                                            @else

                                            <li class="active">
                                                {{__('translate.Order Cancel')}}
                                                <span class="icon">
                                                    <i class="fa-solid fa-check"></i>
                                                </span>
                                            </li>

                                                <li class="">
                                                    {{__('translate. Order Accept')}}
                                                    <span class="icon">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                </li>
                                                <li class="">
                                                    {{__('translate.Processing')}}
                                                    <span class="icon">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                </li>
                                                <li class="">
                                                    {{__('translate.On its way!')}}
                                                    <span class="icon">
                                                        <i class="fa-solid fa-check"></i>
                                                    </span>
                                                </li>

                                            @endif

                                        </ul>


                                    </div>
                                </div>
                            </div>


                            <ul class="invoice_address">
                                <li>{{__('translate.Order ID')}}: <span>{{$order->id}}</span></li>
                                @if($order->order_type == 'delivery')
                                    <li>{{__('translate.Billing Address')}}:
                                        <span>{{$order?->address?->address ?? __('Address not found')}}</span></li>
                                    @if($order?->address)
                                        <li>{{__('translate.Type')}}: <span> {{$order->address->delivery_type}}</span></li>
                                    @endif
                                @else
                                    <li>{{__('translate.Order Type')}}: <span>{{ucfirst($order->order_type)}}</span></li>
                                @endif
                            </ul>


                            <div class="dashboard_order_details_tabel">
                                <table class=" tabel">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>{{__('translate.Image')}}</th>
                                        <th>{{__('translate.Name')}}</th>
                                        <th>{{__('translate.Size')}}</th>
                                        <th>{{__('translate.Addons')}}</th>
                                        <th>{{__('translate.Qty')}}</th>
                                        <th>{{__('translate.Price')}}</th>
                                        <th >{{__('translate.Review')}}</th>
                                    </tr>
                                    </thead>

                                    <tbody>
                                    @php
                                        $total = 0;
                                        $calculate = 0;
                                    @endphp
                                    @foreach($order->items ?? [] as $key => $order_item)
                                        @php
                                            $product = Modules\Product\App\Models\Product::where('status', 'enable')->whereIn('id', [$order_item['product_id']])->first();
                                            $total += $order_item->total;
                                        @endphp
                                        <tr>
                                            <td>#{{$key + 1}}</td>
                                            <td>
                                                <div class="td_thumb">
                                                    <img
                                                        src="{{asset($product->image)}}"
                                                        alt="">
                                                </div>
                                            </td>
                                            <td>

                                                <div class="td_a">
                                                    <a href="javascript:;">{{$product->name}}</a>
                                                </div>

                                            </td>

                                            <td>

                                                <div class="td_size">
                                                    <p>
                                                        @foreach (json_decode($order_item['size']) as $size => $price)
                                                            {{ $size }} (<strong>{{currency( $price) }}</strong>)
                                                        @endforeach</p>
                                                </div>

                                            </td>
                                            <td>

                                                <div class="td_addons">
                                                    @foreach (json_decode($order_item['addons']) as $addonId => $quantity)
                                                        @php
                                                            $addonsDb = Modules\Addon\App\Models\Addon::whereIn('id', [$addonId])->get();
                                                            $calculate += ($addonsDb->first()->price * $quantity);
                                                        @endphp
                                                        @if ($addonsDb->isNotEmpty())
                                                            {{ $addonsDb->first()->name }} <p>
                                                                ({{ currency($addonsDb->first()->price) }}
                                                                * {{ $quantity }})</p>
                                                        @endif

                                                    @endforeach
                                                </div>

                                            </td>
                                            <td>

                                                <div class="td_qty">
                                                    <p>x{{$order_item->qty}}</p>
                                                </div>

                                            </td>
                                            <td>

                                                <div class="td_price">
                                                    <p>{{currency($order_item->total)}}</p>
                                                </div>

                                            </td>

                                            <td>
                                                @if ($order->order_status == 5)


                                                @php
                                                    $review = App\Models\Review::where('product_id', $product->id)->where('order_id', $order->id)->where('user_id', Auth::user()->id)->first()
                                                @endphp
                                                @if(!$review)
                                                    <a class="thm-btn cursor-pointer" data-bs-toggle="modal" data-bs-target="#popularModal-{{$key}}">{{ __('translate.Review') }}</a>
                                                @else
                                                    <p>{{ __('translate.Review submitted') }}</p>
                                                @endif
                                                <!--food_card_modal-->
                                                <div class="modal food_card_modal fade" id="popularModal-{{$key}}" tabindex="-1"
                                                    aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content review_modal">
                                                            <div class="modal-header">
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                                                        aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <div class="modal_body_thumb">
                                                                    <img src="{{asset($product->image)}}"
                                                                        alt="thumb">
                                                                </div>

                                                                <div class="modal_body_inner ">
                                                                    <div class="modal_body_top_txt">
                                                                        <div class="modal_body_top_txt_df">
                                                                            <h4>{{$product->translate_product?->name}}</h4>
                                                                        </div>

                                                                        <p>{{$product->translate_product?->short_description}}</p>
                                                                    </div>
                                                                    <form action="{{route('user.review-submit', ['food_id' => $product->id])}}" method="post">
                                                                        @csrf


                                                                        <h3 class="mt-3 mb-3">{{ __('translate.Submit Review') }}</h3>

                                                                        <div id="full-stars-example-{{ $key }}" class="mt-3">
                                                                            <div class="rating-group">
                                                                                <input disabled checked class="rating__input rating__input--none" name="rating" id="rating{{ $key }}-none" value="1" type="radio">
                                                                                <label aria-label="1 star" class="rating__label" for="rating{{ $key }}-none">
                                                                                    <i class="rating__icon rating__icon--star fa fa-star"></i>
                                                                                </label>

                                                                                <input class="rating__input" name="rating" id="rating{{ $key }}-1" value="2" type="radio">
                                                                                <label aria-label="2 stars" class="rating__label" for="rating{{ $key }}-1">
                                                                                    <i class="rating__icon rating__icon--star fa fa-star"></i>
                                                                                </label>

                                                                                <input class="rating__input" name="rating" id="rating{{ $key }}-2" value="3" type="radio">
                                                                                <label aria-label="3 stars" class="rating__label" for="rating{{ $key }}-2">
                                                                                    <i class="rating__icon rating__icon--star fa fa-star"></i>
                                                                                </label>

                                                                                <input class="rating__input" name="rating" id="rating{{ $key }}-3" value="4" type="radio">
                                                                                <label aria-label="4 stars" class="rating__label" for="rating{{ $key }}-3">
                                                                                    <i class="rating__icon rating__icon--star fa fa-star"></i>
                                                                                </label>

                                                                                <input class="rating__input" name="rating" id="rating{{ $key }}-4" value="5" type="radio">
                                                                                <label aria-label="5 stars" class="rating__label" for="rating{{ $key }}-4">
                                                                                    <i class="rating__icon rating__icon--star fa fa-star"></i>
                                                                                </label>
                                                                            </div>
                                                                        </div>

                                                                        <input type="hidden" name="order_id" value="{{ $order->id }}">
                                                                        <input type="hidden" name="restaurant_id" value="{{ $product?->restaurant->id }}">
                                                                        <div class="from-inner-two  pb-4 mt-3">
                                                                            <textarea class="form-control" name="review" id="reviewText"
                                                                                rows="5" placeholder="{{ __('translate.Write Review') }} *" required></textarea>
                                                                        </div>

                                                                        <button class="thm-btn">{{ __('translate.Submit') }}</button>

                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                            </td>

                                        </tr>
                                    @endforeach
                                    </tbody>


                                </table>
                            </div>


                            <div class="row justify-content-end mt_30px">
                                <div class="col-xxl-4">

                                    <div class="dashboard_order_details_tabel_btm">
                                        <table class=" tabel">


                                            <tbody>
                                            <tr>
                                                <td>

                                                    <div class="td_qty">
                                                        <p>{{__('translate.Total')}}</p>
                                                    </div>

                                                </td>
                                                <td>

                                                    <div class="td_price">
                                                        <p>{{currency($total)}}</p>
                                                    </div>

                                                </td>
                                            </tr>
                                            <tr>
                                                <td>

                                                    <div class="td_qty">
                                                        <p>{{__('translate.Discount')}}</p>
                                                    </div>

                                                </td>
                                                <td>

                                                    <div class="td_price">
                                                        <p>-{{currency($order->discount_amount)}}</p>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>

                                                    <div class="td_qty">
                                                        <p>{{__('translate.Shipping')}} </p>
                                                    </div>

                                                </td>
                                                <td>

                                                    <div class="td_price">
                                                        <p>{{currency($order->delivery_charge)}}</p>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>

                                                    <div class="td_qty">
                                                        <p>{{__('translate.Vat Tax')}} </p>
                                                    </div>

                                                </td>
                                                <td>

                                                    <div class="td_price">
                                                        <p>{{currency($order->vat)}}</p>
                                                    </div>
                                                </td>
                                            </tr>
                                            <tr>
                                                <td>

                                                    <div class="td_qty">
                                                        <p>{{__('translate.Grand total')}} </p>
                                                    </div>

                                                </td>
                                                <td>

                                                    <div class="td_price">
                                                        <p>{{currency($order->grand_total)}} </p>
                                                    </div>
                                                </td>
                                            </tr>
                                            </tbody>


                                        </table>
                                    </div>

                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- dashboard part end -->
    </main>
@endsection
