<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Withdraw Detail')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-header'); ?>
    <h3 class="crancy-header__title m-0"><?php echo e(__('translate.Withdraw Detail')); ?></h3>
    <p class="crancy-header__text"><?php echo e(__('translate.Manage Withdraw')); ?> >> <?php echo e(__('translate.Withdraw Detail')); ?></p>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-content'); ?>
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <div class="crancy-dsinner">

                            <div class="crancy-table crancy-table--v3 mg-top-30">

                                <div class="crancy-customer-filter">
                                    <div class="crancy-customer-filter__single crancy-customer-filter__single--csearch d-flex items-center justify-between create_new_btn_box">
                                        <div class="crancy-header__form crancy-header__form--customer create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title"><?php echo e(__('translate.Withdraw Detail')); ?></h4>

                                        </div>
                                    </div>
                                </div>

                                <!-- crancy Table -->
                                <div id="crancy-table__main_wrapper" class=" dt-bootstrap5 no-footer">

                                    <table class="crancy-table__main crancy-table__main-v3 no-footer">

                                        <!-- crancy Table Body -->
                                        <tbody class="crancy-table__body review-detials">


                                            <tr class="odd">
                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(__('translate.Delivery Man')); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><a href="<?php echo e(route('admin.deliveryman-show', $withdraw->deliveryman_id)); ?>"><?php echo e($withdraw?->deliveryman?->fname); ?></a></h4>
                                                </td>
                                            </tr>


                                            <tr class="odd">
                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(__('translate.Total Amount')); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(currency($withdraw->total_amount)); ?></h4>
                                                </td>
                                            </tr>

                                            <tr class="odd">
                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(__('translate.Withdraw Amount')); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(currency($withdraw->withdraw_amount)); ?></h4>
                                                </td>
                                            </tr>

                                            <tr class="odd">
                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(__('translate.Withdraw Charge')); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(currency($withdraw->charge_amount)); ?></h4>
                                                </td>
                                            </tr>

                                            <tr class="odd">
                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(__('translate.Crated at')); ?></h4>
                                                </td>


                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">
                                                        <?php echo e($withdraw->created_at->format('d F Y')); ?>

                                                    </h4>
                                                </td>

                                            </tr>

                                            <tr class="odd">
                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(__('translate.Withdraw Method')); ?></h4>
                                                </td>


                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">
                                                        <?php echo e($withdraw->withdraw_method_name); ?>

                                                    </h4>
                                                </td>

                                            </tr>


                                            <tr class="odd">
                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(__('translate.Bank/Account Info')); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo clean(nl2br(html_decode($withdraw->description))); ?></h4>
                                                </td>
                                            </tr>

                                            <tr class="odd">
                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(__('translate.Status')); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <?php if($withdraw->status == 'approved'): ?>
                                                            <span class="badge bg-success text-white"><?php echo e(__('translate.Approved')); ?></span>
                                                        <?php elseif($withdraw->status == 'rejected'): ?>
                                                            <span class="badge bg-danger text-white"><?php echo e(__('translate.Rejected')); ?></span>
                                                        <?php else: ?>
                                                            <span class="badge bg-danger text-white"><?php echo e(__('translate.Pending')); ?></span>
                                                        <?php endif; ?>
                                                </td>
                                            </tr>





                                            <tr class="odd">

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e(__('translate.Action')); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">



                                                    <?php if($withdraw->status == 'pending'): ?>
                                                    <a href="javascript:;" data-bs-toggle="modal" data-bs-target="#reviewApproval" class="crancy-btn approval_button"><i class="fas fa-check"></i> <?php echo e(__('translate.Make Approval')); ?></a>

                                                    <a href="javascript:;" data-bs-toggle="modal" data-bs-target="#reviewRejected" class="crancy-btn"><i class="fas fa-check"></i> <?php echo e(__('translate.Make Reject')); ?></a>
                                                    <?php endif; ?>

                                                    <a onclick="itemDeleteConfrimation(<?php echo e($withdraw->id); ?>)" href="javascript:;" data-bs-toggle="modal" data-bs-target="#exampleModal" class="crancy-btn delete_danger_btn"><i class="fas fa-trash"></i> <?php echo e(__('translate.Delete')); ?></a>


                                                </td>
                                            </tr>


                                        </tbody>
                                        <!-- End crancy Table Body -->
                                    </table>
                                </div>
                                <!-- End crancy Table -->
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->


    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('translate.Delete Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you realy want to delete this item?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="<?php echo e(route('admin.deliveryman-withdraw-list.destroy', $withdraw->id)); ?>" id="item_delect_confirmation" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>

                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary btn-type-dlt"><?php echo e(__('translate.Yes, Delete')); ?></button>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Approval Confirmation Modal -->
    <div class="modal fade" id="reviewApproval" tabindex="-1" aria-labelledby="reviewApprovalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="reviewApprovalLabel"><?php echo e(__('translate.Approval Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you realy want to approved this withdraw?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="<?php echo e(route('admin.deliveryman-withdraw-approval', $withdraw->id)); ?>" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>

                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Yes, Approved')); ?></button>

                    </form>
                </div>
            </div>
        </div>
    </div>


    <!-- Approval Confirmation Modal -->
    <div class="modal fade" id="reviewRejected" tabindex="-1" aria-labelledby="reviewRejectedLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="reviewRejectedLabel"><?php echo e(__('translate.Rejected Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you realy want to rejected this withdraw?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="<?php echo e(route('admin.deliveryman-withdraw-rejected', $withdraw->id)); ?>" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>

                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Yes, Rejected')); ?></button>

                    </form>
                </div>
            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>



<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\foodkhabo\Modules/PaymentWithdraw\resources/views/deliveryman/show.blade.php ENDPATH**/ ?>