<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Order Details')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-header'); ?>
    <h3 class="crancy-header__title m-0"><?php echo e(__('translate.Order Details')); ?></h3>
    <p class="crancy-header__text"><?php echo e(__('translate.Manage Order')); ?> >> <?php echo e(__('translate.Order Details')); ?></p>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-content'); ?>

    <section class="crancy-adashboard crancy-show mt-5">
        <div class="zum_icvoice">
            <div class="container container__bscreen">
                <div class="crancy-product-card">
                    <div class="create_new_btn_inline_box mb-4">
                        <h4 class="crancy-product-card__title"><?php echo e(__('translate.Order Details')); ?></h4>

                        <a href="<?php echo e(route('admin.order.index')); ?>" class="crancy-btn "><i
                                class="fa fa-list"></i> <?php echo e(__('translate.Order List')); ?></a>
                    </div>

                    <div class="row mb-5">
                        <div class="col-lg-4 col-md-6">
                            <div class="zum_icvoice_item_main">

                                <?php
                                    $address = json_decode($order->delivery_address);
                                ?>

                                <?php if($order->order_type == 'delivery'): ?>
                                    <div class="zum_invoice_text">
                                        <h2><?php echo e(__('translate.Billing Address')); ?></h2>
                                    </div>
                                    <div class="zum_icvoice_item">
                                        <ul class="zum_invoice_lixt  d-flex flex-column gap-3">
                                            <li><?php echo e(__('translate.Full Name')); ?> : <span><?php echo e($address->contact_person_name ?? ''); ?></span></li>
                                            <li>
                                                <a href="mailto:<?php echo e($address->contact_person_email ?? ''); ?> ">
                                                    <?php echo e(__('translate.Email')); ?> : <span> <?php echo e($address->contact_person_email ?? ''); ?> </span>
                                                </a>
                                            </li>
                                            <li>
                                                <a href="tel:<?php echo e($address->contact_person_number ?? ''); ?>">
                                                    <?php echo e(__('translate.Phone')); ?> : <span> <?php echo e($address->contact_person_number ?? ''); ?></span>
                                                </a>
                                            </li>
                                            <li>
                                                <?php echo e(__('translate.Address')); ?> : <span> <?php echo e($address->address ?? ''); ?> </span>
                                            </li>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                                <div class="zum_icvoice_item">
                                    <h2><?php echo e(__('translate.Payment Information')); ?>:</h2>
                                    <ul class="zum_invoice_lixt  d-flex flex-column gap-3">
                                        <li><?php echo e(__('translate.Method')); ?> : <span><?php echo e($order->payment_method); ?></span></li>
                                        <li>
                                            <?php if($order->payment_status == 'success'): ?>
                                                <a href="javascript:;">
                                                    <?php echo e(__('translate.State')); ?> :<span class="badge bg-success text-white"><?php echo e($order->payment_status); ?></span>
                                                </a>
                                            <?php else: ?>
                                                <a href="javascript:;">
                                                    <?php echo e(__('translate.State')); ?> :<span
                                                        class="badge bg-danger text-white"><?php echo e($order->payment_status); ?></span>
                                                </a>
                                            <?php endif; ?>
                                        </li>
                                        <li>
                                            <?php echo e(__('translate.Transaction')); ?> :<span> <?php echo clean(nl2br($order->tnx_info)); ?></span>
                                        </li>

                                    </ul>
                                </div>

                            </div>

                            <?php if($order->order_type == 'pickup'): ?>
                                <p><strong><?php echo e(__('translate.Contact person name')); ?> : </strong> <?php echo e($address->contact_person_name ?? ''); ?></p>
                                <p><strong><?php echo e(__('translate.Contact person phone')); ?> : </strong> <?php echo e($address->contact_person_number ?? ''); ?></p>
                                <p><strong><?php echo e(__('translate.Contact person email')); ?> : </strong> <?php echo e($address->contact_person_email ?? ''); ?></p>
                            <?php endif; ?>



                            <?php if($order->deliveryman): ?>
                                <div class="row">
                                    <div class="col-md-12">
                                        <address class="zum_icvoice_item_main p-3">
                                            <strong><?php echo e(__('translate.Delivery Man Information')); ?>:</strong><br>
                                            <div class="zum_invoice_lixt">
                                                <?php echo e(__('translate.Name')); ?>: <?php echo e($order->deliveryman->fname); ?> <?php echo e($order->deliveryman->lname); ?><br>
                                                <?php echo e(__('translate.Status')); ?> :
                                                <span class="tag <?php echo e($order->order_request == 1 ? 'success' : ($order->order_request == 2 ? 'warning' : 'danger')); ?>">
                                                    <?php echo e($order->order_request == 1 ? __('Accepted') : ($order->order_request == 2 ? __('Ignored') : __('No response'))); ?>

                                                </span>
                                            </div>
                                        </address>
                                    </div>
                                </div>
                            <?php endif; ?>

                        </div>
                        <div class="col-lg-4 col-md-6">
                            <div class="zum_icvoice_item_main">
                                <?php if($order->order_type == 'delivery'): ?>
                                    <div class="zum_invoice_text ">
                                        <h2><?php echo e(__('translate.Shipping Information')); ?></h2>


                                    </div>
                                    <div class="zum_icvoice_item  d-flex flex-column gap-3">
                                        <ul class="zum_invoice_lixt  d-flex flex-column gap-3">
                                            <li><?php echo e(__('translate.Full Name')); ?> : <span><?php echo e($address->contact_person_name ?? ''); ?></span></li>
                                            <li>
                                                <a href="mailto:<?php echo e($address->contact_person_email ?? ''); ?>">
                                                    <?php echo e(__('translate.Email')); ?> : <span> <?php echo e($address->contact_person_email ?? ''); ?></span>
                                                </a>
                                            </li>
                                            <li>
                                                <a href="tel:<?php echo e($address->contact_person_number ?? ''); ?>">
                                                    <?php echo e(__('translate.Phone')); ?> : <span> <?php echo e($address->contact_person_number ?? ''); ?> </span>
                                                </a>
                                            </li>
                                            <li>
                                                <?php echo e(__('translate.Address')); ?> : <span><?php echo e($address->address ?? ''); ?></span>
                                            </li>
                                        </ul>
                                    </div>
                                <?php endif; ?>
                                <div class="zum_icvoice_item">
                                    <h2><?php echo e(__('translate.Order Information')); ?>:</h2>
                                    <ul class="zum_invoice_lixt d-flex flex-column gap-3">
                                        <li><?php echo e(__('translate.Date')); ?> : <span><?php echo e($order->created_at->format('F j, Y')); ?></span></li>

                                        <li>
                                            <?php echo e(__('translate.Shipping')); ?> : <span> <?php echo e(__('translate.Fixed Shipping')); ?></span>
                                        </li>

                                        <li>
                                            <a href="javascript:;">
                                                <?php if($order->order_status == 1): ?>
                                                    <?php echo e(__('translate.State')); ?> : <span class="badge bg-warning text-white"><?php echo e(__('translate.Pending')); ?></span>
                                                <?php elseif($order->order_status == 2): ?>
                                                    <?php echo e(__('translate.State')); ?> : <span
                                                        class="badge bg-success text-white"><?php echo e(__('translate.Confirmed')); ?></span>
                                                <?php elseif($order->order_status == 3): ?>
                                                    <?php echo e(__('translate.State')); ?> : <span
                                                        class="badge bg-warning text-white"><?php echo e(__('translate.Processing')); ?></span>
                                                <?php elseif($order->order_status == 4): ?>
                                                    <?php echo e(__('translate.State')); ?> : <span
                                                        class="badge bg-inprocees text-white"><?php echo e(__('translate.Food on the way')); ?></span>
                                                <?php elseif($order->order_status == 5): ?>
                                                    <?php echo e(__('translate.State')); ?> : <span
                                                        class="badge bg-success text-white"><?php echo e(__('translate.Delivered')); ?></span>
                                                <?php elseif($order->order_status == 6): ?>
                                                    <?php echo e(__('translate.State')); ?> : <span
                                                        class="badge bg-warning text-white"><?php echo e(__('translate.Cancel')); ?></span>
                                                <?php endif; ?>
                                            </a>
                                        </li>

                                    </ul>
                                </div>

                            </div>
                        </div>

                        <div class="col-lg-4 col-md-6">
                            <div class="order_status_box">
                                <form class="order_status" ac>
                                    <div class="order_status_item">
                                        <div class="order_status_inner">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('translate.Payment status')); ?></label>
                                            <select class="form-select" aria-label="Default select example" onchange="showPaymentConfirmationModal(<?php echo e($order->id); ?>, this.value)">
                                                <?php if($order->payment_status == 'pending'): ?>
                                                <option value="pending" <?php echo e($order->payment_status == 'pending' ? 'selected' : ''); ?>><?php echo e(__('translate.Pending')); ?></option>
                                                <option value="success" <?php echo e($order->payment_status == 'success' ? 'selected' : ''); ?>><?php echo e(__('translate.Success')); ?></option>
                                                <?php elseif($order->payment_status == 'success'): ?>
                                                    <option value="success" <?php echo e($order->payment_status == 'success' ? 'selected' : ''); ?>><?php echo e(__('translate.Success')); ?></option>
                                                <?php else: ?>
                                                    <option><?php echo e(ucfirst($order->payment_status)); ?></option>
                                                <?php endif; ?>
                                            </select>



                                        </div>
                                    </div>
                                    <div class="order_status_item">
                                        <div class="order_status_inner">
                                            <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('translate.Order status')); ?></label>
                                            <select class="form-select" aria-label="Default select example"  onchange="showConfirmationModal(<?php echo e($order->id); ?>, this.value)" name="order_status"
                                                    name="order_status">
                                                <option value="1" <?php echo e($order->order_status == 1 ? 'selected' : ''); ?>><?php echo e(__('translate.Pending')); ?></option>
                                                <option value="6" <?php echo e($order->order_status == 6 ? 'selected' : ''); ?>><?php echo e(__('translate.Cancel')); ?></option>
                                                <option value="2" <?php echo e($order->order_status == 2 ? 'selected' : ''); ?>><?php echo e(__('translate.Confirmed')); ?></option>
                                                <option value="3" <?php echo e($order->order_status == 3 ? 'selected' : ''); ?>><?php echo e(__('translate.Processing')); ?></option>
                                                <option value="4" <?php echo e($order->order_status == 4 ? 'selected' : ''); ?>><?php echo e(__('translate.Food On The Way')); ?></option>
                                                <option value="5" <?php echo e($order->order_status == 5 ? 'selected' : ''); ?>><?php echo e(__('translate.Delivered')); ?></option>
                                            </select>

                                        </div>
                                    </div>

                                    <?php if($order->delivery_man_id == 0): ?>
                                        <div class="order_status_item">
                                            <div class="order_status_inner">
                                                <div class="form-group">
                                                    <label for="exampleFormControlInput1" class="form-label"><?php echo e(__('translate.Assign Delivery Man')); ?></label>
                                                    <select name="delivery_man_id" id="" class="form-control select2" onchange="showDeliveryManModal(<?php echo e($order->id); ?>, this.value)">
                                                        <option value="0" <?php echo e($order->delivery_man_id == 0 ? 'selected' : ''); ?>>Select</option>
                                                        <?php $__currentLoopData = $deliverymans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deliveryman): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($deliveryman->id); ?>" <?php echo e($order->delivery_man_id == $deliveryman->id ? 'selected' : ''); ?>><?php echo e($deliveryman->fname); ?> <?php echo e($deliveryman->lname); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>

                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </form>
                            </div>

                        </div>
                    </div>


                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tabel_main mb-3 overflow-x-auto">
                                <table class="crancy-table__main crancy-table__main-v3">
                                    <thead>
                                    <tr>
                                        <th>#</th>
                                        <th><?php echo e(__('translate.Product')); ?></th>
                                        <th><?php echo e(__('translate.Variant')); ?></th>
                                        <th><?php echo e(__('translate.Restaurant')); ?></th>
                                        <th><?php echo e(__('translate.Unit Price')); ?></th>
                                        <th><?php echo e(__('translate.Quantity')); ?></th>
                                        <th><?php echo e(__('translate.Total')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php
                                        $total = 0;
                                        $calculate = 0;
                                    ?>
                                    <?php $__currentLoopData = $order->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $order_item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $product = Modules\Product\App\Models\Product::where('status', 'enable')->whereIn('id', [$order_item['product_id']])->first();
                                            $total += $order_item->total;
                                        ?>
                                        <tr>
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><a target="_blank" href="<?php echo e(route('admin.product.edit', ['product' => $product->id, 'lang_code' => admin_lang()] )); ?>"><?php echo e($product->name); ?></a></td>
                                            <td>
                                                <div class="tabel_modal_main">
                                                    <?php $__currentLoopData = json_decode($order_item['size']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size => $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php echo e(__('translate.Size')); ?> : <?php echo e($size); ?>

                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if(json_decode($order_item['addons'])): ?>
                                                    <span data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo e($key); ?>">
                                                        <?php echo e(__('translate.See more')); ?>

                                                    </span>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                            <td>
                                                <?php echo e($order?->restaurant?->restaurant_name); ?>

                                            </td>
                                            <td>
                                                <?php $__currentLoopData = json_decode($order_item['size']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $size => $price): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                  <?php echo e((currency($price))); ?>

                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </td>
                                            <td><?php echo e($order_item->qty); ?></td>
                                            <td><?php echo e(currency($order_item->total)); ?></td>
                                        </tr>

                                        <!-- Modal 2 -->
                                        <div class="modal adon_modal_main fade" id="exampleModal<?php echo e($key); ?>" tabindex="-1" aria-labelledby="exampleModalLabel"
                                             aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('translate.See Addon')); ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <ul class="modal_adon">
                                                            <?php $__currentLoopData = json_decode($order_item['addons']); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $addonId => $quantity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <?php
                                                                    $addonsDb = Modules\Addon\App\Models\Addon::whereIn('id', [$addonId])->get();
                                                                    $calculate += ($addonsDb->first()->price * $quantity);
                                                                ?>
                                                                <?php if($addonsDb->isNotEmpty()): ?>
                                                                    <li> <?php echo e($addonsDb->first()->name); ?>

                                                                        (<?php echo e(currency($addonsDb->first()->price)); ?>

                                                                        * <?php echo e($quantity); ?>)</li>
                                                                <?php endif; ?>

                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </ul>
                                                    </div>
                                                    <div class="modal_btn_main">
                                                        <button type="button" data-bs-dismiss="modal" aria-label="Close" class="modal_btn"><?php echo e(__('translate.Close')); ?></button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="tabel_btm">
                                <ul class="tabel_btm_list">
                                    <li><span><?php echo e(__('translate.Subtotal')); ?> : </span><?php echo e(currency($total)); ?></li>
                                    <li><span><?php echo e(__('translate.Discount')); ?> (-) </span>: <?php echo e(currency($order->discount_amount)); ?></li>
                                    <li><span><?php echo e(__('translate.Delivery Charge')); ?> :</span> <?php echo e(currency($order->delivery_charge)); ?></li>
                                    <li><?php echo e(__('translate.Total')); ?> : <?php echo e(currency($order->grand_total)); ?></li>
                                </ul>

                                <div class="tabel_btm_btn_main">

                                    <a onclick="itemDeleteConfrimation(<?php echo e($order->id); ?>)" href="javascript:;" data-bs-toggle="modal" data-bs-target="#deleteModal" class="crancy-btn delete_danger_btn"><i class="fas fa-trash"></i> <?php echo e(__('translate.Delete')); ?></a>




                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>




    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('translate.Delete Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you realy want to delete this item?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="" id="item_delect_confirmation" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>

                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary btn-type-dlt"><?php echo e(__('translate.Yes, Delete')); ?></button>

                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal -->
    <div class="modal fade" id="deleteModal1" tabindex="-1" aria-labelledby="exampleModalLabel1" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel1"><?php echo e(__('translate.Status Change Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you sure you want to change the status of this item?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="" id="item_delect_confirmation1" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Yes, Change')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div class="modal fade" id="paymentConfirmationModal" tabindex="-1" aria-labelledby="paymentModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="paymentModalLabel"><?php echo e(__('translate.Payment Status Change Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you sure you want to change the payment status of this order?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="" id="paymentConfirmationForm" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="payment_status" id="newPaymentStatus">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Yes, Change')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Confirmation Modal -->
    <div class="modal fade" id="showDeliveryManModal" tabindex="-1" aria-labelledby="showDeliveryManModal" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="paymentModalLabel"><?php echo e(__('translate.Status Change Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you sure you want to deliver this order to this delivery man?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="" id="showDeliveryManForm" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="delivery_man_id" id="newDelivery_id">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Yes, Change')); ?></button>
                    </form>
                </div>
            </div>
        </div>
    </div>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('js_section'); ?>

    <script>

        "use strict"
        function itemDeleteConfrimation(id){
            $("#item_delect_confirmation").attr("action",'<?php echo e(url("admin/order-delete/")); ?>'+"/"+id)
        }

        function showConfirmationModal(orderId, selectedValue) {

            $("#item_delect_confirmation1").attr("action", '<?php echo e(url("admin/order-status-change/")); ?>' + "/" + orderId);

            $('<input>').attr({
                type: 'hidden',
                name: 'order_status',
                value: selectedValue
            }).appendTo('#item_delect_confirmation1');

            $('#deleteModal1').modal('show');
        }

        function showPaymentConfirmationModal(orderId, selectedValue) {
            $("#paymentConfirmationForm").attr("action", '<?php echo e(url("admin/payment-status-change/")); ?>' + "/" + orderId);

            $("#newPaymentStatus").val(selectedValue);

            $('#paymentConfirmationModal').modal('show');
        }

        function showDeliveryManModal(orderId, selectedValue) {
            $("#showDeliveryManForm").attr("action", '<?php echo e(url("admin/deliveryman/")); ?>' + "/" + orderId);

            $("#newDelivery_id").val(selectedValue);

            $('#showDeliveryManModal').modal('show');
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\foodkhabo\Modules/Order\resources/views/details.blade.php ENDPATH**/ ?>