<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Offer Product')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-header'); ?>
    <h3 class="crancy-header__title m-0"><?php echo e(__('translate.Offer Product')); ?></h3>
    <p class="crancy-header__text"><?php echo e(__('translate.Offer Product')); ?> >> <?php echo e(__('translate.Offer Product')); ?></p>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-content'); ?>
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <!-- Dashboard Inner -->
                        <div class="crancy-dsinner">
                            <form action="<?php echo e(route('admin.store-offer-product')); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-12 mg-top-30">
                                        <!-- Product Card -->
                                        <div class="crancy-product-card">
                                            <div class="create_new_btn_inline_box">
                                                <h4 class="crancy-product-card__title"><?php echo e(__('translate.Offer Product')); ?></h4>
                                            </div>

                                            <div class="row">
                                                <div class="col-12">
                                                    <div class="crancy__item-form--group mg-top-form-20">
                                                        <label class="crancy__item-label"><?php echo e(__('translate.Product')); ?>

                                                            * </label>
                                                        <select class="form-select crancy__item-input select2"
                                                                name="product_id" required>
                                                            <option value=""><?php echo e(__('translate.Select Product')); ?></option>
                                                            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <option
                                                                    <?php echo e($product->id == old('product') ? 'selected' : ''); ?> value="<?php echo e($product->id); ?>"><?php echo e($product->name); ?></option>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                        </select>
                                                    </div>
                                                </div>


                                            </div>

                                            <button class="crancy-btn mg-top-25" type="submit"><?php echo e(__('translate.Save')); ?></button>

                                        </div>
                                        <!-- End Product Card -->
                                    </div>
                                </div>
                            </form>
                        </div>
                        <!-- End Dashboard Inner -->
                    </div>
                </div>

            </div>


            <div class="crancy-product-card mt-5">
                <div id="crancy-table__main_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">

                    <table class="crancy-table__main crancy-table__main-v3 dataTable no-footer" id="dataTable">
                        <!-- crancy Table Head -->
                        <thead class="crancy-table__head">
                            <tr>

                                <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                    <?php echo e(__('translate.Serial')); ?>

                                </th>

                                <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                    <?php echo e(__('translate.Product')); ?>

                                </th>

                                <th class="crancy-table__column-3 crancy-table__h3 sorting">
                                    <?php echo e(__('translate.Action')); ?>

                                </th>

                            </tr>
                        </thead>
                        <!-- crancy Table Body -->
                        <tbody class="crancy-table__body">
                            <?php $__currentLoopData = $offer_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $offer_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                <tr class="odd">

                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                        <h4 class="crancy-table__product-title"><?php echo e(++$index); ?></h4>
                                    </td>

                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                        <?php echo e($offer_product?->product->name); ?>

                                    </td>


                                    <td class="crancy-table__column-2 crancy-table__data-2">
                                        <a onclick="itemDeleteConfrimation(<?php echo e($offer_product->id); ?>, <?php echo e($index); ?>)" href="javascript:;" data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo e($index); ?>" class="crancy-btn delete_danger_btn"><i class="fas fa-trash"></i> <?php echo e(__('translate.Delete')); ?></a>
                                    </td>
                                </tr>

                                  <!-- Delete Confirmation Modal -->
                                <div class="modal fade" id="exampleModal<?php echo e($index); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('translate.Delete Confirmation')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p><?php echo e(__('translate.Are you realy want to delete this item?')); ?></p>
                                            </div>
                                            <div class="modal-footer">
                                                <form action="" id="item_delete_confirmation<?php echo e($index); ?>" class="delet_modal_form" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>

                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                                                    <button type="submit" class="btn btn-primary btn-type-dlt"><?php echo e(__('translate.Yes, Delete')); ?></button>

                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="modal fade" id="deleteModal<?php echo e($index); ?>" tabindex="-1" aria-labelledby="exampleModalLabel<?php echo e($index); ?>" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="exampleModalLabel1"><?php echo e(__('translate.Status Change Confirmation')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <p><?php echo e(__('translate.Are you sure you want to change the status of this item?')); ?></p>
                                            </div>
                                            <div class="modal-footer">
                                                <form action="" id="item_delect_confirmation<?php echo e($index); ?>" class="delet_modal_form" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                                                    <button type="submit" class="btn btn-primary"><?php echo e(__('translate.Yes, Change')); ?></button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                        <!-- End crancy Table Body -->
                    </table>
                </div>
            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->
<?php $__env->stopSection(); ?>



<?php $__env->startPush('style_section'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('global/select2/select2.min.css')); ?>">

<?php $__env->stopPush(); ?>


<?php $__env->startPush('js_section'); ?>

<script src="<?php echo e(asset('global/select2/select2.min.js')); ?>"></script>

<script>

    (function($) {
        "use strict"
        $(document).ready(function () {
            $('.select2').select2();
        });
    })(jQuery);

    function itemDeleteConfrimation(id, indexId){
        $("#item_delete_confirmation"+indexId).attr("action",'<?php echo e(url("admin/delete-offer-product")); ?>'+"/"+id)
    }

</script>

<?php $__env->stopPush(); ?>



<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\foodkhabo\resources\views/admin/offer/offer_product.blade.php ENDPATH**/ ?>