<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('translate.Order List')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-header'); ?>
    <h3 class="crancy-header__title m-0"><?php echo e(__('translate.Order List')); ?></h3>
    <p class="crancy-header__text"><?php echo e(__('translate.Manage Order')); ?> >> <?php echo e(__('translate.Order List')); ?></p>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('body-content'); ?>
    <!-- crancy Dashboard -->
    <section class="crancy-adashboard crancy-show">
        <div class="container container__bscreen">
            <div class="row">
                <div class="col-12">
                    <div class="crancy-body">
                        <div class="crancy-dsinner">

                            <div class="crancy-table crancy-table--v3 mg-top-30">

                                <div class="crancy-customer-filter">
                                    <div class="crancy-customer-filter__single crancy-customer-filter__single--csearch d-flex items-center justify-between create_new_btn_box">
                                        <div class="crancy-header__form crancy-header__form--customer create_new_btn_inline_box">
                                            <h4 class="crancy-product-card__title"><?php echo e(__('translate.Order List')); ?></h4>
                                        </div>
                                    </div>
                                </div>

                                <!-- crancy Table -->
                                <div id="crancy-table__main_wrapper" class="dataTables_wrapper dt-bootstrap5 no-footer">

                                    <table class="crancy-table__main crancy-table__main-v3 dataTable no-footer" id="dataTable">
                                        <!-- crancy Table Head -->
                                        <thead class="crancy-table__head">
                                        <tr>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                <?php echo e(__('translate.Order Id')); ?>

                                            </th>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                <?php echo e(__('translate.Restaurant')); ?>

                                            </th>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                <?php echo e(__('translate.Date')); ?>

                                            </th>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                <?php echo e(__('translate.Amount')); ?>

                                            </th>

                                            <th class="crancy-table__column-2 crancy-table__h2 sorting" >
                                                <?php echo e(__('translate.Order Status')); ?>

                                            </th>

                                            <th class="crancy-table__column-3 crancy-table__h3 sorting">
                                                <?php echo e(__('translate.Action')); ?>

                                            </th>

                                        </tr>
                                        </thead>
                                        <!-- crancy Table Body -->
                                        <tbody class="crancy-table__body">
                                        <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <tr class="odd">

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e($order->id); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e($order?->restaurant?->restaurant_name); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title"><?php echo e($order->created_at->format('F j, Y')); ?></h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">
                                                        <p><?php echo e(number_format($order->grand_total, 2)); ?></p>
                                                        <?php if($order->payment_status == 'success'): ?>
                                                            <strong class="text-success">
                                                                <?php echo e(__('translate.Paid')); ?>

                                                            </strong>
                                                        <?php else: ?>
                                                            <strong class="text-danger">
                                                                <?php echo e(__('translate.Unpaid')); ?>

                                                            </strong>
                                                        <?php endif; ?>
                                                    </h4>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <h4 class="crancy-table__product-title">
                                                        <span class="mb-1">

                                                        <?php if($order->order_status == 1): ?>
                                                            <?php echo e(__('translate.State')); ?> : <span class="tag denger"><?php echo e(__('translate.Pending')); ?></span>
                                                        <?php elseif($order->order_status == 2): ?>
                                                            <?php echo e(__('translate.State')); ?> : <span
                                                                class="tag"><?php echo e(__('translate.Confirmed')); ?></span>
                                                        <?php elseif($order->order_status == 3): ?>
                                                            <?php echo e(__('translate.State')); ?> : <span
                                                                class="tag"><?php echo e(__('translate.Processing')); ?></span>
                                                        <?php elseif($order->order_status == 4): ?>
                                                            <?php echo e(__('translate.State')); ?> : <span
                                                                class="tag"><?php echo e(__('translate.Food on the way')); ?></span>
                                                        <?php elseif($order->order_status == 5): ?>
                                                            <?php echo e(__('translate.State')); ?> : <span
                                                                class="tag"><?php echo e(__('translate.Delivered')); ?></span>
                                                        <?php elseif($order->order_status == 6): ?>
                                                            <?php echo e(__('translate.State')); ?> : <span
                                                                class="tag"><?php echo e(__('translate.Canceled')); ?></span>
                                                        <?php endif; ?>
                                                        </span>
                                                    </h4>
                                                    <div class="text-capitalize opacity-7">
                                                        <span><?php echo e(__('translate.Type')); ?>:</span>
                                                        <span class="text-success"><?php echo e($order->order_type); ?></span>
                                                    </div>
                                                </td>

                                                <td class="crancy-table__column-2 crancy-table__data-2">
                                                    <a href="<?php echo e(route('restaurant.order.details', ['id' => $order->id])); ?>" class="crancy-btn"><i class="fas fa-eye"></i> <?php echo e(__('translate.View')); ?></a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                        </tbody>
                                        <!-- End crancy Table Body -->
                                    </table>
                                </div>
                                <!-- End crancy Table -->
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- End crancy Dashboard -->

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('translate.Delete Confirmation')); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p><?php echo e(__('translate.Are you realy want to delete this item?')); ?></p>
                </div>
                <div class="modal-footer">
                    <form action="" id="item_delect_confirmation" class="delet_modal_form" method="POST">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>

                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?php echo e(__('translate.Close')); ?></button>
                        <button type="submit" class="btn btn-primary btn-type-dlt"><?php echo e(__('translate.Yes, Delete')); ?></button>

                    </form>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js_section'); ?>
    <script>
        "use strict"
        function itemDeleteConfrimation(id){
            $("#item_delect_confirmation").attr("action",'<?php echo e(url("admin/restaurant/product/")); ?>'+"/"+id)
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('restaurant.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\foodkhabo\Modules/Order\resources/views/restaurant/index.blade.php ENDPATH**/ ?>