<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>" />
    <meta name="description" content="<?php echo strip_tags(clean($seo_setting->seo_description)); ?>" />
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <main>

        <!-- banner-part start  -->

        <div class="profile_bg" style="background-image: url(<?php echo e(asset($general_setting->breadcrumb_image)); ?>);">
            <div class="container">
                <div class="row">
                    <div class="col-xxl-12">
                        <ul class="breadcrumb">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('translate.Home')); ?></a></li>
                            <li><a href="<?php echo e(route('home')); ?>">/</a></li>
                            <li><a href="javascript:;" class="active"><?php echo e(__('translate.About Us')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- banner-part end -->

        <!-- about-part start  -->
        <section class="about-us">
            <div class="container">
                <div class="row align-items-center ">
                    <div class="col-lg-6 ">
                        <div class="about-us-img">
                            <img src="<?php echo e(asset($about->about_image)); ?>" class="w-100" alt="thumb">

                            <div class="about-us-img-btn-img">

                                <div class="about-us-img-btn-img-main">
                                    <img src="<?php echo e(spinner_icon()); ?>" alt="img">
                                    <div class="about-us-img-btn-img-overlay">
                                        <h2><?php echo e($about->experience_year); ?></h2>
                                        <span><?php echo e(__('translate.Years')); ?></span>
                                    </div>
                                </div>

                            </div>
                        </div>
                    </div>

                    <div class="col-lg-6 about-pl-45px aos-init aos-animate" data-aos="fade-left">
                        <div class="about-us-head">
                            <h2><?php echo e($about->title); ?></h2>

                            <h5><?php echo clean($about->description); ?></h5>
                        </div>

                        <div class="row about-mt-48px">
                            <div class="col-lg-6 col-md-6">
                                <div class="about-us-item">
                                    <div class="icon">
                                        <span>
                                            <svg width="63" height="59" viewBox="0 0 63 59" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M62.0483 29.5C62.0483 45.4931 48.4147 58.5 31.5437 58.5C14.6727 58.5 1.03906 45.4931 1.03906 29.5C1.03906 13.5069 14.6727 0.5 31.5437 0.5C48.4147 0.5 62.0483 13.5069 62.0483 29.5Z"
                                                    fill="#F9C200" stroke="#FCCBD5" />
                                                <path
                                                    d="M26.7484 21.5748C27.0893 20.8057 27.4837 20.1201 28.0777 19.5491C30.8069 16.9303 35.4071 17.7457 36.9214 21.137C37.0833 21.4995 37.1515 21.5667 37.5118 21.2899C38.8302 20.2753 40.314 20.0714 41.8381 20.7803C43.322 21.4694 44.1315 22.6381 44.1486 24.2468C44.1559 24.98 44.1437 25.7143 44.151 26.4475C44.1632 27.6694 43.6434 28.6551 42.6768 29.4311C42.42 29.6372 42.2593 29.8446 42.3275 30.1689C42.3969 30.5036 42.7182 30.4723 42.9544 30.5302C43.7383 30.7225 44.5527 30.8175 45.2733 31.2008C46.7414 31.9803 47.5266 33.1652 47.5534 34.7717C47.574 35.9878 47.5619 37.2039 47.5558 38.4201C47.5521 39.166 47.3768 39.3281 46.5783 39.3316C45.3001 39.3362 44.022 39.349 42.745 39.3247C42.2593 39.3154 42.0536 39.437 42.0706 39.9374C42.1327 41.7929 42.0657 41.6527 40.2313 41.6504C38.4053 41.6481 36.5794 41.6492 34.7546 41.6492C34.4892 41.6492 34.2202 41.655 34.0206 41.4465C33.8404 41.2566 33.8003 41.0331 33.8964 40.8003C34.0048 40.5396 34.23 40.418 34.5185 40.4157C35.2695 40.4099 36.0206 40.3868 36.7693 40.4169C37.261 40.4366 37.412 40.2501 37.3901 39.8076C37.3621 39.2494 37.3791 38.6888 37.3876 38.1282C37.3949 37.6788 37.5422 37.2954 38.0986 37.3047C38.6183 37.314 38.762 37.6846 38.7693 38.1085C38.7802 38.7062 38.7875 39.305 38.7717 39.9038C38.762 40.2756 38.9154 40.4041 39.3086 40.4157C40.7401 40.4574 40.7364 40.4702 40.7048 39.0907C40.6951 38.6668 40.7121 38.2417 40.7011 37.8178C40.6525 35.8002 39.3938 34.2852 37.3475 33.7906C36.6013 33.61 35.838 33.486 35.104 33.2706C34.5586 33.1108 34.3444 33.3077 34.1508 33.7559C33.698 34.8087 33.1989 35.8442 32.7169 36.8866C32.5598 37.2248 32.4174 37.585 31.9317 37.585C31.4448 37.5862 31.3023 37.226 31.1465 36.8878C30.6487 35.8106 30.141 34.7369 29.6639 33.6517C29.4922 33.2613 29.2719 33.1224 28.8239 33.2451C28.1045 33.4432 27.3692 33.5903 26.6401 33.7617C24.5134 34.262 23.2243 35.7156 23.1026 37.7946C23.0612 38.507 23.1038 39.2227 23.0868 39.9362C23.0782 40.2872 23.2267 40.4157 23.5907 40.4099C25.3826 40.3821 25.0539 40.6149 25.0892 39.0838C25.0953 38.7942 25.0892 38.5046 25.0917 38.2151C25.0965 37.7599 25.1781 37.314 25.7746 37.3047C26.3698 37.2954 26.4769 37.7298 26.4794 38.1919C26.483 38.771 26.4916 39.3501 26.4794 39.9293C26.4721 40.2721 26.6133 40.418 26.9821 40.4099C27.6516 40.396 28.3212 40.4065 28.9907 40.4099C29.4362 40.4122 29.7612 40.5825 29.7551 41.0446C29.7491 41.472 29.4386 41.6458 29.0187 41.6469C26.8482 41.6492 24.6778 41.6504 22.5073 41.6446C22.0411 41.6434 21.7989 41.3991 21.7903 40.9566C21.783 40.5895 21.7648 40.2223 21.7903 39.8563C21.8183 39.4416 21.6272 39.3235 21.2158 39.3281C19.9181 39.3444 18.6193 39.3362 17.3204 39.3328C16.4792 39.3305 16.3125 39.1764 16.3088 38.3946C16.3039 37.1982 16.3027 36.0017 16.3088 34.8041C16.3198 32.9498 17.5273 31.4151 19.4032 30.887C19.9461 30.7341 20.5061 30.6333 21.0551 30.4955C21.6102 30.3565 21.7757 29.9013 21.3424 29.5759C20.0179 28.5798 19.5967 27.2663 19.7075 25.7282C19.7404 25.2672 19.7148 24.8016 19.7136 24.3383C19.7063 22.6821 20.5134 21.4717 22.052 20.7722C23.6297 20.0552 25.1306 20.3089 26.4745 21.3756C26.5476 21.4312 26.6267 21.4856 26.7484 21.5748ZM36.0267 25.5093C36.2324 24.8619 35.8429 24.409 35.1222 24.1113C34.8082 23.9816 34.5112 23.8044 34.23 23.6168C33.8502 23.362 33.5373 23.3237 33.1648 23.6643C32.8934 23.9121 32.5318 24.0777 32.1971 24.2561C31.0382 24.8769 29.76 24.9232 28.4782 24.914C28.0168 24.9105 27.788 25.0483 27.8391 25.5128C27.8793 25.8765 27.8842 26.2436 27.9268 26.6062C28.2055 28.9643 30.6121 30.5129 33.0114 29.8839C34.9409 29.3801 36.0255 27.8547 36.0267 25.5093ZM46.2521 36.2473C46.2508 36.2473 46.2496 36.2473 46.2496 36.2473C46.2496 35.8233 46.2654 35.3983 46.2472 34.9744C46.1766 33.3795 45.3671 32.432 43.7517 32.0394C43.3597 31.9444 42.9544 31.8865 42.5721 31.7649C42.1875 31.6421 42.0158 31.7869 41.8844 32.1077C41.6263 32.7355 41.3646 33.3644 41.0651 33.9748C40.9093 34.291 40.9178 34.5261 41.1333 34.8192C41.664 35.543 41.9611 36.3631 42.0609 37.2399C42.157 38.0877 42.1473 38.0564 43.0335 38.0993C43.6336 38.1282 43.8893 37.9765 43.8308 37.3661C43.7773 36.8113 43.8199 36.2484 43.8223 35.689C43.8235 35.2697 43.9891 34.95 44.4772 34.9524C44.9666 34.9547 45.1236 35.279 45.1236 35.6971C45.1248 36.2183 45.1078 36.7395 45.1309 37.2584C45.1467 37.6174 44.9264 38.0935 45.6738 38.1016C46.4578 38.1097 46.2253 37.6093 46.2496 37.2306C46.2691 36.904 46.2521 36.575 46.2521 36.2473ZM17.6138 36.1731C17.6138 36.7175 17.6308 37.1611 17.6089 37.6035C17.5882 37.9962 17.783 38.0923 18.1579 38.0958C18.5523 38.0981 18.7653 38.0124 18.7483 37.5827C18.7215 36.948 18.741 36.311 18.7446 35.6751C18.7471 35.2523 18.9272 34.9442 19.4142 34.9535C19.8646 34.9616 20.0386 35.257 20.0435 35.6542C20.0484 36.0978 20.0411 36.5414 20.0484 36.9839C20.0703 38.1942 19.8098 38.0773 21.2791 38.0912C21.6369 38.0946 21.7964 37.9765 21.7891 37.6221C21.766 36.5611 22.1665 35.6218 22.7654 34.7531C22.9151 34.5365 22.9602 34.3489 22.853 34.1103C22.5426 33.42 22.2383 32.7262 21.9388 32.0313C21.8317 31.7834 21.6917 31.6607 21.3825 31.7464C20.7812 31.9132 20.1567 32.0139 19.5663 32.2097C18.5231 32.556 17.9278 33.2868 17.7075 34.3142C17.5675 34.9651 17.6345 35.6207 17.6138 36.1731ZM36.034 23.1199C35.9829 22.828 35.9573 22.6786 35.9318 22.5292C35.5921 20.5336 33.687 19.117 31.5799 19.2954C29.5019 19.4715 27.8403 21.2192 27.8501 23.2079C27.8513 23.4662 27.9341 23.5982 28.2262 23.6121C29.9804 23.6932 31.6347 23.4905 32.9007 22.1586C33.2427 21.7983 33.6177 21.7775 34.0425 22.0184C34.6645 22.3694 35.2939 22.711 36.034 23.1199ZM26.5305 25.8498C26.5305 25.6217 26.522 25.4479 26.5317 25.2753C26.55 24.9603 26.4234 24.9093 26.1337 25.0344C24.7557 25.6274 23.284 25.712 21.8025 25.734C21.0137 25.7456 20.9358 25.829 21.0587 26.5841C21.077 26.6977 21.1001 26.8112 21.122 26.9258C21.346 28.0945 22.3759 28.9388 23.6759 29.0234C24.8372 29.0987 26.0655 28.2682 26.3747 27.1679C26.5001 26.722 26.5658 26.261 26.5305 25.8498ZM40.1071 29.0292C41.5228 29.013 42.5904 28.0354 42.8144 26.5494C42.9227 25.8336 42.84 25.7502 42.0864 25.7328C40.8947 25.7062 39.7078 25.6576 38.5477 25.3309C38.1606 25.2221 37.6749 24.7912 37.4156 25.068C37.1904 25.3078 37.3183 25.8753 37.3438 26.2946C37.44 27.9045 38.6049 29.0465 40.1071 29.0292ZM22.2395 24.424C23.486 24.4298 24.6899 24.2549 25.8391 23.7581C26.3211 23.5496 26.3601 23.3052 26.0838 22.9114C25.4788 22.0485 24.6376 21.6431 23.5591 21.7184C22.5256 21.7902 21.7672 22.2883 21.3241 23.1766C20.7946 24.2399 20.9236 24.4252 22.119 24.4252C22.158 24.424 22.1981 24.424 22.2395 24.424ZM41.5435 24.4217C41.8466 24.4217 42.1497 24.4183 42.4541 24.4229C42.7487 24.4275 42.8241 24.3048 42.7949 24.0256C42.6756 22.923 41.8272 21.9918 40.6914 21.7555C39.5386 21.5146 38.3664 22.0022 37.7614 22.9415C37.513 23.3272 37.5642 23.5531 38.0097 23.7488C39.1333 24.2434 40.3177 24.4194 41.5435 24.4217ZM30.488 31.8448C30.662 32.9683 31.3036 33.9424 31.7722 34.9744C31.9305 35.323 32.0814 35.0253 32.1581 34.8643C32.4344 34.2875 32.6949 33.7038 32.9652 33.1258C33.1697 32.688 33.3864 32.2641 33.3754 31.7568C33.3657 31.3294 33.2379 31.1476 32.7655 31.2541C32.2494 31.3699 31.7126 31.3862 31.2025 31.2669C30.645 31.1348 30.376 31.2298 30.488 31.8448ZM26.0046 30.0195C25.9669 30.3495 26.2018 30.4295 26.4806 30.492C27.2256 30.66 27.9815 30.7966 28.6961 31.0711C28.8057 31.1128 28.9262 31.2055 29.0321 31.1221C29.1538 31.026 29.099 30.8708 29.0905 30.7399C29.0771 30.5163 28.8848 30.4214 28.7253 30.3079C28.3346 30.031 27.9852 29.716 27.6869 29.3465C27.1854 28.7257 27.1769 28.7246 26.5816 29.2631C26.3443 29.4786 25.9632 29.6013 26.0046 30.0195ZM37.8612 30.0137C37.8612 29.987 37.8624 29.9673 37.8612 29.9488C37.8514 29.8353 36.8886 28.7917 36.7741 28.7662C36.6828 28.7454 36.6134 28.7801 36.5684 28.8496C36.1265 29.5307 35.5203 30.0588 34.863 30.5464C34.6986 30.6692 34.7254 30.9055 34.8009 31.0885C34.8496 31.2055 34.9774 31.1545 35.0662 31.1163C35.8295 30.7932 36.65 30.6657 37.4522 30.477C37.7273 30.4121 37.888 30.2916 37.8612 30.0137ZM23.8025 32.776C24.0204 32.2873 24.214 31.8923 24.3759 31.4869C24.8226 30.3634 24.6948 30.2291 23.5664 30.2893C22.976 30.3206 22.8238 30.4492 22.9918 30.9924C23.1708 31.5761 23.4166 32.1425 23.8025 32.776ZM40.0974 32.8015C40.3238 32.3 40.5015 31.9189 40.6683 31.5333C41.1564 30.4086 41.0529 30.2824 39.8101 30.2835C39.3122 30.2835 39.188 30.5024 39.283 30.887C39.4376 31.5217 39.7407 32.1008 40.0974 32.8015ZM36.202 32.0962C36.2069 32.1251 36.2117 32.1541 36.2178 32.183C36.9652 32.3602 37.7114 32.5374 38.4966 32.7228C38.1619 31.6398 38.1619 31.6398 37.1344 31.8796C36.8228 31.9525 36.5124 32.0243 36.202 32.0962ZM27.5616 32.1946C27.5677 32.1564 27.5725 32.1193 27.5786 32.0811C27.1757 31.985 26.7618 31.9213 26.3735 31.7858C25.8951 31.619 25.6504 31.7846 25.5335 32.212C25.4897 32.3695 25.3363 32.505 25.424 32.7147C26.1373 32.5409 26.8494 32.3672 27.5616 32.1946Z"
                                                    fill="#0C1321" />
                                                <path
                                                    d="M31.9314 28.786C31.4834 28.8091 31.0927 28.669 30.7652 28.3875C30.4986 28.1582 30.394 27.8686 30.6033 27.5617C30.8176 27.2478 31.1414 27.1332 31.4907 27.344C31.7926 27.5258 32.0471 27.4876 32.3356 27.3347C32.6654 27.1598 32.9783 27.227 33.1877 27.52C33.4153 27.8385 33.3216 28.1466 33.0367 28.3968C32.7275 28.6701 32.3575 28.8057 31.9314 28.786Z"
                                                    fill="#0C1321" />
                                                <path
                                                    d="M34.6327 25.9448C34.5609 26.3085 34.343 26.5552 33.9474 26.5471C33.5481 26.539 33.3132 26.2784 33.3205 25.9077C33.3278 25.5313 33.5859 25.2962 33.9851 25.3112C34.3771 25.3263 34.5962 25.5637 34.6327 25.9448Z"
                                                    fill="#0C1321" />
                                                <path
                                                    d="M30.5245 25.9874C30.4685 26.3534 30.2262 26.5665 29.8355 26.5387C29.4435 26.5109 29.2134 26.2573 29.2451 25.8785C29.2767 25.4998 29.5518 25.2901 29.9389 25.311C30.3382 25.333 30.533 25.5855 30.5245 25.9874Z"
                                                    fill="#0C1321" />
                                            </svg>

                                        </span>
                                    </div>

                                    <div class="text">
                                        <h3><?php echo e($about->customer_title); ?></h3>

                                        <p><?php echo e($about->customer_des); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <div class="about-us-item about-us-item-resmt ">
                                    <div class="icon">
                                        <span>
                                            <svg width="63" height="59" viewBox="0 0 63 59" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M61.7983 29.5C61.7983 45.4931 48.1647 58.5 31.2937 58.5C14.4227 58.5 0.789062 45.4931 0.789062 29.5C0.789062 13.5069 14.4227 0.5 31.2937 0.5C48.1647 0.5 61.7983 13.5069 61.7983 29.5Z"
                                                    fill="#F9C200" stroke="#FCCBD5" />
                                                <g clip-path="url(#clip0_1015_22688)">
                                                    <path
                                                        d="M30.7662 22.8708C31.9814 22.8708 32.9699 21.9302 32.9699 20.774C32.9699 19.6179 31.9814 18.6772 30.7662 18.6772C29.5511 18.6772 28.5625 19.6179 28.5625 20.774C28.5625 21.9302 29.5511 22.8708 30.7662 22.8708ZM30.7662 19.516C31.4952 19.516 32.0885 20.0804 32.0885 20.774C32.0885 21.4676 31.4952 22.0321 30.7662 22.0321C30.0372 22.0321 29.444 21.4676 29.444 20.774C29.444 20.0804 30.0372 19.516 30.7662 19.516Z"
                                                        fill="#0F172A" />
                                                    <path
                                                        d="M30.7636 26.8972L33.8611 23.2132C34.4217 22.5468 34.7303 21.7094 34.7303 20.8555V20.7742C34.7303 18.6934 32.9505 17 30.7636 17C28.5766 17 26.7969 18.6934 26.7969 20.7742V20.8555C26.7969 21.7094 27.1054 22.5468 27.666 23.2132L30.7636 26.8972ZM27.6784 20.7742C27.6784 19.1555 29.0623 17.8387 30.7636 17.8387C32.4648 17.8387 33.8488 19.1555 33.8488 20.7742V20.8555C33.8488 21.5194 33.6086 22.1711 33.1727 22.6894L30.7636 25.5544L28.3545 22.689C27.9186 22.1711 27.6784 21.5194 27.6784 20.8555V20.7742Z"
                                                        fill="#0F172A" />
                                                    <path
                                                        d="M40.4615 18.6772C39.2464 18.6772 38.2578 19.6179 38.2578 20.774C38.2578 21.9302 39.2464 22.8708 40.4615 22.8708C41.6767 22.8708 42.6653 21.9302 42.6653 20.774C42.6653 19.6179 41.6767 18.6772 40.4615 18.6772ZM40.4615 22.0321C39.7325 22.0321 39.1393 21.4676 39.1393 20.774C39.1393 20.0804 39.7325 19.516 40.4615 19.516C41.1905 19.516 41.7838 20.0804 41.7838 20.774C41.7838 21.4676 41.1905 22.0321 40.4615 22.0321Z"
                                                        fill="#0F172A" />
                                                    <path
                                                        d="M40.4589 17C38.2719 17 36.4922 18.6934 36.4922 20.7742V20.8555C36.4922 21.7094 36.8007 22.5468 37.3613 23.2132L40.4589 26.8972L43.5564 23.2132C44.1171 22.5468 44.4256 21.7094 44.4256 20.8555V20.7742C44.4256 18.6934 42.6459 17 40.4589 17ZM43.5441 20.8555C43.5441 21.5194 43.3039 22.1711 42.868 22.6894L40.4589 25.5544L38.0498 22.689C37.6139 22.1711 37.3737 21.5194 37.3737 20.8555V20.7742C37.3737 19.1555 38.7576 17.8387 40.4589 17.8387C42.1602 17.8387 43.5441 19.1555 43.5441 20.7742V20.8555Z"
                                                        fill="#0F172A" />
                                                    <path
                                                        d="M21.0709 22.8708C22.286 22.8708 23.2746 21.9302 23.2746 20.774C23.2746 19.6179 22.286 18.6772 21.0709 18.6772C19.8558 18.6772 18.8672 19.6179 18.8672 20.774C18.8672 21.9302 19.8558 22.8708 21.0709 22.8708ZM21.0709 19.516C21.7999 19.516 22.3931 20.0804 22.3931 20.774C22.3931 21.4676 21.7999 22.0321 21.0709 22.0321C20.3419 22.0321 19.7487 21.4676 19.7487 20.774C19.7487 20.0804 20.3419 19.516 21.0709 19.516Z"
                                                        fill="#0F172A" />
                                                    <path
                                                        d="M21.0683 26.8972L24.1658 23.2132C24.7264 22.5468 25.035 21.7094 25.035 20.8555V20.7742C25.035 18.6934 23.2552 17 21.0683 17C18.8813 17 17.1016 18.6934 17.1016 20.7742V20.8555C17.1016 21.7094 17.4101 22.5468 17.9707 23.2132L21.0683 26.8972ZM17.9831 20.7742C17.9831 19.1555 19.367 17.8387 21.0683 17.8387C22.7695 17.8387 24.1535 19.1555 24.1535 20.7742V20.8555C24.1535 21.5194 23.9133 22.1711 23.4774 22.6894L21.0683 25.5544L18.6592 22.689C18.2233 22.1711 17.9831 21.5194 17.9831 20.8555V20.7742Z"
                                                        fill="#0F172A" />
                                                    <path
                                                        d="M43.5462 33.8052V29.054C43.5462 28.5281 43.1716 28.0886 42.6647 27.9515V26.2258H41.7832V28.0106L40.9017 28.2622V27.4839H40.0202V28.5138L38.2374 29.0229C37.7222 29.1701 37.3758 29.613 37.3758 30.125V30.4194H34.7313V29.5807C34.7313 29.1181 34.336 28.742 33.8498 28.742H32.9683V27.9032H32.0869V28.742H31.2054V27.0645H30.3239V28.742H29.4424V27.9032H28.5609V28.742H27.6794C27.1933 28.742 26.7979 29.1181 26.7979 29.5807V30.4194H24.1535V30.125C24.1535 29.613 23.807 29.1701 23.2914 29.0225L21.509 28.5138V27.4839H20.6275V28.2622L19.746 28.0106V26.2258H18.8645V27.9519C18.3577 28.089 17.9831 28.5285 17.9831 29.0544V33.8052C17.4788 33.9176 17.1016 34.3466 17.1016 34.8599C17.1016 35.0436 17.1509 35.226 17.2452 35.3871L17.2836 35.4529C20.0021 40.1082 25.1676 43 30.7646 43C36.3616 43 41.5271 40.1082 44.2457 35.4529L44.2844 35.3866C44.3783 35.2256 44.4277 35.0436 44.4277 34.8595C44.4277 34.3462 44.0504 33.9176 43.5462 33.8052ZM38.2573 30.125C38.2573 29.9862 38.3511 29.8658 38.4909 29.826L42.2429 28.755C42.4474 28.6975 42.6647 28.8518 42.6647 29.054V33.7742H40.0202V31.2581C40.0202 30.7955 39.6249 30.4194 39.1388 30.4194H38.2573V30.125ZM39.1388 31.2581V33.7742H34.7313V31.2581H39.1388ZM27.6794 29.5807H33.8498V31.2581V33.7742H27.6794V31.2581V29.5807ZM26.7979 33.7742H22.3905V31.2581H26.7979V33.7742ZM19.2868 28.7554L23.0379 29.826C23.1781 29.8658 23.272 29.9862 23.272 30.125V30.4194H22.3905C21.9043 30.4194 21.509 30.7955 21.509 31.2581V33.7742H18.8645V29.054C18.8645 28.8518 19.0814 28.6958 19.2868 28.7554ZM18.054 35.0453L18.0157 34.9794C17.9941 34.943 17.9831 34.9014 17.9831 34.8595C17.9831 34.7236 18.0994 34.6129 18.2422 34.6129H25.9164V35.0323C25.9164 35.2633 25.7185 35.4516 25.4757 35.4516H22.8312C22.1022 35.4516 21.509 36.0161 21.509 36.7097C21.509 37.4033 22.1022 37.9678 22.8312 37.9678H28.1202C28.363 37.9678 28.5609 38.1561 28.5609 38.3871C28.5609 38.6182 28.363 38.8065 28.1202 38.8065H27.2387C26.5097 38.8065 25.9164 39.3709 25.9164 40.0645C25.9164 40.7582 26.5097 41.3226 27.2387 41.3226C27.4815 41.3226 27.6794 41.5109 27.6794 41.742V41.8413C23.6422 41.006 20.107 38.5612 18.054 35.0453ZM28.5609 41.9957V41.742C28.5609 41.0483 27.9677 40.4839 27.2387 40.4839C26.9958 40.4839 26.7979 40.2956 26.7979 40.0645C26.7979 39.8335 26.9958 39.6452 27.2387 39.6452H28.1202C28.8491 39.6452 29.4424 39.0807 29.4424 38.3871C29.4424 37.6935 28.8491 37.1291 28.1202 37.1291H22.8312C22.5884 37.1291 22.3905 36.9408 22.3905 36.7097C22.3905 36.4786 22.5884 36.2903 22.8312 36.2903H25.4757C26.2047 36.2903 26.7979 35.7259 26.7979 35.0323V34.6129H32.9683V35.0323C32.9683 35.7259 33.5616 36.2903 34.2906 36.2903H38.698C38.9409 36.2903 39.1388 36.4786 39.1388 36.7097C39.1388 36.9408 38.9409 37.1291 38.698 37.1291H36.0535C35.3246 37.1291 34.7313 37.6935 34.7313 38.3871C34.7313 38.6182 34.5334 38.8065 34.2906 38.8065H32.5276C31.7986 38.8065 31.2054 39.3709 31.2054 40.0645C31.2054 40.7582 31.7986 41.3226 32.5276 41.3226C32.7704 41.3226 32.9683 41.5109 32.9683 41.742V41.9957C32.2451 42.1013 31.5095 42.1613 30.7646 42.1613C30.0198 42.1613 29.2842 42.1013 28.5609 41.9957ZM43.5136 34.9794L43.4752 35.0453C41.4222 38.5612 37.887 41.006 33.8498 41.8413V41.742C33.8498 41.0483 33.2566 40.4839 32.5276 40.4839C32.2847 40.4839 32.0869 40.2956 32.0869 40.0645C32.0869 39.8335 32.2847 39.6452 32.5276 39.6452H34.2906C35.0196 39.6452 35.6128 39.0807 35.6128 38.3871C35.6128 38.1561 35.8107 37.9678 36.0535 37.9678H38.698C39.427 37.9678 40.0202 37.4033 40.0202 36.7097C40.0202 36.0161 39.427 35.4516 38.698 35.4516H34.2906C34.0477 35.4516 33.8498 35.2633 33.8498 35.0323V34.6129H43.287C43.4298 34.6129 43.5462 34.7236 43.5462 34.8595C43.5462 34.9014 43.5352 34.943 43.5136 34.9794Z"
                                                        fill="#0F172A" />
                                                    <path d="M23.2656 32.0967H24.1471V32.9354H23.2656V32.0967Z"
                                                          fill="#0F172A" />
                                                    <path d="M25.0312 32.0967H25.9127V32.9354H25.0312V32.0967Z"
                                                          fill="#0F172A" />
                                                    <path d="M28.5625 30.4194H29.444V31.2581H28.5625V30.4194Z"
                                                          fill="#0F172A" />
                                                    <path d="M30.3203 30.4194H31.2018V31.2581H30.3203V30.4194Z"
                                                          fill="#0F172A" />
                                                    <path d="M28.5625 32.0967H29.444V32.9354H28.5625V32.0967Z"
                                                          fill="#0F172A" />
                                                    <path d="M30.3203 32.0967H31.2018V32.9354H30.3203V32.0967Z"
                                                          fill="#0F172A" />
                                                    <path d="M32.0859 30.4194H32.9674V31.2581H32.0859V30.4194Z"
                                                          fill="#0F172A" />
                                                    <path d="M32.0859 32.0967H32.9674V32.9354H32.0859V32.0967Z"
                                                          fill="#0F172A" />
                                                    <path d="M19.7422 32.0967H20.6237V32.9354H19.7422V32.0967Z"
                                                          fill="#0F172A" />
                                                    <path d="M19.7422 30.4194H20.6237V31.2581H19.7422V30.4194Z"
                                                          fill="#0F172A" />
                                                    <path d="M37.375 32.0967H38.2565V32.9354H37.375V32.0967Z"
                                                          fill="#0F172A" />
                                                    <path d="M35.6094 32.0967H36.4909V32.9354H35.6094V32.0967Z"
                                                          fill="#0F172A" />
                                                    <path d="M40.9062 32.0967H41.7877V32.9354H40.9062V32.0967Z"
                                                          fill="#0F172A" />
                                                    <path d="M40.9062 30.4194H41.7877V31.2581H40.9062V30.4194Z"
                                                          fill="#0F172A" />
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_1015_22688">
                                                        <rect width="27.3261" height="26" fill="white"
                                                              transform="translate(17.1016 17)" />
                                                    </clipPath>
                                                </defs>
                                            </svg>

                                        </span>
                                    </div>

                                    <div class="text">
                                        <h3><?php echo e($about->branch_title); ?></h3>

                                        <p><?php echo e($about->branch_des); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>

        <!-- about-part end -->





        <!-- Popular part start -->


        <?php if(!empty($popular_products)): ?>
            <section class="popular">
                <div class="container">
                    <div class="row mb_25px ">
                        <div class="col-xxl-12" data-aos="fade-down" data-aos-delay="50">
                            <h2 class="titel"><?php echo e(__('translate.Most Popular Items')); ?></h2>
                        </div>
                    </div>
                    <div class="row g-4">
                        <?php $__empty_1 = true; $__currentLoopData = $popular_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $popular_key => $popular_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="col-xxl-4 col-md-6" data-aos="fade-up" data-aos-delay="100">
                                <div class="food_card_item">
                                    <div class="food_card_item_thumb_main">
                                        <div class="food_card_item_thumb">
                                            <img src="<?php echo e(asset($popular_product->image)); ?>" alt="thumb">
                                        </div>
                                        <div class="food_card_item_thumb_overlay">
                                            <?php if($popular_product->created_at >= \Carbon\Carbon::now()->subWeek()): ?>
                                            <div class="badge">
                                                <h6><?php echo e(__('translate.NEW')); ?></h6>
                                            </div>
                                            <?php endif; ?>
                                            <a  href="<?php echo e(route('user.add-to-wishlist', ['id' => $popular_product->id])); ?>" class="wishlist_icon <?php echo e($wishlist->contains('item_id', $popular_product->id) ? 'wihslist_active' : ''); ?>">
                                        <span>
                                            <svg width="20" height="16" viewBox="0 0 20 16" fill="none"
                                                 xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M14.166 3.41668C15.0865 3.41668 15.8327 4.16287 15.8327 5.08334M9.99935 2.75212L10.5702 2.16668C12.346 0.345605 15.2251 0.345603 17.0009 2.16668C18.7289 3.93884 18.782 6.79484 17.1211 8.63328L12.3491 13.9151C11.0814 15.3183 8.9173 15.3183 7.64956 13.9151L2.87762 8.6333C1.21667 6.79487 1.26977 3.93886 2.99785 2.16669C4.77362 0.345615 7.65271 0.345617 9.42848 2.16669L9.99935 2.75212Z"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
                                                </path>
                                            </svg>
                                        </span>
                                            </a>
                                        </div>
                                    </div>

                                    <div class="food_card_item_inner">
                                        <div class="food_card_item_inner_top">
                                            <h5><?php echo e(currency($popular_product->offer_price > 0 ? $popular_product->offer_price : $popular_product->price)); ?></h5>
                                            <p>
                                                <span>
                                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M6.52461 1.45356C7.12812 0.182149 8.87187 0.182146 9.47539 1.45356L10.5184 3.65088C10.7581 4.15576 11.2213 4.5057 11.7572 4.58666L14.0895 4.93902C15.439 5.1429 15.9779 6.86716 15.0013 7.85681L13.3137 9.56719C12.9259 9.96019 12.749 10.5264 12.8405 11.0813L13.2389 13.4964C13.4694 14.8938 12.0587 15.9595 10.8517 15.2997L8.76562 14.1595C8.28631 13.8975 7.71369 13.8975 7.23438 14.1595L5.14832 15.2997C3.94129 15.9595 2.53057 14.8938 2.76109 13.4964L3.15949 11.0813C3.25103 10.5264 3.07408 9.96019 2.68631 9.56719L0.998656 7.85681C0.0221496 6.86716 0.560996 5.1429 1.9105 4.93902L4.24278 4.58666C4.77867 4.5057 5.24192 4.15576 5.48158 3.65088L6.52461 1.45356Z" fill="#F9C200"/>
                                                        </svg>

                                                </span>
                                                <?php echo e(round($popular_product->reviews_avg_rating ?? 0)); ?>

                                                <span>(<?php echo e($popular_product->reviews_count); ?>+)</span>
                                            </p>
                                        </div>

                                        <a  class="food_card_modal_btn" href="javascript::" onClick="loadProductModal(<?php echo e($popular_product->id); ?>)">
                                            <h5><?php echo e($popular_product->name); ?></h5>
                                        </a>


                                        <ul class="food_card_list">
                                            <?php
                                                $specifications = array_slice(json_decode($popular_product->specification, true), 0, 2);
                                            ?>

                                            <?php $__empty_2 = true; $__currentLoopData = $specifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $popular_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                <li>
                                                    <?php echo e($popular_name); ?>

                                                </li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                            <?php endif; ?>
                                        </ul>


                                        <div class="food_card_btm_item">

                                            <div class="food_card_company">
                                                <div class="food_card_company_thumb">
                                                    <img src="<?php echo e(asset($popular_product?->restaurant?->logo)); ?>"
                                                         alt="logo">
                                                </div>

                                                <a href="<?php echo e(route('single.restaurant', $popular_product?->restaurant->slug)); ?>" class="food_card_company_name">
                                                    <?php echo e($popular_product?->restaurant->restaurant_name); ?>

                                                </a>
                                            </div>
                                            <a href="javascript:;" href="javascript::" onClick="loadProductModal(<?php echo e($popular_product->id); ?>)" class="thm-btn_three">
                                                <span>
                                                    <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                        <g clip-path="url(#clip0_1610_24994)">
                                                        <path d="M5.33398 10.6667L11.1474 10.1822C12.9664 10.0307 13.3747 9.63333 13.5763 7.81927L14.0007 4" stroke="#0C1321" stroke-width="1.5" stroke-linecap="round"></path>
                                                        <path d="M4 4H4.33333M14.6667 4H13" stroke="#0C1321" stroke-width="1.5" stroke-linecap="round"></path>
                                                        <path d="M6.33398 4.00008H11.0007M8.66732 6.33341V1.66675" stroke="#0C1321" stroke-width="1.5" stroke-linecap="round"></path>
                                                        <path d="M3.99935 14.6667C4.73573 14.6667 5.33268 14.0697 5.33268 13.3333C5.33268 12.597 4.73573 12 3.99935 12C3.26297 12 2.66602 12.597 2.66602 13.3333C2.66602 14.0697 3.26297 14.6667 3.99935 14.6667Z" stroke="#0C1321" stroke-width="1.5"></path>
                                                        <path d="M11.3333 14.6667C12.0697 14.6667 12.6667 14.0697 12.6667 13.3333C12.6667 12.597 12.0697 12 11.3333 12C10.597 12 10 12.597 10 13.3333C10 14.0697 10.597 14.6667 11.3333 14.6667Z" stroke="#0C1321" stroke-width="1.5"></path>
                                                        <path d="M5.33398 13.3333H10.0007" stroke="#0C1321" stroke-width="1.5" stroke-linecap="round"></path>
                                                        <path d="M1.33398 1.33325H1.97798C2.60777 1.33325 3.15674 1.74965 3.30949 2.34321L5.293 10.0509C5.39323 10.4405 5.30745 10.8531 5.05948 11.1743L4.42207 11.9999" stroke="#0C1321" stroke-width="1.5" stroke-linecap="round"></path>
                                                        </g>
                                                        </svg>

                                                </span>
                                                <?php echo e(__('translate.Add')); ?>

                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>
                    </div>
                </div>
            </section>
        <?php endif; ?>


        <!-- Popular part end -->


        <!-- cta part start -->

        <section class="cta" data-aos="fade-up" data-aos-delay="100">
            <div class="container cta_bg ">

                <div class="row">
                    <div class="col-xxl-6">
                        <div class="cta_txt">

                            <span class="icon">
                                <svg width="108" height="108" viewBox="0 0 108 108" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.16" fill-rule="evenodd" clip-rule="evenodd"
                                          d="M38.9975 23.0679C41.7085 37.515 53.7743 53.9161 53.7743 53.9161C53.7743 53.9161 67.1605 35.7204 68.9017 20.7776C69.1487 19.575 69.279 18.3245 69.279 17.0409C69.279 7.62945 62.2749 0 53.6349 0C44.9949 0 37.9908 7.62945 37.9908 17.0409C37.9908 19.1628 38.3469 21.1941 38.9975 23.0679ZM53.7546 53.9397C52.0252 52.6924 36.6849 41.8382 23.0754 39.2813C21.1995 38.6291 19.1656 38.2721 17.0409 38.2721C7.62945 38.2721 0 45.2762 0 53.9162C0 62.5561 7.62945 69.5602 17.0409 69.5602C18.3203 69.5602 19.5667 69.4308 20.7656 69.1854C34.2438 67.6201 50.3736 56.5734 53.4099 54.4201C51.2604 57.4507 40.2153 73.5759 38.6446 87.0545C38.3976 88.2571 38.2673 89.5076 38.2673 90.7914C38.2673 100.203 45.2714 107.832 53.9113 107.832C62.5513 107.832 69.5554 100.203 69.5554 90.7914C69.5554 88.6694 69.1993 86.6381 68.5488 84.7643C66.116 71.8003 56.1507 57.263 54.1302 54.4148C57.1409 56.5508 73.2916 67.6204 86.7848 69.1873C87.9836 69.4327 89.23 69.5621 90.5094 69.5621C99.9208 69.5621 107.55 62.558 107.55 53.9181C107.55 45.2781 99.9208 38.274 90.5094 38.274C88.3847 38.274 86.3508 38.631 84.475 39.2832C70.8568 41.8416 55.5057 52.7079 53.7923 53.944C53.7788 53.9255 53.7719 53.9161 53.7719 53.9161C53.7719 53.9161 53.7661 53.9241 53.7546 53.9397Z"
                                          fill="url(#paint0_linear_585_38982)"/>
                                    <defs>
                                        <linearGradient id="paint0_linear_585_38982" x1="53.7751" y1="0" x2="53.7751"
                                                        y2="107.832" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="white">
                                                <stop offset="1" stop-color="white" stop-opacity="0"/>
                                        </linearGradient>
                                    </defs>
                                </svg>

                            </span>


                            <h2><?php echo strip_tags(clean($home_translate->join_restaurant_title),'<span>'); ?></h2>

                            <p><?php echo e($home_translate->join_restaurant_des); ?></p>


                            <a href="<?php echo e(route('apply-for-restaurant')); ?>" class="thm-btn_two">
                                <?php echo e(__('translate.Apply')); ?>

                            </a>
                        </div>
                    </div>

                    <div class="col-xxl-6">
                        <div class="cta_thumb_main">

                            <span class="icon">
                                <svg width="137" height="137" viewBox="0 0 137 137" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path opacity="0.2"
                                          d="M66.0611 2.58709C66.3897 -0.526289 70.9214 -0.526272 71.2499 2.58711L74.7955 36.1887C75.0461 38.5639 78.092 39.3815 79.4984 37.4511L99.4076 10.1233C101.251 7.59266 105.174 9.86289 103.899 12.7223L90.1411 43.5613C89.1673 45.7442 91.3976 47.9784 93.5822 47.0085L124.487 33.2875C127.35 32.0167 129.613 35.9456 127.077 37.784L99.7359 57.6076C97.7993 59.0117 98.6158 62.0643 100.995 62.3142L134.604 65.8436C137.719 66.1707 137.719 70.7055 134.604 71.0327L100.995 74.5621C98.6158 74.8119 97.7993 77.8646 99.7359 79.2687L127.077 99.0923C129.613 100.931 127.35 104.86 124.487 103.589L93.5822 89.8678C91.3976 88.8979 89.1673 91.1321 90.1411 93.315L103.899 124.154C105.174 127.013 101.251 129.284 99.4076 126.753L79.4984 99.4252C78.092 97.4947 75.0461 98.3123 74.7955 100.688L71.2499 134.289C70.9214 137.403 66.3897 137.403 66.0611 134.289L62.5156 100.688C62.2649 98.3123 59.219 97.4947 57.8126 99.4252L37.9035 126.753C36.0598 129.284 32.1368 127.013 33.4124 124.154L47.1699 93.315C48.1437 91.1321 45.9135 88.8979 43.7289 89.8678L12.8238 103.589C9.96138 104.86 7.69835 100.931 10.2339 99.0923L37.5752 79.2687C39.5117 77.8646 38.6952 74.8119 36.3163 74.5621L2.70675 71.0327C-0.40836 70.7055 -0.408363 66.1707 2.70675 65.8436L36.3163 62.3142C38.6952 62.0643 39.5117 59.0117 37.5752 57.6076L10.2339 37.784C7.69836 35.9456 9.96138 32.0167 12.8238 33.2875L43.7289 47.0085C45.9135 47.9784 48.1437 45.7442 47.1699 43.5613L33.4124 12.7223C32.1368 9.8629 36.0598 7.59264 37.9035 10.1233L57.8126 37.451C59.219 39.3815 62.2649 38.5639 62.5156 36.1887L66.0611 2.58709Z"
                                          fill="url(#paint0_linear_585_38981)"/>
                                    <defs>
                                        <linearGradient id="paint0_linear_585_38981" x1="68.6555" y1="-22" x2="68.6555"
                                                        y2="158.876" gradientUnits="userSpaceOnUse">
                                            <stop stop-color="white" stop-opacity="0.4"/>
                                            <stop offset="1" stop-color="white" stop-opacity="0"/>
                                        </linearGradient>
                                    </defs>
                                </svg>
                            </span>

                            <span class="icon_two">
                                <svg width="156" height="140" viewBox="0 0 156 140" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <g opacity="0.39">
                                        <path
                                            d="M107.596 128.647C95.5828 135.108 81.8687 137.707 68.3239 136.089C54.7791 134.472 42.0629 128.716 31.9091 119.607C21.7553 110.497 14.6581 98.478 11.5852 85.1876C8.51227 71.8972 9.61318 57.9824 14.7378 45.3406L15.357 45.5916C10.284 58.106 9.19413 71.8806 12.2361 85.0371C15.2781 98.1936 22.3038 110.092 32.3553 119.109C42.4068 128.127 54.9949 133.825 68.4032 135.426C81.8115 137.028 95.3874 134.455 107.28 128.058L107.596 128.647Z"
                                            fill="white"/>
                                        <path
                                            d="M44.7786 11.8549C56.7922 5.3933 70.5063 2.79419 84.0511 4.41197C97.5959 6.02975 110.312 11.7857 120.466 20.8949C130.62 30.0042 137.717 42.0234 140.79 55.3138C143.863 68.6043 142.762 82.519 137.637 95.1609L137.018 94.9099C142.091 82.3954 143.181 68.6209 140.139 55.4643C137.097 42.3078 130.071 30.4097 120.02 21.3922C109.968 12.3747 97.3801 6.6768 83.9718 5.07533C70.5635 3.47386 56.9876 6.04677 45.0951 12.4433L44.7786 11.8549Z"
                                            fill="white"/>
                                        <path
                                            d="M44.2307 0.46582L44.4484 8.34838C44.5294 11.2846 46.8907 13.6459 49.8269 13.7269L57.7095 13.9446L49.8269 14.1622C46.8907 14.2433 44.5294 16.6045 44.4484 19.5408L44.2307 27.4233L44.0131 19.5408C43.932 16.6045 41.5708 14.2433 38.6345 14.1622L30.752 13.9446L38.6345 13.7269C41.5708 13.6459 43.932 11.2846 44.0131 8.34838L44.2307 0.46582Z"
                                            fill="white"/>
                                        <path
                                            d="M150.696 89.4656L143.436 92.5436C140.732 93.6901 139.394 96.7499 140.39 99.5134L143.063 106.932L139.985 99.6722C138.838 96.9679 135.778 95.6307 133.015 96.6262L125.596 99.2989L132.856 96.2209C135.56 95.0744 136.898 92.0145 135.902 89.251L133.229 81.8322L136.307 89.0922C137.454 91.7966 140.514 93.1338 143.277 92.1382L150.696 89.4656Z"
                                            fill="white"/>
                                        <path
                                            d="M109.344 139.692L108.989 131.815C108.857 128.88 106.455 126.56 103.518 126.53L95.6326 126.45L103.51 126.095C106.445 125.963 108.764 123.561 108.794 120.624L108.875 112.739L109.23 120.616C109.362 123.551 111.764 125.871 114.701 125.901L122.586 125.981L114.708 126.336C111.774 126.468 109.454 128.87 109.424 131.807L109.344 139.692Z"
                                            fill="white"/>
                                        <path
                                            d="M28.291 43.5457L20.4818 44.6404C17.5729 45.0481 15.4895 47.6578 15.7361 50.5848L16.3982 58.4425L15.3035 50.6333C14.8957 47.7243 12.2861 45.6409 9.35912 45.8876L1.5014 46.5496L9.31061 45.455C12.2195 45.0472 14.3029 42.4376 14.0563 39.5106L13.3942 31.6528L14.4889 39.4621C14.8967 42.371 17.5063 44.4544 20.4333 44.2078L28.291 43.5457Z"
                                            fill="white"/>
                                    </g>
                                </svg>

                            </span>


                            <div class="cta_thumb">
                                <img src="<?php echo e(asset($homepage->join_restaurant_image)); ?>" alt="thumb">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- cta part end -->

        <!-- blog part start -->

        <?php if(!empty($blogs)): ?>
            <section class="blog">
                <div class="container">
                    <div class="row mb_25px ">
                        <div class="col-xxl-12 text-center" data-aos="fade-down" data-aos-delay="50">
                            <h2 class="titel"><?php echo e(__('translate.Explore Our latest news')); ?> </h2>
                        </div>
                    </div>

                    <div class="row g-4">
                        <?php $__empty_1 = true; $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <div class="col-xxl-4 col-sm-6 col-lg-4" data-aos="fade-right" data-aos-delay="100">
                                <div class="blog_item">
                                    <div class="blog_item_thumb_main">
                                        <div class="blog_item_thumb">
                                            <img src="<?php echo e(asset($blog->image)); ?>"
                                                 alt="thumb">
                                        </div>


                                        <div class="blog_item_thumb_over">
                                            <div class="blog_item_thumb_over_txt">
                                                <h6><?php echo e($blog->category->name); ?></h6>
                                                <span class="dot"></span>
                                                <p><?php echo e($blog->created_at->format('F j, Y')); ?></p>
                                            </div>

                                        </div>


                                    </div>

                                    <div class="blog_item_inner">
                                        <h4>
                                            <a href="<?php echo e(route('blog.details', $blog->slug)); ?>"><?php echo e($blog->title); ?></a>
                                        </h4>


                                        <a href="<?php echo e(route('blog.details', $blog->slug)); ?>" class="blog_inner_btn">
                                           <?php echo e(__('translate. Read More')); ?>


                                            <span>
                                        <svg width="5" height="10" viewBox="0 0 5 10" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                            <path fill-rule="evenodd" clip-rule="evenodd"
                                                  d="M0.443573 0.344988C0.174034 0.560619 0.130333 0.953927 0.345964 1.22347L3.36695 4.9997L0.345964 8.77593C0.130333 9.04547 0.174034 9.43878 0.443573 9.65441C0.713111 9.87004 1.10642 9.82634 1.32205 9.5568L4.65538 5.39013C4.83799 5.16187 4.83799 4.83753 4.65538 4.60926L1.32205 0.442596C1.10642 0.173058 0.713112 0.129357 0.443573 0.344988Z"/>
                                        </svg>

                                    </span>
                                        </a>

                                    </div>


                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <?php endif; ?>
                    </div>
                </div>
            </section>
        <?php endif; ?>
        <!-- blog part end -->

        <!-- mobile app  part start -->
        <?php echo $__env->make('frontend.layouts.partials.mobile_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- mobile app  part end -->

    </main>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\foodkhabo\resources\views/frontend/about/index.blade.php ENDPATH**/ ?>